/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="tinkers_advanced", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TiAcConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_BASE_BOOST;
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_FLUID_BOOST;
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_AOE_SPEED;
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_BASE_RANGE;
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_CAPACITY_FACTOR;
        public final ForgeConfigSpec.DoubleValue MATTER_MANIPULATOR_FLUID_EFFICIENCY;
        public final ForgeConfigSpec.BooleanValue MATTER_MANIPULATOR_FLUID_ENCHANTING;
        public final ForgeConfigSpec.BooleanValue MATTER_MANIPULATOR_CANCEL_SLOWDOWN;
        public final ForgeConfigSpec.BooleanValue EXPLODING_FUSION_REACTOR;
        public final ForgeConfigSpec.DoubleValue IONIZED_CANNON_FLUID_FACTOR;
        public final ForgeConfigSpec.DoubleValue IONIZED_CANNON_DAMAGE_BONUS;
        public final ForgeConfigSpec.DoubleValue IONIZED_CANNON_BASE_RANGE;
        public final ForgeConfigSpec.DoubleValue IONIZED_CANNON_BASE_SCALE;
        public final ForgeConfigSpec.DoubleValue IONIZED_CANNON_BASE_FLUID_EFFICIENCY;
        public final ForgeConfigSpec.IntValue IONIZED_CANNON_BASE_CHARGE_TIME;
        public final ForgeConfigSpec.BooleanValue IONIZED_CANNON_PIERCE_FROM_IMPALING;
        public final ForgeConfigSpec.IntValue SHAPING_MAX_SLOT;
        public final ForgeConfigSpec.IntValue SHAPING_DAMAGES_EACH_SLOT;
        public final ForgeConfigSpec.IntValue PROTO_REFINING_BONUS_LEVEL;
        public final ForgeConfigSpec.IntValue PROTO_REFINING_TIMES_REQUIRED;
        public final ForgeConfigSpec.DoubleValue IRRADIUM_RADIATION_INFLICT;
        public final ForgeConfigSpec.DoubleValue IRRADIUM_MAX_BONUS;
        public final ForgeConfigSpec.DoubleValue IRRADIUM_BONUS_PER_Sv;
        public final ForgeConfigSpec.DoubleValue FRAGILE_CHANCE;
        public final ForgeConfigSpec.IntValue FRAGILE_EXTRA_COST;
        public final ForgeConfigSpec.DoubleValue REACTIVE_EXPLOSIVE_ARMOR_REDUCTION;
        public final ForgeConfigSpec.BooleanValue REACTIVE_EXPLOSIVE_ARMOR_IMMUNITY;
        public final ForgeConfigSpec.IntValue NUTRITIVE_SLIME_COST;
        public final ForgeConfigSpec.IntValue NUTRITIVE_SLIME_RECOVER;
        public final ForgeConfigSpec.DoubleValue RETURN_TO_SLIME_CHANCE;
        public final ForgeConfigSpec.DoubleValue ELECTRON_TUNER_ATTACK_SPEED_ADJUSTABLE_RANGE;
        public final ForgeConfigSpec.DoubleValue ELECTRON_TUNER_ATTACK_DAMAGE_ADJUSTABLE_RANGE;
        public final ForgeConfigSpec.BooleanValue ELECTRON_TUNER_SPECIAL_BONUS;
        public final ForgeConfigSpec.IntValue COMBUSTION_GENERATOR_BASIC_GENERATION;
        public final ForgeConfigSpec.IntValue COMBUSTION_GENERATOR_GENERATION_EACH_BURNING_TIME;
        public final ForgeConfigSpec.IntValue OVERSLIME_GENERATOR_BASIC_GENERATION;
        public final ForgeConfigSpec.IntValue OVERSLIME_GENERATOR_GENERATION_EACH_OVERSLIME;
        public final ForgeConfigSpec.IntValue PIEZOELECTRIC_EFFECT_BASIC_GENERATION;
        public final ForgeConfigSpec.IntValue PIEZOELECTRIC_EFFECT_GENERATION_EACH_DAMAGE;
        public final ForgeConfigSpec.IntValue ELECTRIC_FOOD_BASIC_CONSUMPTION;
        public final ForgeConfigSpec.IntValue ELECTRIC_FOOD_CONSUMPTION_EACH_FOODLEVEL;
        public final ForgeConfigSpec.DoubleValue TRANSITION_CATALYST_BONUS;
        public final ForgeConfigSpec.DoubleValue PLATINOID_CATALYST_BONUS;
        public final ForgeConfigSpec.IntValue ELECTRON_TUNER_CONSUMPTION;
        public final ForgeConfigSpec.IntValue SMELTERY_GENERATOR_BASIC_GENERATION;
        public final ForgeConfigSpec.IntValue SMELTERY_GENERATOR_EACH_BURNING_TIME;
        public final ForgeConfigSpec.DoubleValue SMELTERY_GENERATOR_TEMPERATURE_MULTIPLIER;
        public final ForgeConfigSpec.DoubleValue ANNIHILATE_EXPLOSION_ATTACK_MULTIPLIER;
        public final ForgeConfigSpec.DoubleValue ANNIHILATE_EXPLOSION_SELF_MULTIPLIER;
        public final ForgeConfigSpec.IntValue COMPRESSED_AIR_GENERATON_BASIC_GENERATION;
        public final ForgeConfigSpec.IntValue DISINTEGRATE_EACH_BONUS;
        public final ForgeConfigSpec.IntValue DISINTEGRATE_MAX_BONUS;
        public final ForgeConfigSpec.IntValue DISINTEGRATE_EACH_DECREASE;
        public final ForgeConfigSpec.DoubleValue VOID_DODGING_CHANCE;
        public final ForgeConfigSpec.IntValue FLUX_INFUSE_CONSUMPTION;
        public final ForgeConfigSpec.IntValue FLUX_SLASH_CONSUMPTION;
        public final ForgeConfigSpec.DoubleValue FLUX_SLASH_FLUX_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FLUX_SLASH_BASIC_SLASH_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FLUX_SLASH_SLASH_DAMAGE_PER_SHARPNESS;
        public final ForgeConfigSpec.DoubleValue FLUX_SLASH_SLASH_DAMAGE_FROM_ATTACK_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FLUX_SLASH_DIG_SPEED_BONUS;
        public final ForgeConfigSpec.IntValue FLUX_ARROW_CONSUMPTION;
        public final ForgeConfigSpec.DoubleValue FLUX_ARROW_BASE_EXPLOSION_DAMAGE;
        public final ForgeConfigSpec.DoubleValue FLUX_ARROW_EXPLOSION_DAMAGE_FROM_DAMAGE;
        public final ForgeConfigSpec.IntValue FLUX_ARMOR_CONSUMPTION;
        public final ForgeConfigSpec.DoubleValue FLUX_ARMOR_DODGE_RATE;
        public final ForgeConfigSpec.DoubleValue FLUX_ARMOR_DAMAGE_REDUCTION;
        public final ForgeConfigSpec.DoubleValue EFFECT_TETANUS_DAMAGE_MULTIPLIER;
        public final ForgeConfigSpec.DoubleValue EFFECT_PROTO_POISON_HEALTH_DECREASE;
        public final ForgeConfigSpec.DoubleValue EFFECT_PROTO_POISON_REGENERATION_DECREASE;
        public final ForgeConfigSpec.DoubleValue EFFECT_PLAGUE_DAMAGE;
        public final ForgeConfigSpec.DoubleValue EFFECT_PLAGUE_REGENERATION_DECREASE;
        public final ForgeConfigSpec.BooleanValue ALLOW_BISMUTHINITE;
        public final ForgeConfigSpec.BooleanValue ALLOW_STIBNITE;
        public final ForgeConfigSpec.BooleanValue ALLOW_LEAN_IRIDIUM;
        public final ForgeConfigSpec.BooleanValue ALLOW_STIBNITE_UNSTABLE;
        public final ForgeConfigSpec.IntValue CINDER_SLIME_FAUCET_SPEED;
        public final ForgeConfigSpec.IntValue IRIDIUM_FAUCET_SPEED;
        public final ForgeConfigSpec.DoubleValue CINDER_SLIME_CASTING_INCREASE;
        public final ForgeConfigSpec.DoubleValue CINDER_SLIME_CASTING_DECREASE;
        public final ForgeConfigSpec.IntValue CINDER_SLIME_TABLE_SEPARATION;
        public final ForgeConfigSpec.IntValue CINDER_SLIME_BASIN_SEPARATION;
        public final ForgeConfigSpec.DoubleValue IRIDIUM_CASTING_SPEED;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("***\u6ce8\u610f\uff01").comment("***Notice").comment("\u8fd9\u4e9b\u914d\u7f6e\u5e76\u4e0d\u4f1a\u540c\u6b65\u4fee\u6539\u8bed\u8a00\u6587\u4ef6\u4e2d\u7684\u63cf\u8ff0\uff0c\u5f53\u4f60\u4fee\u6539\u4e86\u67d0\u4e2a\u5de5\u5177/\u5de5\u5177\u5c5e\u6027\u7684\u6027\u8d28\u540e\u5982\u679c\u60f3\u8981\u66f4\u6539\u63cf\u8ff0\u5219\u9700\u8981\u624b\u52a8\u8986\u76d6\u8bed\u8a00\u6587\u4ef6\uff01").comment("This configure won't affect language display. When a certain modifier or tool is configured, please manually replace the description of the relating language contents.");
            builder.comment("Worldgen").comment("\u4e16\u754c\u751f\u6210").push("worldgen");
            this.ALLOW_BISMUTHINITE = builder.comment("Allows Bismuthinite generation, true by default.").comment("\u5141\u8bb8\u8f89\u94cb\u77ff\u751f\u6210\uff0c\u9ed8\u8ba4\u662f\u3002").define("allow_bismuthinite", true);
            this.ALLOW_STIBNITE = builder.comment("Allows Stibnite generation, true by default.").comment("\u5141\u8bb8\u8f89\u9511\u77ff\u751f\u6210\uff0c\u9ed8\u8ba4\u662f\u3002").define("allow_stibnite", true);
            this.ALLOW_STIBNITE_UNSTABLE = builder.comment("Allows Unstable Stibnite generation when mining Stibnite, true by default.").comment("\u5141\u8bb8\u6316\u6398\u8f89\u9511\u77ff\u65f6\u4f7f\u5468\u56f4\u7684\u8f89\u9511\u77ff\u5728\u7a33\u5b9a\u548c\u4e0d\u7a33\u5b9a\u4e4b\u95f4\u5207\u6362\uff0c\u9ed8\u8ba4\u662f\u3002").define("allow_stibnite_unstable", true);
            this.ALLOW_LEAN_IRIDIUM = builder.comment("Allows Iridium generation, true by default.").comment("\u5141\u8bb8\u8d2b\u94f1\u77ff\u751f\u6210\uff0c\u9ed8\u8ba4\u662f\u3002").define("allow_iridium", true);
            builder.pop();
            builder.comment("Modifiers behaviour").comment("\u8bcd\u6761\u6027\u8d28").push("modifier_behaviour");
            builder.comment("Shaping").comment("\u5851\u6027");
            this.SHAPING_MAX_SLOT = builder.comment("Max upgrade slot bonus for Shaping modifier, 3 by default.").comment("\u6700\u5927\u52a0\u69fd\uff0c\u9ed8\u8ba43\u3002").defineInRange("shaping_max_slot", 3, 1, Integer.MAX_VALUE);
            this.SHAPING_DAMAGES_EACH_SLOT = builder.comment("How many durability loss is needed for Shaping modifier to gain 1 slot, 500 by default.").comment("\u78e8\u635f\u591a\u5c11\u8010\u4e45\u624d\u52a01\u5347\u7ea7\u69fd\uff0c\u9ed8\u8ba4500\u3002").defineInRange("shaping_damages_each_slot", 500, 1, Integer.MAX_VALUE);
            builder.comment("Proto Refining").comment("\u539f\u4f53\u7cbe\u70bc");
            this.PROTO_REFINING_BONUS_LEVEL = builder.comment("Bonus enchantment level each trait level for Proto Refining, 3 by default.").comment("\u6bcf\u7ea7\u6700\u5927\u65f6\u8fd0\u589e\u76ca\uff0c\u9ed8\u8ba43\u3002").defineInRange("proto_refining_bonus", 3, 0, Integer.MAX_VALUE);
            this.PROTO_REFINING_TIMES_REQUIRED = builder.comment("How many times needed for Proto Refining to gain bonus, 5 by default.").comment("\u6316\u591a\u5c11\u6b21\u589e\u52a01\u7ea7\u65f6\u8fd0\uff0c\u9ed8\u8ba45\u3002").defineInRange("proto_refining_requirement", 5, 1, Integer.MAX_VALUE);
            builder.comment("Radiation Burning and Radioactive Armor").comment("\u956d\u5149\u5408\u91d1\u76f8\u5173");
            this.IRRADIUM_MAX_BONUS = builder.comment("Max bonus for Radiation Burning and Radioactive Armor, 0.75 by default.").comment("\u6700\u5927\u589e\u76ca\uff0c\u9ed8\u8ba40.75\u3002").defineInRange("irradium_max_bonus", 0.75, 0.0, 1.0);
            this.IRRADIUM_RADIATION_INFLICT = builder.comment("Radiation amount for Radiation Burning and Radioactive Armor each trait level, 1.0 Sv by default.").comment("\u8f90\u5c04\u65bd\u52a0\uff0c\u9ed8\u8ba41.0Sv\u3002").defineInRange("irradium_radiation_inflict", 1.0, 0.0, Double.MAX_VALUE);
            this.IRRADIUM_BONUS_PER_Sv = builder.comment("Bonus for Radiation Burning and Radioactive Armor each Sv, 0.05 by default.").comment("\u6bcfSv\u8f90\u5c04\u9020\u6210\u7684\u589e\u5e45\uff0c\u9ed8\u8ba40.05\u3002").defineInRange("irradium_bonus_per_sv", 0.05, 0.0, 1.0);
            builder.comment("Fragile").comment("\u8106\u6027");
            this.FRAGILE_CHANCE = builder.comment("Chance for extra durability draw for Fragile Modifier, 0.1 by default.").comment("\u8106\u6027\u989d\u5916\u6d88\u8017\u8010\u4e45\u7684\u6982\u7387\uff0c\u9ed8\u8ba40.1\u3002").defineInRange("fragile_chance", 0.1, 0.0, 1.0);
            this.FRAGILE_EXTRA_COST = builder.comment("Extra durability cost for Fragile, 1 by default.").comment("\u989d\u5916\u6d88\u8017\u7684\u8010\u4e45\uff0c\u9ed8\u8ba41\u3002").defineInRange("fragile_cost", 1, 0, Integer.MAX_VALUE);
            builder.comment("Reactive Explosive Armor");
            this.REACTIVE_EXPLOSIVE_ARMOR_IMMUNITY = builder.comment("Allows Reactive Explosive Armor Modifier to block explosion and fire damage, true by default.").define("reactive_explosive_armor_immunity", true);
            this.REACTIVE_EXPLOSIVE_ARMOR_REDUCTION = builder.comment("Damage Reduction for Reactive Explosive Armor, 0.25 by default.").defineInRange("reactive_explosive_armor_reduction", 0.25, 0.0, 1.0);
            builder.comment("Nutritive Slime").comment("\u8425\u517b\u9ecf\u6db2");
            this.NUTRITIVE_SLIME_COST = builder.comment("Overslime consumption for each food level, 20 by default.").comment("\u6bcf\u70b9\u9971\u98df\u5ea6\u9700\u8981\u7684\u9ecf\u6db2\u8986\u5c42\u6d88\u8017\u91cf\uff0c\u9ed8\u8ba420\u3002").defineInRange("nutritive_slime_cost", 20, 0, Integer.MAX_VALUE);
            this.NUTRITIVE_SLIME_RECOVER = builder.comment("Food level to add each trait level, 1 by default.").comment("\u6bcf\u7ea7\u4e00\u6b21\u6027\u52a0\u7684\u9971\u98df\u5ea6\uff0c\u9ed8\u8ba41\u3002").defineInRange("nutritive_slime_recover", 1, 0, Integer.MAX_VALUE);
            builder.comment("Return to Slime").comment("\u4e07\u7269\u5f52\u4e8e\u9ecf\u6db2");
            this.RETURN_TO_SLIME_CHANCE = builder.comment("Overslime recover chance for Return to Slime each trait level, 20% by default.").comment("\u6062\u590d\u9ecf\u6db2\u8986\u5c42\u7684\u6982\u7387\uff0c\u9ed8\u8ba420%").defineInRange("return_to_slime_chance", 0.2, 0.0, 1.0);
            builder.comment("Annihilation").comment("\u6e6e\u706d");
            this.ANNIHILATE_EXPLOSION_ATTACK_MULTIPLIER = builder.comment("Explosion damage multiplier for Annihilation Modifier, 5 by default.").comment("\u6e6e\u706d\u8bcd\u6761\u9020\u6210\u7684\u7206\u70b8\u4f24\u5bb3\u500d\u7387\uff0c\u9ed8\u8ba45\u500d\u3002").defineInRange("annihilation_attack_multiplier", 5.0, 0.0, 2.147483647E9);
            this.ANNIHILATE_EXPLOSION_SELF_MULTIPLIER = builder.comment("Explosion damage multiplier that deals to attacker, 2.5 by default.").comment("\u6e6e\u706d\u8bcd\u6761\u5bf9\u81ea\u5df1\u9020\u6210\u7684\u7206\u70b8\u4f24\u5bb3\u500d\u7387\uff0c\u9ed8\u8ba42.5\u500d").defineInRange("annihilation_attack_self_multiplier", 2.5, 0.0, 2.147483647E9);
            builder.comment("Disintegrate").comment("\u89e3\u79bb");
            this.DISINTEGRATE_EACH_BONUS = builder.comment("Bonus each block mined (%), 20(%) by default").comment("\u6316\u6398\u6bcf\u4e2a\u65b9\u5757\u5e26\u6765\u7684\u52a0\u6210\uff08\u5355\u4f4d\u4e3a%\uff09\uff0c\u9ed8\u8ba420%\u3002\u6ce8\uff1a\u8010\u4e45\u60e9\u7f5a\u662f\u52a0\u6210\u7684\u4e00\u534a\u3002").defineInRange("disintegrate_each_bonus", 20, 0, Integer.MAX_VALUE);
            this.DISINTEGRATE_MAX_BONUS = builder.comment("Max bonus, 2000% by default.").comment("\u6700\u5927\u52a0\u6210\uff08\u5355\u4f4d\u4e3a%\uff09\uff0c\u9ed8\u8ba42000%\u3002").defineInRange("disintegrate_max_bonus", 2000, 0, Integer.MAX_VALUE);
            this.DISINTEGRATE_EACH_DECREASE = builder.comment("Clear bonus after ticks of stopping, 5s by default.").comment("\u505c\u6b62\u6316\u6398\u591a\u4e45\u540e\u6e05\u9664\u52a0\u6210\uff0c\u9ed8\u8ba45\u79d2\u3002").defineInRange("disintegrate_each_decrease", 5, 0, Integer.MAX_VALUE);
            builder.comment("Void Dodging").comment("\u865a\u65e0\u95ea\u907f");
            this.VOID_DODGING_CHANCE = builder.comment("Chance for dodging arrow each level, 0.25 by default.").comment("\u6bcf\u7ea7\u95ea\u907f\u7bad\u77e2\u7684\u6982\u7387\uff0c\u9ed8\u8ba40.25\u3002").defineInRange("void_dodging_chance", 0.25, 0.0, 1.0);
            builder.comment("Flux Infuse").comment("\u901a\u91cf\u6ce8\u5165");
            this.FLUX_INFUSE_CONSUMPTION = builder.comment("\u901a\u91cf\u6ce8\u5165\u62b5\u6d88\u8010\u4e45\u6d88\u8017\u9700\u8981\u7684\u80fd\u91cf\uff0c\u9ed8\u8ba4500FE").comment("FE required for each durability loss, 500FE by default").defineInRange("flux_infuse_consumption", 500, 0, Integer.MAX_VALUE);
            builder.comment("Flux Slash").comment("\u901a\u91cf\u8d4b\u80fd-\u8fd1\u6218");
            this.FLUX_SLASH_CONSUMPTION = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u57fa\u7840\u6d88\u8017\uff08\u901a\u91cf\u4f24\u5bb3\u6d88\u8017\u91c7\u7528\u6b64\u503c\uff0c\u5251\u6c14\u6d88\u8017\u4e3a\u6b64\u503c\u76842\u500d\uff09\uff0c\u9ed8\u8ba4250FE").comment("Basic consumption for Flux Slash, 250FE by default.").defineInRange("flux_slash_consumption", 250, 0, Integer.MAX_VALUE);
            this.FLUX_SLASH_FLUX_DAMAGE = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u989d\u5916\u901a\u91cf\u4f24\u5bb3\uff0c\u9ed8\u8ba44").comment("Additional Flux damage for Flux Slash, 4 by default.").defineInRange("flux_slash_flux_damage", 4.0, 0.0, 3.4028234663852886E38);
            this.FLUX_SLASH_BASIC_SLASH_DAMAGE = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u5251\u6c14\u57fa\u7840\u4f24\u5bb3\uff0c\u9ed8\u8ba44").comment("Base damage for the slash from Flux Slash, 4 by default.").defineInRange("flux_slash_base_slash_damage", 4.0, 0.0, 3.4028234663852886E38);
            this.FLUX_SLASH_SLASH_DAMAGE_PER_SHARPNESS = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u5251\u6c14\u53d7\u950b\u5229\u8bcd\u6761\u7684\u4f24\u5bb3\u52a0\u6210\uff0c\u9ed8\u8ba40.5\u6bcf\u7ea7").comment("Sharpness modifier bonus damage for Slash from Flux Slash, 0.5 by default.").defineInRange("flux_slash_damage_per_sharpness", 0.5, 0.0, 3.4028234663852886E38);
            this.FLUX_SLASH_SLASH_DAMAGE_FROM_ATTACK_DAMAGE = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u5251\u6c14\u7ee7\u627f\u81ea\u5de5\u5177\u4f24\u5bb3\u7684\u4f24\u5bb3\u6bd4\u4f8b\uff0c\u9ed8\u8ba40x").comment("Damage bonus from tool's attack damage, 0x by default.").defineInRange("flux_slash_damage_from_attack_damage", 0.0, 0.0, 3.4028234663852886E38);
            this.FLUX_SLASH_DIG_SPEED_BONUS = builder.comment("\u901a\u91cf\u65a9\u51fb\u7684\u6316\u6398\u52a0\u901f\uff08\u6ce8\u80fd\u6a21\u5f0f\u4e0b\u4e3a\u6b64\u503c2\u500d\uff09\uff0c\u9ed8\u8ba4100%").comment("Mining boost for Flux Slash, 100% by default.").defineInRange("flux_slash_dig_speed_bonus", 1.0, 0.0, 3.4028234663852886E38);
            builder.comment("Flux Arrow").comment("\u901a\u91cf\u8d4b\u80fd-\u8fdc\u7a0b");
            this.FLUX_ARROW_CONSUMPTION = builder.comment("\u901a\u91cf\u7bad\u77e2\u7684\u57fa\u7840\u6d88\u8017\uff08\u7bad\u77e2\u589e\u4f24\u6d88\u8017\u91c7\u7528\u6b64\u503c\uff0c\u4ea7\u751f\u7bad\u77e2\u6d88\u8017\u4e3a\u6b64\u503c\u76842\u500d\uff0c\u7bad\u77e2\u7206\u70b8\u4e3a\u6b64\u503c\u76843\u500d\uff0c\u590d\u5236\u836f\u6c34\u7bad\u6d88\u8017\u4e3a\u6b64\u503c\u76844\u500d\uff09\uff0c\u9ed8\u8ba4250FE").comment("Basic consumption for Flux Arrow, 250FE by default.").defineInRange("flux_arrow_consumption", 250, 0, Integer.MAX_VALUE);
            this.FLUX_ARROW_BASE_EXPLOSION_DAMAGE = builder.comment("\u901a\u91cf\u7bad\u77e2\u7684\u7206\u70b8\u4f24\u5bb3\uff0c\u9ed8\u8ba45").comment("Arrow explosion damage for Flux Arrow, 5 by default.").defineInRange("flux_arrow_explosion_damage", 5.0, 0.0, 3.4028234663852886E38);
            this.FLUX_ARROW_EXPLOSION_DAMAGE_FROM_DAMAGE = builder.comment("\u901a\u91cf\u7bad\u77e2\u7206\u70b8\u53d7\u5230\u7bad\u77e2\u4f24\u5bb3\u7684\u589e\u5e45\uff0c\u9ed8\u8ba40x").comment("Additional damage for the arrow explosion boosted by arrow damage from Flux Arrow, 0x by default.").defineInRange("flux_arrow_explosion_damage_from_arrow_damage", 0.0, 0.0, 3.4028234663852886E38);
            builder.comment("Flux Armor").comment("\u901a\u91cf\u8d4b\u80fd-\u62a4\u7532");
            this.FLUX_ARMOR_CONSUMPTION = builder.comment("\u901a\u91cf\u62a4\u7532\u7684\u57fa\u7840\u6d88\u8017\uff08\u51cf\u4f24\u6d88\u8017\u91c7\u7528\u6b64\u503c\uff0c\u95ea\u907f\u6d88\u8017\u4e3a\u6b64\u503c\u768410\u500d\uff09\uff0c\u9ed8\u8ba42000FE").comment("Basic consumption for Flux Armor, 2000FE by default.").defineInRange("flux_armor_consumption", 2000, 0, Integer.MAX_VALUE);
            this.FLUX_ARMOR_DAMAGE_REDUCTION = builder.comment("\u901a\u91cf\u62a4\u7532\u7684\u4f24\u5bb3\u51cf\u514d\uff0c\u9ed8\u8ba40.2x").comment("Damage Reduction for Flux Armor, 0.2x by default.").defineInRange("flux_armor_damage_reduction", 0.2, 0.0, 1.0);
            this.FLUX_ARMOR_DODGE_RATE = builder.comment("\u901a\u91cf\u62a4\u7532\u7684\u95ea\u907f\u7387\uff0c\u9ed8\u8ba40.05").comment("Dodge rate for Flux Armor, 0.05 by default.").defineInRange("flux_armor_dodge_rate", 0.05, 0.0, 1.0);
            builder.comment("Generator Modules").comment("\u80fd\u91cf\u6a21\u5757\u7c7b\u5f3a\u5316");
            this.COMBUSTION_GENERATOR_BASIC_GENERATION = builder.comment("Basic FE/t for each level of Combustion Generator Module, 200 by default").comment("\u71c3\u70e7\u5ba4\u80fd\u91cf\u6a21\u5757\u7684\u57fa\u7840\u6bcftick\u4ea7\u80fd\uff0c\u9ed8\u8ba4200FE/t\u3002").defineInRange("combustion_generator_generation", 200, 0, Integer.MAX_VALUE);
            this.COMBUSTION_GENERATOR_GENERATION_EACH_BURNING_TIME = builder.comment("Energy per burning time, affects the total FE generated by fuel item. 10 by default, in this case a single coal can produce 16.00 kFE.").comment("\u71c3\u6599\u6bcftick\u71c3\u70e7\u65f6\u95f4\u5e26\u6765\u7684\u603b\u4ea7\u80fd\uff0c\u9ed8\u8ba410FE\u3002\u6ce8\uff1a\u70e7\u70bc\u4e00\u4e2a\u7269\u54c1\u9700\u8981200 ticks\uff0c\u4e00\u4e2a\u7164\u70ad\u80fd\u70e78\u4e2a\u7269\u54c1\u4e5f\u5c31\u662f1600 ticks\uff0c\u8fd9\u4ee3\u8868\u9ed8\u8ba4\u914d\u7f6e\u4e0b\u4e00\u4e2a\u7164\u70ad\u80fd\u5e26\u676516.0kFE\u7684\u603b\u4ea7\u80fd\u3002").defineInRange("combustion_generator_total_factor", 10, 0, Integer.MAX_VALUE);
            this.OVERSLIME_GENERATOR_BASIC_GENERATION = builder.comment("Basic FE/t for each level of Overslime Generator Module, 250 by default").comment("\u51dd\u80f6\u7535\u5316\u5b66\u80fd\u91cf\u6a21\u5757\u7684\u57fa\u7840\u6bcftick\u4ea7\u51fa\uff0c\u9ed8\u8ba4250FE/t").defineInRange("overslime_generator_generation", 250, 0, Integer.MAX_VALUE);
            this.OVERSLIME_GENERATOR_GENERATION_EACH_OVERSLIME = builder.comment("Energy per overslime, 1000 by default.").comment("\u6bcf\u70b9\u9ecf\u6db2\u4ea7\u751f\u7684\u80fd\u91cf\uff0c\u9ed8\u8ba41kFE\u3002").defineInRange("overslime_generator_total_factor", 1000, 0, Integer.MAX_VALUE);
            this.PIEZOELECTRIC_EFFECT_BASIC_GENERATION = builder.comment("Basic FE/t for each level of Piezoelectric Effect modifier, 100 by default").comment("\u538b\u7535\u6548\u5e94\u7684\u57fa\u7840\u6bcftick\u4ea7\u80fd\uff0c\u9ed8\u8ba4100FE/t\u3002").defineInRange("piezoelectric_effect_generation", 100, 0, Integer.MAX_VALUE);
            this.PIEZOELECTRIC_EFFECT_GENERATION_EACH_DAMAGE = builder.comment("Energy per damage each level, 10 by default.").comment("\u6bcf\u7ea7\u6bcf\u70b9\u4f24\u5bb3\u4ea7\u751f\u7684\u80fd\u91cf\uff0c\u9ed8\u8ba410FE\u3002").defineInRange("piezoelectric_effect_generation_per_damage", 10, 0, Integer.MAX_VALUE);
            this.ELECTRIC_FOOD_BASIC_CONSUMPTION = builder.comment("Basic FE/t for each level of Electric Food modifier, 100 by default").comment("\u5145\u7535\u9971\u7684\u57fa\u7840\u6bcftick\u6d88\u8017\uff0c\u9ed8\u8ba4100FE/t\u3002").defineInRange("electric_food_consumption", 100, 0, Integer.MAX_VALUE);
            this.ELECTRIC_FOOD_CONSUMPTION_EACH_FOODLEVEL = builder.comment("Energy per food level, 25kFE by default.").comment("\u5145\u7535\u9971\u6062\u590d1\u9971\u98df\u5ea6\u9700\u8981\u7684\u80fd\u91cf\uff0c\u9ed8\u8ba425kFE\u3002").defineInRange("electric_food_total_consumption", 25000, 0, Integer.MAX_VALUE);
            this.TRANSITION_CATALYST_BONUS = builder.comment("Bonus for Transition Catalyst each trait level, 25% by default.").comment("\u8fc7\u6e21\u91d1\u5c5e\u50ac\u5316\u5242\u7684\u589e\u5e45\u6548\u679c\uff0c\u9ed8\u8ba425%\u3002").defineInRange("transition_catalyst_bonus", 0.25, 0.0, 2.147483647E9);
            this.PLATINOID_CATALYST_BONUS = builder.comment("Bonus for Platinoid Catalyst each trait level, 25% by default.").comment("\u94c2\u65cf\u50ac\u5316\u5242\u7684\u589e\u5e45\u6548\u679c\uff0c\u9ed8\u8ba425%\u3002").defineInRange("platinoid_catalyst_bonus", 0.25, 0.0, 2.147483647E9);
            this.SMELTERY_GENERATOR_BASIC_GENERATION = builder.comment("Basic FE/t for each level of Smeltery Generator modifier, 300 by default").comment("\u51b6\u70bc\u7089\u80fd\u91cf\u6a21\u5757\u57fa\u7840\u7684\u6bcftick\u80fd\u91cf\u4ea7\u51fa\u3002\u9ed8\u8ba4300 FE/t\u3002").defineInRange("smeltery_generator_generation", 300, 0, Integer.MAX_VALUE);
            this.SMELTERY_GENERATOR_EACH_BURNING_TIME = builder.comment("Energy per burning time, 10000 by default.").comment("\u6bcftick\u71c3\u70e7\u65f6\u957f\u5e26\u6765\u7684\u603b\u80fd\u91cf\u4ea7\u51fa\u3002\u9ed8\u8ba410kFE\u3002").defineInRange("smeltery_generator_generation_for_time", 10000, 0, Integer.MAX_VALUE);
            this.SMELTERY_GENERATOR_TEMPERATURE_MULTIPLIER = builder.comment("Power multiplier for fuel temp, 0.001 by default , meaning that a 2000\u2103 fuel makes FE/t times 2.").comment("\u71c3\u6599\u6e29\u5ea6\u5bf9\u4ea7\u80fd\u901f\u7387\u7684\u5f71\u54cd\u3002\u9ed8\u8ba40.001\uff0c\u610f\u5473\u77402000\u2103\u7684\u71c3\u6599\u4f1a\u5e26\u67652\u500d\u7684\u4ea7\u80fd\u901f\u5ea6\u3002").defineInRange("smeltery_generator_temperature_multiplier", 0.001, 0.0, 2.147483647E9);
            this.COMPRESSED_AIR_GENERATON_BASIC_GENERATION = builder.comment("Basic FE/t for each level of Compressed Air Generator modifier, 200 by default").comment("\u6c14\u52a8\u80fd\u91cf\u6a21\u5757\u57fa\u7840\u7684\u6bcftick\u80fd\u91cf\u4ea7\u51fa\uff0c\u9ed8\u8ba450FE/t\u3002\u6ce8\uff1a\u6700\u7ec8\u4ea7\u80fd\u4f1a\u4e58\u4ee5\u5de5\u5177\u538b\u529b\u3002").defineInRange("compressed_air_generator_generation", 50, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Effects").comment("\u72b6\u6001\u6548\u679c\u884c\u4e3a").push("mob_effect");
            this.EFFECT_TETANUS_DAMAGE_MULTIPLIER = builder.comment("Damage multiplier for Tetanus, 1.2 by default.").comment("\u7834\u4f24\u98ce\u6548\u679c\u5bfc\u81f4\u7684\u53d7\u51fb\u4f24\u5bb3\u500d\u7387\u3002\u9ed8\u8ba41.2\u3002").defineInRange("tetanus_damage_boost", 1.2, 0.0, 2.147483647E9);
            this.EFFECT_PROTO_POISON_HEALTH_DECREASE = builder.comment("Permanent health decrease for Proto poison, 25% by default.").comment("\u539f\u6bd2\u6548\u679c\u7684\u6c38\u4e45\u751f\u547d\u4e0a\u9650\u51cf\u5c11\uff0c\u9ed8\u8ba425%\u3002").defineInRange("proto_poison_health_decrease", 0.25, 0.0, 2.147483647E9);
            this.EFFECT_PROTO_POISON_REGENERATION_DECREASE = builder.comment("Regeneration reduction for Proto Poison each level, 20% by default").comment("\u539f\u6bd2\u6548\u679c\u7684\u6bcf\u7ea7\u751f\u547d\u518d\u751f\u51cf\u5c11\uff0c\u9ed8\u8ba420%\u3002").defineInRange("proto_poison_regen_decrease", 0.2, 0.0, 2.147483647E9);
            this.EFFECT_PLAGUE_DAMAGE = builder.comment("Damage for Plague each level, 2 by default.").comment("\u75ab\u6bd2\u6548\u679c\u7684\u4f24\u5bb3\uff0c\u9ed8\u8ba42\u3002").defineInRange("plague_health_decrease", 2.0, 0.0, 2.147483647E9);
            this.EFFECT_PLAGUE_REGENERATION_DECREASE = builder.comment("Regeneration reduction for Plague each level, 50% by default").comment("\u75ab\u6bd2\u6548\u679c\u7684\u6bcf\u7ea7\u751f\u547d\u518d\u751f\u51cf\u5c11\uff0c\u9ed8\u8ba450%\u3002").defineInRange("plague_regen_decrease", 0.5, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Tool Behaviour").comment("\u5de5\u5177\u884c\u4e3a").push("tool_behaviour");
            builder.comment("Matter Manipulator behaviour").comment("\u7269\u8d28\u64cd\u7eb5\u5668");
            this.MATTER_MANIPULATOR_BASE_BOOST = builder.comment("Base mining speed multiplier of Matter Manipulator, 1.0 by default.").comment("\u7269\u8d28\u64cd\u7eb5\u5668\u7684\u5b9a\u6027\u6316\u6398\u6548\u7387\u500d\u7387\uff0c\u9ed8\u8ba41.0x\u3002").defineInRange("matter_manipulator_base_multiplier", 1.0, 0.0, 2.147483647E9);
            this.MATTER_MANIPULATOR_AOE_SPEED = builder.comment("Base mining speed multiplier of Matter Manipulator when is conducting AOE mining, 0.5 by default.").comment("\u7269\u8d28\u64cd\u7eb5\u5668\u8fdb\u884c\u8303\u56f4\u6316\u6398\u65f6\u7684\u5b9a\u6027\u6316\u6398\u6548\u7387\u500d\u7387\uff0c\u9ed8\u8ba40.5x\u3002").defineInRange("matter_manipulator_aoe_base_multiplier", 0.5, 0.0, 2.147483647E9);
            this.MATTER_MANIPULATOR_FLUID_BOOST = builder.comment("Mining fluid bonus multiplier of Matter Manipulator , 0.5 by default , meaning that each 200 \u00b0C adds 1 mining speed.").comment("\u6d41\u4f53\u6e29\u5ea6\u5bf9\u7269\u8d28\u64cd\u7eb5\u5668\u6316\u6398\u901f\u5ea6\u7684\u5b9a\u91cf\u6548\u7387\u589e\u5e45\u3002\u9ed8\u8ba40.5x\uff0c\u610f\u5473\u7740\u6316\u6398\u6db2\u6bcf200\u2103\u589e\u52a01\u6316\u6398\u901f\u5ea6\u3002").defineInRange("matter_manipulator_fluid_bonus_multiplier", 0.5, 0.0, 2.147483647E9);
            this.MATTER_MANIPULATOR_FLUID_ENCHANTING = builder.comment("Allows Matter Manipulator to gain enchantment boost from fluids in mining mode (e.g. Gain silk touch from molten emerald). true by default.").comment("\u5141\u8bb8\u6316\u6398\u6a21\u5f0f\u4e0b\u7684\u7269\u8d28\u64cd\u7eb5\u5668\u4ece\u6d41\u4f53\u6548\u679c\u4e2d\u83b7\u5f97\u9644\u9b54\u7b49\u7ea7\uff08\u6bd4\u5982\u7194\u878d\u94bb\u77f3\u7684\u65f6\u8fd0III\uff09\uff0c\u9ed8\u8ba4true\u3002").define("matter_manipulator_fluid_enchanting", true);
            this.MATTER_MANIPULATOR_BASE_RANGE = builder.comment("Base mining range for Matter Manipulator, 16.0 by default.").comment("\u7269\u8d28\u64cd\u7eb5\u5668\u7684\u57fa\u7840\u6316\u6398\u8ddd\u79bb\uff0c\u9ed8\u8ba416.0\u683c\u3002").defineInRange("matter_manipulator_base_range", 16.0, 0.0, 64.0);
            this.MATTER_MANIPULATOR_CAPACITY_FACTOR = builder.comment("Capacity factor for Matter Manipulator, 10.0 by default.").comment("\u7269\u8d28\u64cd\u7eb5\u5668\u7684\u6d41\u4f53\u5bb9\u91cf\u500d\u7387\uff0c\u9ed8\u8ba410.0x\u3002").defineInRange("matter_manipulator_base_capacity_factor", 10.0, 0.0, 2.147483647E9);
            this.MATTER_MANIPULATOR_FLUID_EFFICIENCY = builder.comment("Base fluid efficiency for Matter Manipulator, 1.0 by default.").comment("\u7269\u8d28\u64cd\u7eb5\u5668\u7684\u57fa\u7840\u6d41\u4f53\u6548\u7387\uff0c\u9ed8\u8ba40.0\u3002").defineInRange("matter_manipulator_base_fluid_efficiency", 0.0, 0.0, 2.147483647E9);
            this.MATTER_MANIPULATOR_CANCEL_SLOWDOWN = builder.comment("Cancel the movement punishment when using Matter Manipulator,true by default.").comment("\u53d6\u6d88\u7269\u8d28\u64cd\u7eb5\u5668\u4f7f\u7528\u65f6\u7684\u79fb\u901f\u60e9\u7f5a\uff0c\u9ed8\u8ba4\u662f\u3002").define("matter_manipulator_cancel_slowdown", true);
            builder.comment("Ionized Cannon behaviour").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae");
            this.IONIZED_CANNON_FLUID_FACTOR = builder.comment("The multiplier of fluid consumption of Ionized Cannon, 1.0 by default.").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u5b9a\u6027\u6d41\u4f53\u6d88\u8017\u500d\u7387\uff0c\u9ed8\u8ba41.0x\u3002").defineInRange("ionized_cannon_fluid_factor", 1.0, 0.0, 2.147483647E9);
            this.IONIZED_CANNON_DAMAGE_BONUS = builder.comment("Damage multiplier for Ionized Cannon when using correct fluids, 4.0 by default.").comment("\u5f53\u6709\u5408\u9002\u6d41\u4f53\u65f6\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u4f24\u5bb3\u500d\u7387\uff0c\u9ed8\u8ba44.0x\u3002").defineInRange("ionized_cannon_damage_bonus", 4.0, 1.0, 2.147483647E9);
            this.IONIZED_CANNON_BASE_FLUID_EFFICIENCY = builder.comment("Base fluid efficiency for Ionized Cannon, 0.0 by default.").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u57fa\u7840\u6d41\u4f53\u6548\u7387\uff0c\u9ed8\u8ba40.0\u3002").defineInRange("ionized_cannon_base_fluid_efficiency", 0.0, 0.0, 2.147483647E9);
            this.IONIZED_CANNON_BASE_SCALE = builder.comment("Base explosion scale efficiency for Ionized Cannon, 1.0 by default.").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u57fa\u7840\u6548\u679c\u8303\u56f4\uff0c\u9ed8\u8ba41.0\u3002").defineInRange("ionized_cannon_base_scale", 1.0, 0.0, 2.147483647E9);
            this.IONIZED_CANNON_BASE_RANGE = builder.comment("Base attack range for Ionized Cannon, 12.0 by default.").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u57fa\u7840\u653b\u51fb\u8ddd\u79bb\uff0c\u9ed8\u8ba412.0\u683c\u3002").defineInRange("ionized_cannon_base_range", 12.0, 0.0, 2.147483647E9);
            this.IONIZED_CANNON_BASE_CHARGE_TIME = builder.comment("Base duration for Ionized Cannon to charge, 40 ticks by default.").comment("\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u7684\u57fa\u7840\u84c4\u529b\u65f6\u95f4\uff0c\u9ed8\u8ba440 ticks\u3002\u6700\u7ec8\u84c4\u529b\u65f6\u95f4\u4f1a\u9664\u4ee5\u653b\u901f\u3002").defineInRange("ionized_cannon_base_duration", 40, 0, Integer.MAX_VALUE);
            this.IONIZED_CANNON_PIERCE_FROM_IMPALING = builder.comment("Allow Ionized Cannon to gain pierce level form impaling modifier, true by default.").comment("\u5141\u8bb8\u7b49\u79bb\u5b50\u5c04\u7ebf\u70ae\u6839\u636e\u7a7f\u900f\u8bcd\u6761\u7684\u7b49\u7ea7\u589e\u52a0\u5c04\u7ebf\u7a7f\u900f\u6570\u91cf\uff0c\u9ed8\u8ba4\u662f\u3002").define("ionize_cannon_pierce_from_impaling", true);
            builder.comment("Electron Tuner behaviour").comment("\u73af\u6d41\u7535\u5b50\u8c03\u8c10\u5251");
            this.ELECTRON_TUNER_ATTACK_DAMAGE_ADJUSTABLE_RANGE = builder.comment("The adjustable range of attack damage for Electron Tuner, 1.5 by default, meaning that the damage can be adjusted within the range of \u00b10.75 .Note that adjusting this without adjusting electron_tuner_attack_speed_range will greatly affect balance.").comment("\u73af\u6d41\u7535\u5b50\u8c03\u8c10\u5251\u7684\u4f24\u5bb3\u8c03\u8282\u8303\u56f4\u3002\u9ed8\u8ba41.5\uff0c\u610f\u5473\u7740\u6ed1\u52a8\u8c03\u8282\u6ed1\u5757\u6700\u5927\u80fd\u5bf9\u4f24\u5bb3\u4ea7\u751f 1/1.75 x ~ 1.75 x \u7684\u53d8\u5316\u3002\u4ec5\u8c03\u8282\u6b64\u9879\u4f1a\u6781\u5927\u5f71\u54cd\u5e73\u8861\uff0c\u8bf7\u8003\u8651\u548c\u653b\u901f\u8303\u56f4\u4e00\u540c\u8c03\u6574\u3002").defineInRange("electron_tuner_damage_range", 1.5, 0.0, 2.147483647E9);
            this.ELECTRON_TUNER_ATTACK_SPEED_ADJUSTABLE_RANGE = builder.comment("The adjustable range of attack damage for Electron Tuner, 1.0 by default, meaning that the damage can be adjusted within the range of \u00b10.5 .Note that adjusting this without adjusting electron_tuner_damage_range will greatly affect balance.").comment("\u73af\u6d41\u7535\u5b50\u8c03\u8c10\u5251\u7684\u653b\u51fb\u901f\u5ea6\u8c03\u8282\u8303\u56f4\u3002\u9ed8\u8ba41.0\uff0c\u610f\u5473\u7740\u6ed1\u52a8\u8c03\u8282\u6ed1\u5757\u6700\u5927\u80fd\u5bf9\u653b\u901f\u4ea7\u751f 1/1.5 x ~ 1.5 x \u7684\u53d8\u5316\u3002\u4ec5\u8c03\u8282\u6b64\u9879\u4f1a\u6781\u5927\u5f71\u54cd\u5e73\u8861\uff0c\u8bf7\u8003\u8651\u548c\u4f24\u5bb3\u8303\u56f4\u4e00\u540c\u8c03\u6574\u3002").defineInRange("electron_tuner_attack_speed_range", 1.0, 0.0, 2.147483647E9);
            this.ELECTRON_TUNER_SPECIAL_BONUS = builder.comment("Allow Electron Tuner to perform special attack , true by default.").comment("\u5141\u8bb8\u73af\u6d41\u7535\u5b50\u8c03\u8c10\u5251\u9020\u6210\u7279\u6b8a\u653b\u51fb\uff08\u6bd4\u5982\u5251\u5f62\u6001\u7684\u5f27\u5149\uff09\uff0c\u9ed8\u8ba4true\u3002").define("electron_tuner_special", true);
            this.ELECTRON_TUNER_CONSUMPTION = builder.comment("The basic energy consumption when attacking for Electron Tuner, 250 by default.").comment("\u73af\u6d41\u7535\u5b50\u8c03\u8c10\u5251\u653b\u51fb\u7684\u80fd\u8017\uff0c\u9ed8\u8ba4250FE\u3002").defineInRange("electron_tuner_consumption", 250, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Utilities").comment("\u5b9e\u7528\u8bbe\u5907").push("utilities");
            this.CINDER_SLIME_FAUCET_SPEED = builder.comment("Transfer speed for Cinderslime Faucet, 1000mB/t by default.").comment("\u4f59\u70ec\u9ecf\u6db2\u6d47\u7b51\u53e3\u7684\u4f20\u8f93\u901f\u7387\uff0c\u9ed8\u8ba41000mB/t\u3002").defineInRange("cinderslime_faucet_speed", 1000, 1, 200000000);
            this.IRIDIUM_FAUCET_SPEED = builder.comment("Transfer speed for Iridium Faucet, 2000000000mB/t by default.").comment("\u94f1\u6d47\u7b51\u53e3\u7684\u4f20\u8f93\u901f\u7387\uff0c\u9ed8\u8ba42000000000mB/t\u3002").defineInRange("iridium_faucet_speed", 2000000000, 1, 2000000000);
            this.CINDER_SLIME_CASTING_INCREASE = builder.comment("Cinderslime Casting Speed multiplier with low temp recipes,5x by default.").comment("\u4f59\u70ec\u9ecf\u6db2\u94f8\u4ef6\u53f0\u5904\u7406\u5feb\u901f\u914d\u65b9\u65f6\u7684\u901f\u5ea6\u500d\u7387\uff0c\u9ed8\u8ba45x\u3002").defineInRange("cinderslime_casting_increase", 5.0, 0.0, 2.147483647E9);
            this.CINDER_SLIME_CASTING_DECREASE = builder.comment("Cinderslime Casting Speed multiplier with high temp recipes,0.5x by default.").comment("\u4f59\u70ec\u9ecf\u6db2\u94f8\u4ef6\u53f0\u5904\u7406\u6162\u901f\u914d\u65b9\u65f6\u7684\u901f\u5ea6\u500d\u7387\uff0c\u9ed8\u8ba40.5x\u3002").defineInRange("cinderslime_casting_decrease", 0.5, 0.0, 2.147483647E9);
            this.CINDER_SLIME_TABLE_SEPARATION = builder.comment("Recipe time separator for Cinderslime Table containers,100 ticks by default.").comment("\u4f59\u70ec\u9ecf\u6db2\u94f8\u4ef6\u53f0\u7684\u5feb\u6162\u901f\u5206\u754c\u7ebf\uff0c\u9ed8\u8ba4100\u523b(5\u79d2)\u3002").defineInRange("cinderslime_table_separation", 100, 1, Integer.MAX_VALUE);
            this.CINDER_SLIME_BASIN_SEPARATION = builder.comment("Recipe time separator for Cinderslime Basin containers,180 ticks by default.").comment("\u4f59\u70ec\u9ecf\u6db2\u94f8\u4ef6\u53f0\u7684\u5feb\u6162\u901f\u5206\u754c\u7ebf\uff0c\u9ed8\u8ba4180\u523b(9\u79d2)\u3002").defineInRange("cinderslime_basin_separation", 180, 1, Integer.MAX_VALUE);
            this.IRIDIUM_CASTING_SPEED = builder.comment("Iridium Casting speed modifier, 3x by default.").comment("\u94f1\u94f8\u4ef6\u53f0\u7684\u901f\u5ea6\u500d\u7387\uff0c\u9ed8\u8ba43x\u3002").defineInRange("iridium_casting_speed", 3.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Mekanism Interaction").comment("\u901a\u7528\u673a\u68b0\u4ea4\u4e92").push("mekanism_interaction");
            this.EXPLODING_FUSION_REACTOR = builder.comment("Enables fusion reactor exploding when throwing iron ingots into it. true by default.").comment("\u8ba9\u4f60\u80fd\u591f\u901a\u8fc7\u5411\u670b\u53cb\u7684\u805a\u53d8\u53cd\u5e94\u5806\u4e22\u5165\u94c1\u952d/\u5757/\u7c92/\u7827\u6765\u589e\u8fdb\u5f7c\u6b64\u7684\u611f\u60c5\uff0c\u9ed8\u8ba4\u662f\u3002").define("allow_neutronite_crafting", true);
            builder.pop();
        }
    }

    public static class Client {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

