/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.client.renderer;

import com.c2h6s.tinkers_advanced.content.entity.PlasmaBeamProjectile;
import com.c2h6s.tinkers_advanced.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PlasmaBeamRenderer
extends EntityRenderer<PlasmaBeamProjectile> {
    public PlasmaBeamRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public boolean shouldRender(PlasmaBeamProjectile entity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        Vec3 vec3 = entity.m_20182_().m_82549_(entity.m_20184_().m_82490_((double)entity.getDataLength()));
        Vec3 vec32 = entity.m_20182_().m_82549_(entity.m_20184_().m_82490_((double)(entity.getDataLength() / 2.0f)));
        Vec3 cameraPos = new Vec3(pCamX, pCamY, pCamZ);
        return entity.m_20182_().m_82546_(cameraPos).m_82553_() < 64.0 || vec3.m_82546_(cameraPos).m_82553_() < 64.0 || vec32.m_82546_(cameraPos).m_82553_() < 64.0;
    }

    public void render(PlasmaBeamProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float distance = pEntity.getDataLength();
        if (distance > 1.0f && pEntity.f_19797_ > 2 && pEntity.readyToRender()) {
            pPoseStack.m_85836_();
            Vec3 direction = pEntity.m_20184_().m_82541_();
            double d0 = direction.m_165924_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875);
            float xRot = (float)(Mth.m_14136_((double)(-direction.f_82480_), (double)d0) * 57.2957763671875);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
            float scale = 0.5f + pEntity.getScale() * 0.5f;
            pPoseStack.m_85841_(scale, scale, 1.0f);
            PoseStack.Pose pose = pPoseStack.m_85850_();
            Matrix4f poseMatrix = pose.m_252922_();
            Matrix3f normalMatrix = pose.m_252943_();
            float tick = (float)pEntity.f_19797_ + pPartialTick - 2.0f;
            float alphaPercent = Math.max(0.0f, (7.0f - tick) / 7.0f);
            VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110460_((ResourceLocation)this.getTextureLocation(pEntity), (boolean)false));
            RenderUtil.drawPipe(pPoseStack, consumer, poseMatrix, 0.05f * alphaPercent, distance, 255, 255, 255, 255, normalMatrix);
            consumer = pBuffer.m_6299_(RenderType.m_110460_((ResourceLocation)this.getTextureLocation(pEntity), (boolean)true));
            RenderUtil.drawPipe(pPoseStack, consumer, poseMatrix, 0.1f, distance, 128, 245, 255, (int)(128.0f * alphaPercent), normalMatrix);
            pPoseStack.m_85849_();
        }
    }

    protected int getBlockLightLevel(PlasmaBeamProjectile pEntity, BlockPos pPos) {
        return 15;
    }

    protected int getSkyLightLevel(PlasmaBeamProjectile pEntity, BlockPos pPos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(PlasmaBeamProjectile entity) {
        return new ResourceLocation("tinkers_advanced", "textures/entity/plasma_beam/white.png");
    }
}

