/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.capability;

import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.inventory.InventoryModule;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ElectronTunerItemCapabilityProvider
extends ToolInventoryCapability {
    public final boolean canExtractFromInput;
    public static final ResourceLocation LOCATION = TinkersAdvanced.getLocation("electron_tuner_inventory");
    public final ToolInventoryCapability.InventoryModifierHook inventory = new ToolInventoryCapability.InventoryModifierHook(){

        public int getSlots(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
            return 16;
        }

        public ItemStack getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
            ModDataNBT modData = tool.getPersistentData();
            ResourceLocation key = LOCATION;
            if (slot < this.getSlots(tool, modifier) && modData.contains(key, 9)) {
                ListTag list = (ListTag)tool.getPersistentData().get(key, InventoryModule.GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag compound = list.m_128728_(i);
                    if (compound.m_128451_("Slot") != slot) continue;
                    return ItemStack.m_41712_((CompoundTag)compound);
                }
            }
            return ItemStack.f_41583_;
        }

        public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
            if (slot < this.getSlots(tool, modifier)) {
                ListTag list;
                ResourceLocation key;
                ModDataNBT modData = tool.getPersistentData();
                if (modData.contains(key = LOCATION, 9)) {
                    list = (ListTag)modData.get(key, InventoryModule.GET_COMPOUND_LIST);
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag compound = list.m_128728_(i);
                        if (compound.m_128451_("Slot") != slot) continue;
                        if (stack.m_41619_()) {
                            list.remove(i);
                        } else {
                            compound.m_128431_().clear();
                            InventoryModule.writeStack((ItemStack)stack, (int)slot, (CompoundTag)compound);
                        }
                        return;
                    }
                } else {
                    if (stack.m_41619_()) {
                        return;
                    }
                    list = new ListTag();
                    modData.put(key, (Tag)list);
                }
                if (!stack.m_41619_()) {
                    list.add((Object)InventoryModule.writeStack((ItemStack)stack, (int)slot, (CompoundTag)new CompoundTag()));
                }
            }
        }
    };

    public ElectronTunerItemCapabilityProvider(Supplier<? extends IToolStackView> tool, boolean canExtractFromInput) {
        super(tool);
        this.canExtractFromInput = canExtractFromInput;
    }

    public int getSlots() {
        return 16;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 8 && !this.canExtractFromInput) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot >= 8 && !this.canExtractFromInput) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nullable
    protected ToolInventoryCapability.InventoryModifierHook findHook(IToolStackView tool, int index) {
        return this.inventory;
    }

    protected ToolInventoryCapability.InventoryModifierHook getHook(ModifierEntry entry) {
        return this.inventory;
    }
}

