/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.entity;

import com.c2h6s.etstlib.util.AttackUtil;
import com.c2h6s.tinkers_advanced.content.entity.PlasmaExplosionProjectile;
import com.c2h6s.tinkers_advanced.content.entity.base.VisualScaledProjectile;
import com.c2h6s.tinkers_advanced.registery.TiAcEntities;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class PlasmaBeamProjectile
extends VisualScaledProjectile {
    public static final EntityDataAccessor<Float> DATA_LENGTH = SynchedEntityData.m_135353_(PlasmaBeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DATA_RENDER = SynchedEntityData.m_135353_(PlasmaBeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_PIERCE = SynchedEntityData.m_135353_(PlasmaBeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ToolStack tool;
    public FluidStack fluidStack;
    public boolean OffHand;
    public IntOpenHashSet piercedEntityList = new IntOpenHashSet();

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RENDER, (Object)false);
        this.f_19804_.m_135372_(DATA_PIERCE, (Object)0);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean readyToRender() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RENDER);
    }

    public void setDataLength(float amount) {
        this.f_19804_.m_135381_(DATA_LENGTH, (Object)Float.valueOf(amount));
    }

    public float getDataLength() {
        return ((Float)this.f_19804_.m_135370_(DATA_LENGTH)).floatValue();
    }

    public void setDataPierce(int amount) {
        this.f_19804_.m_135381_(DATA_PIERCE, (Object)amount);
    }

    public int getDataPierce() {
        return (Integer)this.f_19804_.m_135370_(DATA_PIERCE);
    }

    public PlasmaBeamProjectile(EntityType<? extends VisualScaledProjectile> pEntityType, Level pLevel, float scale) {
        super(pEntityType, pLevel);
        this.setScale(scale);
    }

    public PlasmaBeamProjectile(EntityType<? extends VisualScaledProjectile> pEntityType, Level pLevel) {
        this(pEntityType, pLevel, 1.0f);
    }

    public PlasmaBeamProjectile(Level pLevel, float Scale) {
        this((EntityType<? extends VisualScaledProjectile>)((EntityType)TiAcEntities.PLASMA_BEAM.get()), pLevel, Scale);
    }

    protected boolean m_5603_(Entity pTarget) {
        Entity entity;
        if (pTarget instanceof Projectile || pTarget instanceof ItemEntity || pTarget instanceof ExperienceOrb || pTarget == this.m_19749_()) {
            return false;
        }
        if (this.piercedEntityList.contains(pTarget.m_19879_())) {
            return false;
        }
        if (pTarget instanceof LivingEntity && (entity = this.m_19749_()) instanceof Player) {
            Player player1 = (Player)entity;
            if (pTarget instanceof Player) {
                Player player = (Player)pTarget;
                return player1.m_7099_(player);
            }
        }
        return pTarget.m_6084_();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            if (this.f_19803_ && (entity = this.m_19749_()) instanceof Player) {
                Player player = (Player)entity;
                this.f_19797_ = 0;
                Vec3 initialPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                double distance = this.getDataLength();
                float scale = this.getScale();
                Vec3 direction = this.m_20184_().m_82541_();
                Vec3 step = direction.m_82490_((double)scale * 0.5);
                this.m_20256_(step);
                Vec3 end = null;
                BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(initialPos, initialPos.m_82549_(direction.m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                for (double i = 0.0; i <= distance; i += (double)scale * 0.5) {
                    Vec3 pos = initialPos.m_82549_(direction.m_82490_(i));
                    AABB aabb = new AABB(pos.f_82479_ - (double)scale * 0.5, pos.f_82480_ - (double)scale * 0.5, pos.f_82481_ - (double)scale * 0.5, pos.f_82479_ + (double)scale * 0.5, pos.f_82480_ + (double)scale * 0.5, pos.f_82481_ + (double)scale * 0.5);
                    aabb.m_82369_(step);
                    List entities = this.m_9236_().m_6443_(Entity.class, aabb, this::m_5603_);
                    for (Entity entity2 : entities) {
                        if (entity2 instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity2;
                            AttackUtil.attackEntity((IToolStackView)this.tool, (LivingEntity)player, (InteractionHand)player.m_7655_(), (Entity)living, () -> 1.0, (boolean)false, (EquipmentSlot)(player.m_7655_() == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND), (boolean)true, (float)this.baseDamage, (boolean)true);
                            if (hitResult.m_6662_() != HitResult.Type.ENTITY) {
                                hitResult = new EntityHitResult((Entity)living, pos.m_82549_(step.m_82490_(0.5)));
                            }
                            this.piercedEntityList.add(entity2.m_19879_());
                        } else {
                            entity2.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.baseDamage);
                        }
                        if (this.piercedEntityList.size() <= this.getDataPierce()) continue;
                        break;
                    }
                    end = pos.m_82549_(step.m_82490_(0.5));
                    if (this.piercedEntityList.size() <= this.getDataPierce()) continue;
                    this.setDataLength((float)i);
                    break;
                }
                if (hitResult.m_6662_() == HitResult.Type.MISS) {
                    Vec3 path = direction.m_82490_(distance);
                    PlasmaExplosionProjectile projectile = new PlasmaExplosionProjectile(this.m_9236_(), scale);
                    projectile.fluidStack = this.fluidStack;
                    projectile.baseDamage = this.baseDamage / 2.0f;
                    projectile.m_146884_(initialPos.m_82549_(path));
                    projectile.m_5602_(this.m_19749_());
                    this.m_9236_().m_7967_((Entity)projectile);
                    Vec3 offset = player.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_((double)0.6f);
                    if (this.OffHand) {
                        offset = offset.m_82548_();
                    }
                    Vec3 newDirection = path.m_82546_(offset).m_82541_();
                    this.m_20256_(newDirection);
                    this.m_146884_(initialPos.m_82549_(offset));
                    this.f_19790_ = this.m_20185_();
                    this.f_19791_ = this.m_20186_();
                    this.f_19792_ = this.m_20189_();
                    this.f_19804_.m_135381_(DATA_RENDER, (Object)true);
                } else {
                    Vec3 path = end != null ? end.m_82546_(initialPos) : hitResult.m_82450_().m_82546_(initialPos);
                    PlasmaExplosionProjectile projectile = new PlasmaExplosionProjectile(this.m_9236_(), scale);
                    projectile.fluidStack = this.fluidStack;
                    projectile.baseDamage = this.baseDamage / 2.0f;
                    Vec3 explosionPos = hitResult.m_82450_().m_82546_(step.m_82490_(0.5));
                    projectile.m_146884_(explosionPos);
                    projectile.m_5602_(this.m_19749_());
                    this.m_9236_().m_7967_((Entity)projectile);
                    Vec3 offset = player.m_20154_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_((double)0.6f);
                    if (this.OffHand) {
                        offset = offset.m_82548_();
                    }
                    Vec3 newDirection = path.m_82546_(offset).m_82541_();
                    this.m_20256_(newDirection);
                    this.m_146884_(initialPos.m_82549_(offset));
                    this.f_19790_ = this.m_20185_();
                    this.f_19791_ = this.m_20186_();
                    this.f_19792_ = this.m_20189_();
                    this.f_19804_.m_135381_(DATA_RENDER, (Object)true);
                }
            }
            if (this.f_19797_ >= 9) {
                this.m_146870_();
            }
        }
        super.m_8119_();
    }
}

