/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.item.toolItem;

import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.entity.PlasmaBeamProjectile;
import com.c2h6s.tinkers_advanced.content.item.tinkering.TiAcToolDefinitions;
import com.c2h6s.tinkers_advanced.registery.TiAcModifiers;
import com.c2h6s.tinkers_advanced.registery.TiAcToolStats;
import com.c2h6s.tinkers_advanced.util.CommonUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolActions;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;

public class IonizedCannonItem
extends ModifiableItem {
    public static final ResourceLocation TAG_SOUND = new ResourceLocation("tinkers_advanced", "cannon_sound");

    public IonizedCannonItem(Item.Properties properties) {
        super(properties, TiAcToolDefinitions.IONIZE_CANNON);
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return true;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return EnchantmentModifierHook.getEnchantmentLevel((ItemStack)stack, (Enchantment)enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EnchantmentModifierHook.getAllEnchantments((ItemStack)stack);
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag nbt) {
        ToolStack.verifyTag((Item)this, (CompoundTag)nbt, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }

    public boolean m_5812_(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag((ItemStack)stack, (ResourceLocation)SHINY);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return IndestructibleItemEntity.hasCustomEntity((ItemStack)stack);
    }

    public Entity createEntity(Level world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom((Level)world, (Entity)original, (ItemStack)stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolDamageUtil.getFakeMaxDamage((ItemStack)stack);
    }

    public int getDamage(ItemStack stack) {
        if (!this.m_41465_()) {
            return 0;
        }
        return ToolStack.from((ItemStack)stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.m_41465_()) {
            ToolStack.from((ItemStack)stack).setDamage(damage);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        ToolDamageUtil.handleDamageItem((ItemStack)stack, (int)amount, damager, onBroken);
        return 0;
    }

    public boolean m_142522_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.showDurabilityBar((ItemStack)pStack);
    }

    public int m_142159_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.getDurabilityRGB((ItemStack)pStack);
    }

    public int m_142158_(ItemStack pStack) {
        return DurabilityDisplayModifierHook.getDurabilityWidth((ItemStack)pStack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        InventoryTickModifierHook.heldInventoryTick((ItemStack)stack, (Level)worldIn, (Entity)entityIn, (int)itemSlot, (boolean)isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        return target.m_6469_(player.m_269291_().m_269075_(player), 1.0f);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ModifierUtil.canPerformAction((IToolStackView)ToolStack.from((ItemStack)stack), (ToolAction)toolAction);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        return AttributesModifierHook.getHeldAttributeModifiers((IToolStackView)tool, (EquipmentSlot)slot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || slot.m_20743_() != EquipmentSlot.Type.HAND) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers((IToolStackView)ToolStack.from((ItemStack)stack), slot);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.canPerformAction(stack, TinkerToolActions.SHIELD_DISABLE);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return BlockingModifier.blockWhileCharging((IToolStackView)ToolStack.from((ItemStack)stack), (UseAnim)UseAnim.BOW);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        boolean creative = player.m_150110_().f_35937_;
        ItemStack stack = player.m_21120_(hand);
        if (!CommonUtil.isModifiable(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        if (fluidStack.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        float fluidEfficiency = ((Float)tool.getStats().get((IToolStat)TiAcToolStats.FLUID_EFFICIENCY)).floatValue();
        fluidEfficiency = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.FLUID_EFFICIENCY, (float)fluidEfficiency);
        float fluidFactor = Math.max(0.0f, 1.0f - fluidEfficiency);
        FluidEffects effect = FluidEffectManager.INSTANCE.find(fluidStack.getFluid());
        int consume = (int)Math.round(Math.max((effect.hasEntityEffects() ? (double)((float)effect.getAmount(fluidStack.getFluid()) * 0.5f) * (Double)TiAcConfig.COMMON.IONIZED_CANNON_FLUID_FACTOR.get() : 10.0 * (Double)TiAcConfig.COMMON.IONIZED_CANNON_FLUID_FACTOR.get()) * (double)fluidFactor, 1.0));
        if (fluidStack.getAmount() < consume && !creative) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int drawTime = hand == InteractionHand.MAIN_HAND ? Math.round(player.m_36333_() * 4.0f) : (int)((float)((Integer)TiAcConfig.COMMON.IONIZED_CANNON_BASE_CHARGE_TIME.get()).intValue() / ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)ToolStats.ATTACK_SPEED));
        tool.getPersistentData().putInt(GeneralInteractionModifierHook.KEY_DRAWTIME, drawTime);
        if (tool.getModifierLevel(TiAcModifiers.AUTO_SHOT.get()) <= 0) {
            tool.getPersistentData().putBoolean(TAG_SOUND, true);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (!CommonUtil.isModifiable(pStack)) {
            return;
        }
        int chargeTime = this.m_8105_(pStack) - pRemainingUseDuration;
        ToolStack toolStack = ToolStack.from((ItemStack)pStack);
        float charge = GeneralInteractionModifierHook.getToolCharge((IToolStackView)toolStack, (float)chargeTime);
        if (charge >= 0.5f && toolStack.getPersistentData().getBoolean(TAG_SOUND)) {
            pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), SoundEvents.f_215772_, pLivingEntity.m_5720_(), 1.0f, 1.0f);
            toolStack.getPersistentData().remove(TAG_SOUND);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        Player player;
        block8: {
            block7: {
                if (!(living instanceof Player)) break block7;
                player = (Player)living;
                if (CommonUtil.isModifiable(stack)) break block8;
            }
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid((IToolStackView)tool);
        if (tool.isBroken()) {
            tool.getPersistentData().remove(GeneralInteractionModifierHook.KEY_DRAWTIME);
            return;
        }
        int chargeTime = this.m_8105_(stack) - timeLeft;
        float charge = GeneralInteractionModifierHook.getToolCharge((IToolStackView)tool, (float)chargeTime);
        if (charge < 0.45f) {
            return;
        }
        boolean creative = player.m_150110_().f_35937_;
        float fluidEfficiency = ((Float)tool.getStats().get((IToolStat)TiAcToolStats.FLUID_EFFICIENCY)).floatValue();
        fluidEfficiency = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.FLUID_EFFICIENCY, (float)fluidEfficiency);
        float fluidFactor = Math.max(0.0f, 1.0f - fluidEfficiency);
        FluidEffects effect = FluidEffectManager.INSTANCE.find(fluidStack.getFluid());
        int consume = Math.round(Math.max((effect.hasEntityEffects() ? (float)effect.getAmount(fluidStack.getFluid()) * 0.5f : 10.0f) * fluidFactor, 1.0f));
        double baseRange = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)living, (FloatToolStat)TiAcToolStats.RANGE);
        baseRange += player.getEntityReach() * 2.0;
        double baseScale = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)living, (FloatToolStat)TiAcToolStats.SCALE);
        baseScale += (double)tool.getModifierLevel(TinkerModifiers.expanded.get()) / 2.0;
        consume = (int)((double)consume * (1.0 + (baseScale *= (double)charge) * 0.5));
        double baseDamage = ToolAttackUtil.getAttributeAttackDamage((IToolStackView)tool, (LivingEntity)living, (EquipmentSlot)(player.m_7655_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
        baseDamage *= effect.hasEntityEffects() ? (Double)TiAcConfig.COMMON.IONIZED_CANNON_DAMAGE_BONUS.get() : 1.0;
        baseDamage *= (double)charge;
        int pierce = Math.round(ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)living, (FloatToolStat)TiAcToolStats.PIERCE));
        if (((Boolean)TiAcConfig.COMMON.IONIZED_CANNON_PIERCE_FROM_IMPALING.get()).booleanValue()) {
            pierce += tool.getModifierLevel(TinkerModifiers.impaling.get());
        }
        PlasmaBeamProjectile projectile = new PlasmaBeamProjectile(level, (float)baseScale);
        Vec3 vec3 = living.m_20154_();
        projectile.tool = tool;
        projectile.fluidStack = fluidStack;
        projectile.m_6686_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0f, 0.0f);
        projectile.m_5602_((Entity)living);
        projectile.m_146884_(new Vec3(living.m_20185_(), living.m_20188_(), living.m_20189_()));
        projectile.setDataLength((float)baseRange);
        projectile.baseDamage = (float)baseDamage;
        projectile.OffHand = player.m_7655_() == InteractionHand.OFF_HAND;
        projectile.setDataPierce(pierce);
        level.m_7967_((Entity)projectile);
        if (!creative) {
            fluidStack.shrink(consume);
            ToolTankHelper.TANK_HELPER.setFluid((IToolStackView)tool, fluidStack);
        }
        tool.getPersistentData().remove(GeneralInteractionModifierHook.KEY_DRAWTIME);
        ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)player);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null) {
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid(tool);
            float fluidEfficiency = ((Float)tool.getStats().get((IToolStat)TiAcToolStats.FLUID_EFFICIENCY)).floatValue();
            fluidEfficiency = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.FLUID_EFFICIENCY, (float)fluidEfficiency);
            float fluidFactor = Math.max(0.0f, 1.0f - fluidEfficiency);
            FluidEffects effect = FluidEffectManager.INSTANCE.find(fluidStack.getFluid());
            int consume = Math.round(Math.max((effect.hasEntityEffects() ? (float)effect.getAmount(fluidStack.getFluid()) * 0.5f : 10.0f) * fluidFactor, 1.0f));
            float baseRange = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.RANGE);
            baseRange += (float)(player.getEntityReach() * 2.0);
            baseRange += (float)tool.getModifierLevel(TinkerModifiers.expanded.get()) * 7.5f;
            float baseScale = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.SCALE);
            baseScale += (float)tool.getModifierLevel(TinkerModifiers.expanded.get()) * 0.75f;
            int pierce = Math.round(ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)TiAcToolStats.PIERCE));
            if (((Boolean)TiAcConfig.COMMON.IONIZED_CANNON_PIERCE_FROM_IMPALING.get()).booleanValue()) {
                pierce += tool.getModifierLevel(TinkerModifiers.impaling.get());
            }
            consume = (int)((double)consume * (1.0 + (double)baseScale * 0.5));
            tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.fluid_consumption").m_130946_(" : " + consume + " mB").m_130938_(s -> s.m_131148_(TiAcToolStats.FLUID_EFFICIENCY.getColor())));
            tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.range").m_130946_(" : " + baseRange).m_130938_(s -> s.m_131148_(TiAcToolStats.RANGE.getColor())));
            tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.scale").m_130946_(" : " + baseScale).m_130938_(s -> s.m_131148_(TiAcToolStats.SCALE.getColor())));
            if (pierce > 0) {
                tooltips.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.pierce").m_130946_(" : " + pierce).m_130938_(s -> s.m_131148_(TiAcToolStats.PIERCE.getColor())));
            }
        }
        return super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
    }
}

