/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.common;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class Shaping
extends EtSTBaseModifier
implements VolatileDataModifierHook,
TooltipModifierHook {
    public static final ResourceLocation LOCATION_SHAPING = TinkersAdvanced.getLocation("shaping_slots");

    public boolean isNoLevels() {
        return true;
    }

    public int getPriority() {
        return 200;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.TOOLTIP, ModifierHooks.VOLATILE_DATA);
    }

    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        int existingBonus = tool.getPersistentData().getInt(LOCATION_SHAPING);
        Integer requirement = (Integer)TiAcConfig.COMMON.SHAPING_DAMAGES_EACH_SLOT.get();
        int maxBonus = (Integer)TiAcConfig.COMMON.SHAPING_MAX_SLOT.get() * requirement;
        if (existingBonus < maxBonus) {
            tool.getPersistentData().putInt(LOCATION_SHAPING, Math.min(maxBonus, existingBonus + amount));
        }
        if ((existingBonus + amount) / requirement != existingBonus / requirement) {
            ((ToolStack)tool).rebuildStats();
        }
        return amount;
    }

    public void addVolatileData(IToolContext iToolContext, ModifierEntry modifierEntry, ToolDataNBT toolDataNBT) {
        IModDataView persistentDataNbt = iToolContext.getPersistentData();
        Integer requirement = (Integer)TiAcConfig.COMMON.SHAPING_DAMAGES_EACH_SLOT.get();
        int slotBonus = persistentDataNbt.getInt(LOCATION_SHAPING) / requirement;
        if ((slotBonus = Math.min(slotBonus, (Integer)TiAcConfig.COMMON.SHAPING_MAX_SLOT.get())) > 0) {
            if (iToolContext.hasTag(TinkerTags.Items.ARMOR)) {
                toolDataNBT.addSlots(SlotType.DEFENSE, slotBonus);
            } else {
                toolDataNBT.addSlots(SlotType.UPGRADE, slotBonus);
            }
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        Integer requirement = (Integer)TiAcConfig.COMMON.SHAPING_DAMAGES_EACH_SLOT.get();
        Integer maxBonus = (Integer)TiAcConfig.COMMON.SHAPING_MAX_SLOT.get();
        int slotBonus = tool.getPersistentData().getInt(LOCATION_SHAPING) / requirement;
        slotBonus = Math.min(slotBonus, (Integer)TiAcConfig.COMMON.SHAPING_MAX_SLOT.get());
        list.add((Component)Component.m_237115_((String)"tooltip.tinkers_advanced.modifiers.shaping").m_130946_(slotBonus + " / " + maxBonus).m_130948_(this.getDisplayName().m_7383_()));
    }
}

