/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.compat.thermal;

import cofh.core.common.network.packet.client.OverlayMessagePacket;
import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.modifier.compat.thermal.FluxInfused;
import com.c2h6s.tinkers_advanced.data.TiAcMaterialIds;
import com.c2h6s.tinkers_advanced.util.FakeExplosionUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class FluxArrow
extends FluxInfused
implements BowAmmoModifierHook {
    public static final String KEY_ARROW_CHARGE = "tiac_key_arrow_charge";

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BOW_AMMO);
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        super.addToolStats(iToolContext, modifierEntry, modifierStatsBuilder);
        ToolStats.DRAW_SPEED.percent(modifierStatsBuilder, FluxArrow.getMode(iToolContext.getPersistentData()) >= 2 ? 0.5 : 0.0);
    }

    @Override
    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
    }

    @Override
    public void onModeSwitch(IToolStackView tool, ServerPlayer player, ModifierEntry entry) {
        OverlayMessagePacket.sendToClient((Component)Component.m_237115_((String)("msg.tinkers_advanced.flux_mode.thermal_slash." + FluxArrow.getMode(tool))), (ServerPlayer)player);
        MaterialNBT nbt = tool.getMaterials();
        ToolStack toolStack = (ToolStack)tool;
        block4: for (int i = 0; i < nbt.size(); ++i) {
            MaterialVariant variant = nbt.get(i);
            MaterialId materialId = variant.getId();
            if (!materialId.m_135827_().equals("tinkers_advanced") || !materialId.m_135815_().equals("activated_chromatic_steel")) continue;
            switch (FluxArrow.getMode(tool)) {
                case 1: {
                    toolStack.replaceMaterial(i, TiAcMaterialIds.Thermal.Variant.ACTIVATED_CHROMATIC_STEEL_ACTIVATED);
                    continue block4;
                }
                case 2: {
                    toolStack.replaceMaterial(i, TiAcMaterialIds.Thermal.Variant.ACTIVATED_CHROMATIC_STEEL_EMPOWERED);
                    continue block4;
                }
                default: {
                    toolStack.replaceMaterial(i, (MaterialVariantId)TiAcMaterialIds.Thermal.ACTIVATED_CHROMATIC_STEEL);
                }
            }
        }
    }

    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity livingEntity, ItemStack stack, Predicate<ItemStack> predicate) {
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_ARROW_CONSUMPTION.get();
        if (FluxArrow.getMode(tool) > 0 && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)true) >= basicConsumption * 2 && stack.m_41619_()) {
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 2), (boolean)false);
            return new ItemStack((ItemLike)Items.f_42412_, 64);
        }
        return stack;
    }

    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_ARROW_CONSUMPTION.get();
        if (!ammo.m_150930_(Items.f_42412_) && ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 4), (boolean)true) >= basicConsumption * 4 && FluxArrow.getMode(tool) > 1) {
            ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 4), (boolean)false);
            return;
        }
        super.shrinkAmmo(tool, modifier, shooter, ammo, needed);
    }

    public void modifierProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (arrow != null) {
            int basicConsumption = (Integer)TiAcConfig.COMMON.FLUX_ARROW_CONSUMPTION.get();
            switch (FluxArrow.getMode(tool)) {
                case 1: {
                    if (ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)basicConsumption, (boolean)true) < basicConsumption) break;
                    arrow.m_36781_(arrow.m_36789_() + 1.0);
                    arrow.getPersistentData().m_128405_(KEY_ARROW_CHARGE, FluxArrow.getMode(tool));
                    break;
                }
                case 2: {
                    if (ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 3), (boolean)true) < basicConsumption * 3) break;
                    arrow.m_36781_(arrow.m_36789_() + 1.0);
                    ToolEnergyUtil.extractEnergy((IToolStackView)tool, (int)(basicConsumption * 3), (boolean)false);
                    arrow.getPersistentData().m_128405_(KEY_ARROW_CHARGE, FluxArrow.getMode(tool));
                    break;
                }
            }
        }
    }

    public void onProjectileHitBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity attacker) {
        AbstractArrow arrow;
        if (attacker != null && projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36792_() && arrow.getPersistentData().m_128451_(KEY_ARROW_CHARGE) == 2) {
            FakeExplosionUtil.fakeExplode(FluxArrow.getExplosionDamage(arrow), attacker, attacker.m_9236_(), hit.m_82450_(), new IntOpenHashSet(attacker.m_19879_()), false);
        }
        if (projectile.getPersistentData().m_128451_(KEY_ARROW_CHARGE) > 0) {
            projectile.m_146870_();
        }
    }

    public void afterArrowHit(ModDataNBT persistentData, ModifierEntry entry, ModifierNBT modifiers, AbstractArrow arrow, @Nullable LivingEntity attacker, @NotNull LivingEntity target, float damageDealt) {
        if (attacker != null && arrow.m_36792_() && arrow.getPersistentData().m_128451_(KEY_ARROW_CHARGE) == 2) {
            FakeExplosionUtil.fakeExplode(FluxArrow.getExplosionDamage(arrow), attacker, attacker.m_9236_(), target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0), new IntOpenHashSet(attacker.m_19879_()), false);
            target.f_19802_ = 0;
        }
    }

    public static float getExplosionDamage(AbstractArrow arrow) {
        return (float)((double)((Double)TiAcConfig.COMMON.FLUX_ARROW_BASE_EXPLOSION_DAMAGE.get()).floatValue() + (double)((Double)TiAcConfig.COMMON.FLUX_ARROW_EXPLOSION_DAMAGE_FROM_DAMAGE.get()).floatValue() * arrow.m_36789_() * arrow.m_20184_().m_82553_());
    }
}

