/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.modifier.generatorModifiers.energyGeneration;

import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.tinkers_advanced.TiAcConfig;
import com.c2h6s.tinkers_advanced.content.modifierHooks.GeneratorModuleModifierHook;
import com.c2h6s.tinkers_advanced.content.modifierHooks.TiAcModifierHooks;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.build.ModifierTraitModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class SmelteryGenerator
extends EtSTBaseModifier
implements GeneratorModuleModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TiAcModifierHooks.GENERATOR_MODULE);
        hookBuilder.addModule((HookProvider)new ModifierTraitModule(ModifierIds.tank, 1, true));
    }

    @Override
    public int getBasicGeneration(IToolStackView tool, ModifierEntry entry) {
        return (Integer)TiAcConfig.COMMON.SMELTERY_GENERATOR_BASIC_GENERATION.get() * entry.getLevel();
    }

    @Override
    public int getConditionalGeneration(IToolStackView tool, ModifierEntry entry, @Nullable LivingEntity holderEntity, @Nullable BlockEntity holderBlockEntity, int baseAmount, int amplifiedAmount) {
        FluidStack stack = ToolTankHelper.TANK_HELPER.getFluid(tool);
        if (stack.isEmpty()) {
            return amplifiedAmount;
        }
        Fluid fluid = stack.getFluid();
        MeltingFuel fuel = MeltingFuelLookup.findFuel((Fluid)fluid);
        if (fuel == null) {
            return amplifiedAmount;
        }
        return (int)((double)fuel.getTemperature() * (Double)TiAcConfig.COMMON.SMELTERY_GENERATOR_TEMPERATURE_MULTIPLIER.get() * (double)amplifiedAmount);
    }

    @Override
    public long shrinkIngredientAndGetTotalEnergy(IToolStackView tool, ModifierEntry entry, @Nullable LivingEntity holderEntity, @Nullable BlockEntity holderBlockEntity, int generateAmount, @NotNull IItemHandler handler) {
        generateAmount *= 20;
        FluidStack stack = ToolTankHelper.TANK_HELPER.getFluid(tool);
        if (stack.isEmpty()) {
            return 0L;
        }
        Fluid fluid = stack.getFluid();
        MeltingFuel fuel = MeltingFuelLookup.findFuel((Fluid)fluid);
        if (fuel == null) {
            return 0L;
        }
        int baseAmount = fuel.getAmount(fluid);
        long baseToProduce = (long)fuel.getDuration() * (long)((Integer)TiAcConfig.COMMON.SMELTERY_GENERATOR_EACH_BURNING_TIME.get()).intValue() / (long)baseAmount;
        int consumption = (int)Math.max(1L, (long)generateAmount / baseToProduce);
        consumption = Math.min(consumption, stack.getAmount());
        stack.shrink(consumption);
        ToolTankHelper.TANK_HELPER.setFluid(tool, stack);
        return (long)consumption * baseToProduce;
    }
}

