/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.content.objects;

import com.c2h6s.etstlib.util.CommonUtil;
import com.c2h6s.etstlib.util.IToolUuidGetter;
import com.c2h6s.etstlib.util.ToolEnergyUtil;
import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolEnergyProduction {
    public static ResourceLocation LOCATION = TinkersAdvanced.getLocation("energy_production");
    public static final Map<UUID, ToolEnergyProduction> ENERGY_PRODUCTION_MAP = new HashMap<UUID, ToolEnergyProduction>();
    public long energyToProduce;
    public long energyToReduce;
    public int generatePerTick;
    public int consumePerTick;
    public int lastGeneration;
    public int coolDown;
    public int gameTimeLastTick;
    public ToolStack toolStack;
    public static final String KEY_ENERGY_GEN_REMAIN = "energy_generate_remain";
    public static final String KEY_ENERGY_COST_REMAIN = "energy_cost_remain";
    public static final String KEY_GENERATE_PER_TICK = "generate_per_tick";
    public static final String KEY_CONSUME_PER_TICK = "consume_per_tick";

    public ToolEnergyProduction(ToolStack toolStack, long energyToProduce, long energyToReduce, int generatePerTick, int consumePerTick) {
        this.energyToProduce = energyToProduce;
        this.energyToReduce = energyToReduce;
        this.generatePerTick = generatePerTick;
        this.consumePerTick = consumePerTick;
        this.toolStack = toolStack;
    }

    public static ToolEnergyProduction emptyInstance(ToolStack tool) {
        return new ToolEnergyProduction(tool, 0L, 0L, 0, 0);
    }

    public void start() {
        ENERGY_PRODUCTION_MAP.put(((IToolUuidGetter)this.toolStack).etstlib$getUuid(), this);
    }

    public static void updateProduction(ToolStack toolStack, ToolEnergyProduction production) {
        IToolUuidGetter.getUuid((IToolStackView)toolStack).ifPresent(uuid -> ENERGY_PRODUCTION_MAP.put((UUID)uuid, production));
    }

    @Nullable
    public static ToolEnergyProduction getFromMap(ToolStack toolStack) {
        if (CommonUtil.getUuidFromTool((ToolStack)toolStack) != null) {
            return ENERGY_PRODUCTION_MAP.get(CommonUtil.getUuidFromTool((ToolStack)toolStack));
        }
        return null;
    }

    @NotNull
    public static ToolEnergyProduction getOrCreate(@NotNull ToolStack tool) {
        ToolEnergyProduction production = ToolEnergyProduction.getFromMap(tool);
        if (production != null) {
            return production;
        }
        production = ToolEnergyProduction.emptyInstance(tool);
        if (CommonUtil.getUuidFromTool((ToolStack)tool) != null) {
            ENERGY_PRODUCTION_MAP.put(CommonUtil.getUuidFromTool((ToolStack)tool), production);
        }
        return production;
    }

    public boolean needUpdate() {
        return this.coolDown <= 0 && (this.requireGeneration() || this.requireConsumption());
    }

    public boolean requireGeneration() {
        return this.energyToProduce <= 0L || this.generatePerTick <= 0;
    }

    public boolean requireConsumption() {
        return this.energyToReduce <= 0L || this.consumePerTick <= 0;
    }

    public static void setCoolDown(ToolStack toolStack, int coolDown) {
        UUID key = ((IToolUuidGetter)toolStack).etstlib$getUuid();
        ToolEnergyProduction production = ENERGY_PRODUCTION_MAP.get(key);
        if (production != null) {
            production.coolDown = coolDown;
            ENERGY_PRODUCTION_MAP.put(key, production);
        }
    }

    public void tick() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.toolStack == null) {
            this.remove();
            return;
        }
        this.lastGeneration = 0;
        if (this.energyToProduce > 0L) {
            int toGenerate = (int)Math.min((long)this.generatePerTick, this.energyToProduce);
            if ((toGenerate = ToolEnergyUtil.receiveEnergy((IToolStackView)this.toolStack, (int)toGenerate, (boolean)true)) > 0) {
                this.energyToProduce -= (long)toGenerate;
                ToolEnergyUtil.receiveEnergy((IToolStackView)this.toolStack, (int)toGenerate, (boolean)false);
                this.lastGeneration += toGenerate;
            }
        }
        if (this.energyToReduce > 0L) {
            int toConsume = (int)Math.min((long)this.consumePerTick, this.energyToReduce);
            if ((toConsume = ToolEnergyUtil.extractEnergy((IToolStackView)this.toolStack, (int)toConsume, (boolean)true)) > 0) {
                this.energyToReduce -= (long)toConsume;
                ToolEnergyUtil.extractEnergy((IToolStackView)this.toolStack, (int)toConsume, (boolean)false);
                this.lastGeneration -= toConsume;
            }
        }
    }

    public void remove() {
        ENERGY_PRODUCTION_MAP.remove(((IToolUuidGetter)this.toolStack).etstlib$getUuid());
    }

    public static void addEnergyAndUpdate(ToolStack toolStack, ToolEnergyProduction production, long toAdd) {
        if (toAdd != 0L) {
            if (toAdd > 0L) {
                production.energyToProduce += toAdd;
            } else {
                production.energyToReduce -= toAdd;
            }
            ToolEnergyProduction.updateProduction(toolStack, production);
        }
    }

    public static void addEnergyAndUpdate(ToolStack toolStack, long toAdd) {
        ToolEnergyProduction.addEnergyAndUpdate(toolStack, ENERGY_PRODUCTION_MAP.get(((IToolUuidGetter)toolStack).etstlib$getUuid()), toAdd);
    }

    @NotNull
    public static ToolEnergyProduction readFromTool(ToolStack tool) {
        CompoundTag tag = tool.getPersistentData().getCompound(LOCATION);
        ToolEnergyProduction energyProduction = new ToolEnergyProduction(tool, tag.m_128454_(KEY_ENERGY_GEN_REMAIN), tag.m_128454_(KEY_ENERGY_COST_REMAIN), tag.m_128451_(KEY_GENERATE_PER_TICK), tag.m_128451_(KEY_CONSUME_PER_TICK));
        tool.getPersistentData().remove(LOCATION);
        energyProduction.start();
        return energyProduction;
    }

    public void saveToTool() {
        ToolDataNBT nbt = this.toolStack.getPersistentData();
        CompoundTag tag = new CompoundTag();
        tag.m_128356_(KEY_ENERGY_GEN_REMAIN, this.energyToProduce);
        tag.m_128356_(KEY_ENERGY_COST_REMAIN, this.energyToReduce);
        tag.m_128405_(KEY_CONSUME_PER_TICK, this.generatePerTick);
        tag.m_128405_(KEY_GENERATE_PER_TICK, this.consumePerTick);
        nbt.put(LOCATION, (Tag)tag);
    }

    public static void saveAll() {
        ENERGY_PRODUCTION_MAP.forEach((toolStack1, energyProduction) -> energyProduction.saveToTool());
    }

    public static ToolEnergyProduction readFromNetwork(FriendlyByteBuf buf) {
        return new ToolEnergyProduction(ToolStack.from((ItemStack)buf.m_130267_()), buf.readLong(), buf.readLong(), buf.readInt(), buf.readInt());
    }

    public void toNetwork(FriendlyByteBuf buf) {
        ItemStack stack = this.toolStack.createStack();
        buf.m_130055_(stack);
        buf.writeLong(this.energyToProduce);
        buf.writeLong(this.energyToReduce);
        buf.writeInt(this.generatePerTick);
        buf.writeInt(this.consumePerTick);
        buf.writeInt(this.lastGeneration);
    }
}

