/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.data.providers;

import com.c2h6s.tinkers_advanced.TinkersAdvanced;
import com.c2h6s.tinkers_advanced.registery.TiAcItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.FluidObject;

public class TiAcItemModelProvider
extends ItemModelProvider {
    public static final String PARENT_SIMPLE_ITEM = "item/generated";
    public static final String PARENT_BUCKET_FLUID = "forge:item/bucket_drip";

    public TiAcItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "tinkers_advanced", existingFileHelper);
    }

    public void generateItemModel(RegistryObject<Item> object, String typePath) {
        ((ItemModelBuilder)this.withExistingParent(object.getId().m_135815_(), PARENT_SIMPLE_ITEM)).texture("layer0", this.getItemLocation(object.getId().m_135815_(), typePath));
    }

    public void generateBlockItemModel(RegistryObject<BlockItem> object) {
        this.withExistingParent(object.getId().m_135815_(), this.getBlockItemLocation(object.getId().m_135815_()));
    }

    public void generateBucketItemModel(FluidObject<ForgeFlowingFluid> object, boolean flip) {
        ((ItemModelBuilder)this.withExistingParent(object.getId().m_135815_() + "_bucket", PARENT_BUCKET_FLUID)).customLoader((itemModelBuilder, existingFileHelper) -> DynamicFluidContainerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).fluid(object.get()).flipGas(flip));
    }

    public ResourceLocation getItemLocation(String path, String typePath) {
        return new ResourceLocation("tinkers_advanced", "item/" + typePath + "/" + path);
    }

    public ResourceLocation getBlockItemLocation(String path) {
        return new ResourceLocation("tinkers_advanced", "block/" + path);
    }

    protected void registerModels() {
        for (RegistryObject<Item> registryObject : TiAcItems.getListSimpleMaterialModel()) {
            this.generateItemModel(registryObject, "material");
        }
        for (RegistryObject<Item> registryObject : TiAcItems.getListSimpleMiscModel()) {
            this.generateItemModel(registryObject, "misc");
        }
        for (RegistryObject<Item> registryObject : TiAcItems.getListSimpleBlock()) {
            this.generateBlockItemModel(registryObject);
        }
        this.generateBlockItemModel(TiAcItems.STIBNITE_ORE);
        this.withExistingParent("cinderslime_casting_basin", TinkersAdvanced.getLocation("block/smeltery/cinderslime/basin"));
        this.withExistingParent("cinderslime_casting_table", TinkersAdvanced.getLocation("block/smeltery/cinderslime/table"));
        this.withExistingParent("cinderslime_faucet", TinkersAdvanced.getLocation("block/smeltery/cinderslime/faucet"));
        this.withExistingParent("iridium_casting_basin", TinkersAdvanced.getLocation("block/smeltery/iridium/basin"));
        this.withExistingParent("iridium_casting_table", TinkersAdvanced.getLocation("block/smeltery/iridium/table"));
        this.withExistingParent("iridium_faucet", TinkersAdvanced.getLocation("block/smeltery/iridium/faucet"));
    }
}

