/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.registery;

import cofh.core.init.CoreMobEffects;
import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.tinkers_advanced.registery.TiAcEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.block.BurningLiquidBlock;

public class TiAcFluids {
    public static final FluidDeferredRegister FLUIDS = new FluidDeferredRegister("tinkers_advanced");
    public static final FluidDeferredRegister MEK_FLUIDS = new FluidDeferredRegister("tinkers_advanced");
    public static final FluidDeferredRegister THERMAL_FLUIDS = new FluidDeferredRegister("tinkers_advanced");
    public static final FluidDeferredRegister IF_FLUIDS = new FluidDeferredRegister("tinkers_advanced");
    public static final FluidDeferredRegister CREATE_UTILITIES_FLUIDS = new FluidDeferredRegister("tinkers_advanced");
    protected static Map<FluidObject<ForgeFlowingFluid>, Boolean> FLUID_MAP = new HashMap<FluidObject<ForgeFlowingFluid>, Boolean>();
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_BISMUTH = TiAcFluids.registerHotBurning(FLUIDS, "molten_bismuth", 770, 1, 4, 0.5f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_BLAZE_NETHERITE = TiAcFluids.registerHotBurning(FLUIDS, "molten_blaze_netherite", 1920, 15, 1920, 9.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_IRIDIUM = TiAcFluids.registerHotBurning(FLUIDS, "molten_iridium", 1375, 10, 20, 3.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_ANTIMONY = TiAcFluids.registerHotBurning(FLUIDS, "molten_antimony", 970, 5, 16, 2.0f, false);
    public static final FluidObject<ForgeFlowingFluid> OVER_HEATED_LAVA = TiAcFluids.registerHotBurning(FLUIDS, "over_heated_lava", 2300, 15, 200, 6.5f, false);
    public static final FluidObject<ForgeFlowingFluid> GASEOUS_LAVA = TiAcFluids.registerFluid(FLUIDS, "gaseous_lava", 3300, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 8.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_((DamageSource)LegacyDamageSource.any((DamageSource)living.m_269291_().m_269233_()).setBypassInvulnerableTime().setBypassArmor().setBypassShield(), 0.5f);
                living.m_20254_(1000);
            }
        }
    }, true);
    public static final FluidObject<ForgeFlowingFluid> PLASMATIC_LAVA = TiAcFluids.registerFluid(FLUIDS, "plasmatic_lava", 4300, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 8.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_((DamageSource)LegacyDamageSource.any((DamageSource)living.m_269291_().m_269264_()).setBypassInvulnerableTime().setBypassArmor().setBypassEnchantment().setBypassMagic().setBypassShield().setMsgId("plasma"), 2.0f);
                living.m_20254_(100000);
            }
        }
    }, true);
    public static final FluidObject<ForgeFlowingFluid> PYROTHEUM = TiAcFluids.registerHotBurning(THERMAL_FLUIDS, "pyrotheum", 3273, 15, 2560, 15.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_BASALZ_SIGNALUM = TiAcFluids.registerFluid(THERMAL_FLUIDS, "molten_basalz_signalum", 950, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)7), 200, 5.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SUNDERED.get(), 100));
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_BILTZ_LUMIUM = TiAcFluids.registerFluid(THERMAL_FLUIDS, "molten_biltz_lumium", 1440, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 5.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 100));
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_BLIZZ_ENDERIUM = TiAcFluids.registerFluid(THERMAL_FLUIDS, "molten_blizz_enderium", 0, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 0, 0.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), 100));
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_ACTIVATED_CHROMATIC_STEEL = TiAcFluids.registerFluid(THERMAL_FLUIDS, "molten_activated_chromatic_steel", 2440, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 0, 0.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), 100));
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 100));
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SUNDERED.get(), 100));
                living.f_19802_ = 0;
                living.m_6469_(level.m_269111_().m_269233_(), 0.5f);
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_DENSIUM = TiAcFluids.registerHotBurning(MEK_FLUIDS, "molten_densium", 2250, 7, 256, 8.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_IRRADIUM = TiAcFluids.registerFluid(MEK_FLUIDS, "molten_irradium", 2250, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 8.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                RadiationManager.get().radiate(living, 0.01);
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_OSGLOGLAS = TiAcFluids.registerFluid(MEK_FLUIDS, "molten_osgloglas", 1750, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 8.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20000, 0, false, false));
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_ANTIMATTER = TiAcFluids.registerHotBurning(MEK_FLUIDS, "molten_antimatter", 2980, 15, 16384, 17.5f, true);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_NEUTRONITE = TiAcFluids.registerFluid(MEK_FLUIDS, "molten_neutronite", 9973, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 262144, 15.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_6469_((DamageSource)LegacyDamageSource.any((DamageSource)living.m_269291_().m_269264_()).setBypassInvulnerableTime().setBypassArmor().setBypassEnchantment().setBypassMagic().setBypassShield().setMsgId("plasma"), 25.0f);
                living.f_19802_ = 0;
                RadiationManager.get().radiate(living, 1000.0);
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_PROTOCITE = TiAcFluids.registerFluid(MEK_FLUIDS, "molten_protocite", 2250, supplier -> new BurningLiquidBlock((Supplier)supplier, FluidDeferredRegister.createProperties((MapColor)MapColor.f_283818_, (int)15), 200, 8.0f){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            super.m_7892_(state, level, pos, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance((MobEffect)TiAcEffects.PROTO_POISON.get(), 200, 0));
            }
        }
    }, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_NUTRITIVE_SLIMESTEEL = TiAcFluids.registerHotBurning(MEK_FLUIDS, "molten_nutritive_slime", 980, 7, 19, 3.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_PINK_SLIME = TiAcFluids.registerHotBurning(IF_FLUIDS, "molten_pink_slime", 990, 7, 20, 3.0f, false);
    public static final FluidObject<ForgeFlowingFluid> MOLTEN_VOID_STEEL = TiAcFluids.registerHotBurning(CREATE_UTILITIES_FLUIDS, "molten_void_steel", 1400, 15, 100, 3.0f, false);

    public static Set<FluidObject<ForgeFlowingFluid>> getFluids() {
        return FLUID_MAP.keySet();
    }

    public static Map<FluidObject<ForgeFlowingFluid>, Boolean> getFluidMap() {
        return FLUID_MAP;
    }

    private static FluidObject<ForgeFlowingFluid> registerHotBurning(FluidDeferredRegister register, String name, int temp, int lightLevel, int burnTime, float damage, boolean gas) {
        FlowingFluidObject object = register.register(name).type(TiAcFluids.hot(name, temp, gas)).bucket().block(BurningLiquidBlock.createBurning((MapColor)MapColor.f_283818_, (int)lightLevel, (int)burnTime, (float)damage)).commonTag().flowing();
        FLUID_MAP.put((FluidObject<ForgeFlowingFluid>)object, gas);
        return object;
    }

    private static FluidObject<ForgeFlowingFluid> registerFluid(FluidDeferredRegister register, String name, int temp, Function<Supplier<? extends FlowingFluid>, LiquidBlock> blockFunction, boolean gas) {
        FlowingFluidObject object = register.register(name).type(TiAcFluids.hot(name, temp, gas)).bucket().block(blockFunction).commonTag().flowing();
        FLUID_MAP.put((FluidObject<ForgeFlowingFluid>)object, gas);
        return object;
    }

    private static FluidType.Properties hot(String name, int Temp, boolean gas) {
        return FluidType.Properties.create().density(gas ? -2000 : 2000).viscosity(10000).temperature(Temp).descriptionId("fluid.tinkers_advanced." + name).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).motionScale(0.0023333333333333335).canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null);
    }
}

