/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.util;

import com.c2h6s.etstlib.util.EntityInRangeUtil;
import com.c2h6s.etstlib.util.IToolUuidGetter;
import com.c2h6s.etstlib.util.ModListConstants;
import com.c2h6s.etstlib.util.UUIDUtil;
import com.c2h6s.tinkers_advanced.content.compact.pnc.capability.ItemMachineConvertHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class CommonUtil {
    public static ArmorItem.Type[] ALL_ARMOR = new ArmorItem.Type[]{ArmorItem.Type.HELMET, ArmorItem.Type.CHESTPLATE, ArmorItem.Type.LEGGINGS, ArmorItem.Type.BOOTS};
    public static String KEY_ATTACKER = "tinkers_advanced_attacker";

    public static Entity getNearestEntity(@NotNull Entity centerEntity, float range, @NotNull IntOpenHashSet ignoreEntityIds, @NotNull Predicate<Entity> predicate) {
        List list = centerEntity.m_9236_().m_45976_(Entity.class, new AABB(centerEntity.m_20183_()).m_82400_((double)range));
        list.sort(Comparator.comparingDouble(EntityInRangeUtil.toManhattanDistance((Entity)centerEntity)));
        for (Entity entity : list) {
            if (ignoreEntityIds.contains(entity.m_19879_()) || !predicate.test(entity) || entity == centerEntity) continue;
            return entity;
        }
        return null;
    }

    public static String getUnitLong(long amount) {
        int a = (int)Math.log10(amount);
        int b = a / 3;
        switch (b) {
            case 1: {
                return String.format("%.2f", (double)amount / 1000.0) + " k";
            }
            case 2: {
                return String.format("%.2f", (double)amount / 1000000.0) + " M";
            }
            case 3: {
                return String.format("%.2f", (double)amount / 1.0E9) + " G";
            }
            case 4: {
                return String.format("%.2f", (double)amount / 1.0E12) + " T";
            }
            case 5: {
                return String.format("%.2f", (double)amount / 1.0E15) + " P";
            }
            case 6: {
                return String.format("%.2f", (double)amount / 1.0E18) + " E";
            }
        }
        return amount + " ";
    }

    public static String getEnergyString(long amount) {
        return CommonUtil.getUnitLong(amount) + "FE";
    }

    @NotNull
    public static <T> LazyOptional<T> getCompactCapability(@NotNull ItemStack stack, @NotNull Capability<T> capability, @Nullable Direction direction) {
        ItemMachineConvertHandler handler;
        if (ModListConstants.PnCLoaded && (handler = new ItemMachineConvertHandler(stack)).getCapability(capability).isPresent()) {
            return handler.getCapability(capability).cast();
        }
        return LazyOptional.empty();
    }

    public static boolean isModifiable(ItemStack stack) {
        return stack.m_41720_() instanceof IModifiable;
    }

    @NotNull
    public static UUID getUUIDFromTool(IToolStackView tool, ModifierId modifierId, EquipmentSlot slot) {
        return IToolUuidGetter.getUuid((IToolStackView)tool).isPresent() ? (UUID)IToolUuidGetter.getUuid((IToolStackView)tool).get() : UUIDUtil.UUIDFromSlot((EquipmentSlot)slot, (ModifierId)modifierId);
    }
}

