/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.tinkers_advanced.util;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class HarvestLogic {
    public static boolean breakBlockAndTeleport(ToolStack tool, ItemStack stack, ToolHarvestContext context, BlockPos lootPos) {
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_7500_()) {
            HarvestLogic.removeBlock((IToolStackView)tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage((ToolStack)tool, (Level)world, (BlockPos)pos, (BlockState)state);
        boolean canHarvest = context.canHarvest();
        BlockEntity te = canHarvest ? world.m_7702_(pos) : null;
        boolean removed = HarvestLogic.removeBlock((IToolStackView)tool, context);
        Block block = state.m_60734_();
        if (removed && canHarvest) {
            List list = Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack);
            list.forEach(itemStack -> {
                ItemEntity entity = new ItemEntity((Level)world, player.m_20185_(), player.m_20186_() + 0.5 * (double)player.m_20206_(), player.m_20189_(), itemStack, 0.0, 0.0, 0.0);
                entity.m_32061_();
                world.m_7967_((Entity)entity);
            });
        }
        if (removed && exp > 0) {
            block.m_49805_(world, lootPos, exp);
        }
        if (!tool.isBroken() && removed) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((BlockBreakModifierHook)entry.getHook(ModifierHooks.BLOCK_BREAK)).afterBlockBreak((IToolStackView)tool, entry, context);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)damage, (LivingEntity)player);
        }
        return true;
    }

    public static boolean breakBlockAndGiveItem(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_7500_()) {
            HarvestLogic.removeBlock((IToolStackView)tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage((ToolStack)tool, (Level)world, (BlockPos)pos, (BlockState)state);
        boolean canHarvest = context.canHarvest();
        BlockEntity te = canHarvest ? world.m_7702_(pos) : null;
        boolean removed = HarvestLogic.removeBlock((IToolStackView)tool, context);
        Block block = state.m_60734_();
        if (removed && canHarvest) {
            List list = Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack);
            list.forEach(item -> {
                ItemStack itemStack = item.m_41777_();
                if (!player.m_36356_(itemStack) && itemStack.m_41613_() > 0) {
                    ItemEntity entity = new ItemEntity((Level)world, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + (double)(player.m_20206_() / 2.0f), player.m_20182_().f_82481_, item, 0.0, 0.0, 0.0);
                    entity.m_32061_();
                    world.m_7967_((Entity)entity);
                }
            });
        }
        if (removed && exp > 0) {
            ForgeHooks.dropXpForBlock((BlockState)state, (ServerLevel)world, (BlockPos)player.m_20183_(), (ItemStack)stack);
        }
        if (!tool.isBroken() && removed) {
            for (ModifierEntry entry : tool.getModifierList()) {
                ((BlockBreakModifierHook)entry.getHook(ModifierHooks.BLOCK_BREAK)).afterBlockBreak((IToolStackView)tool, entry, context);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)damage, (LivingEntity)player);
        }
        return true;
    }

    private static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = ((RemoveBlockModifierHook)(entry = (ModifierEntry)iterator.next()).getHook(ModifierHooks.REMOVE_BLOCK)).removeBlock(tool, entry, context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.onDestroyedByPlayer((Level)world, pos, (Player)context.getPlayer(), context.canHarvest(), world.m_6425_(pos));
        }
        if (removed.booleanValue()) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }
}

