/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.axiom.evalex.functions.trigonometric;

import com.ezylang.axiom.evalex.EvaluationException;
import com.ezylang.axiom.evalex.Expression;
import com.ezylang.axiom.evalex.data.EvaluationValue;
import com.ezylang.axiom.evalex.functions.AbstractFunction;
import com.ezylang.axiom.evalex.functions.FunctionParameter;
import com.ezylang.axiom.evalex.parser.Token;

@FunctionParameter(name="value")
public class AtanHFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        double value = parameterValues[0].getNumberValue().doubleValue();
        if (Math.abs(value) >= 1.0) {
            throw new EvaluationException(functionToken, "Absolute value must be less than 1");
        }
        return expression.convertDoubleValue(0.5 * Math.log((1.0 + value) / (1.0 - value)));
    }
}

