/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.brush_shapes;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.brush_shapes.FlatDiskBrushShape;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiom.utils.Box;

public interface ConeBrushShape
extends BrushShape {
    public static final int CONE_DIRECTION_BOTH = 0;
    public static final int CONE_DIRECTION_UP = 1;
    public static final int CONE_DIRECTION_DOWN = 2;

    public static BrushShape create(int radius, int height, float rounding, int coneDirection) {
        if (height <= 0) {
            return FlatDiskBrushShape.create(radius);
        }
        if (rounding < 0.0f) {
            rounding = 0.0f;
        } else if (rounding > 1.0f) {
            rounding = 1.0f;
        }
        if (coneDirection < 0) {
            coneDirection = 0;
        } else if (coneDirection > 2) {
            coneDirection = 2;
        }
        return new RoundedConeBrushShape(radius, height, rounding, coneDirection);
    }

    public static final class RoundedConeBrushShape
    implements ConeBrushShape {
        private final float invMaxRadiusSq;
        private final int radius;
        private final int height;
        private final float invHeight;
        private final Box boundingBox;
        private final float rounding;
        private final float ellipsoidScale;
        private final float ellipsoidOffset;
        private final float ellipsoidRadiusY;
        private final float ellipsoidInvRadiusSqY;
        private final float maxEllipsoidDistance;
        private final int coneDirection;

        public RoundedConeBrushShape(int radius, int height, float rounding, int coneDirection) {
            this.invMaxRadiusSq = 1.0f / (((float)radius + 0.5f) * ((float)radius + 0.5f));
            this.radius = radius;
            this.height = height;
            this.rounding = rounding;
            this.coneDirection = coneDirection;
            this.invHeight = 1.0f / (float)height;
            this.boundingBox = new Box(-radius, -height, -radius, radius, height, radius);
            float s2 = 2.0f;
            float mNumer = this.rounding * this.rounding * 12.0f;
            float mDenom = 8.0f;
            this.ellipsoidScale = (float)Math.sqrt(mNumer / mDenom);
            float v = this.rounding * 2.0f - 2.0f + (float)Math.sqrt(2.0f * this.ellipsoidScale * this.ellipsoidScale - 2.0f * this.rounding * this.rounding);
            this.ellipsoidOffset = v = v * (float)this.height / 2.0f + 0.5f;
            this.ellipsoidRadiusY = (float)this.height / 2.0f * (float)Math.sqrt(2.0) - 0.5f;
            this.ellipsoidInvRadiusSqY = RasterizationHelper.calcInvRadiusSq(this.ellipsoidRadiusY);
            this.maxEllipsoidDistance = RasterizationHelper.distancePointEllipsoid(((float)this.radius + 0.5f) * this.ellipsoidScale, (this.ellipsoidRadiusY + 0.5f) * this.ellipsoidScale, ((float)this.radius + 0.5f) * this.ellipsoidScale, 0.0f, (float)this.height * (1.0f - this.rounding) + this.ellipsoidOffset, 0.0f, null);
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            if (y != 0 && this.coneDirection != 0 && y > 0 != (this.coneDirection == 1)) {
                return false;
            }
            float rhs = 1.0f - (float)Math.abs(y) * this.invHeight;
            if (rhs < 0.0f) {
                return false;
            }
            if (rhs < this.rounding) {
                float yo = (float)Math.abs(y) + this.ellipsoidOffset;
                return (float)(x * x + z * z) * this.invMaxRadiusSq <= this.ellipsoidScale * this.ellipsoidScale - yo * yo * this.ellipsoidInvRadiusSqY;
            }
            return (float)(x * x + z * z) * this.invMaxRadiusSq <= rhs * rhs;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            float sdf = this.sdf(x, y, z);
            return sdf * sdf;
        }

        @Override
        public float sdf(int x, int y, int z) {
            float scaledHeight = (float)Math.abs(y) * this.invHeight;
            if (scaledHeight >= 1.0f - this.rounding) {
                float surfaceDistance = RasterizationHelper.distancePointEllipsoid(((float)this.radius + 0.5f) * this.ellipsoidScale, (this.ellipsoidRadiusY + 0.5f) * this.ellipsoidScale, ((float)this.radius + 0.5f) * this.ellipsoidScale, x, (float)Math.abs(y) + this.ellipsoidOffset, z, null);
                if (!this.isInsideShape(x, y, z)) {
                    surfaceDistance *= -1.0f;
                }
                if (surfaceDistance > this.maxEllipsoidDistance) {
                    return 0.0f;
                }
                return 1.0f - this.rounding + this.rounding * (this.maxEllipsoidDistance - surfaceDistance) / this.maxEllipsoidDistance;
            }
            return scaledHeight + (float)Math.sqrt((float)(x * x + z * z) * this.invMaxRadiusSq);
        }
    }
}

