/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.PendingAction;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.Box;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.MoveEntityAdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class MoveBuilderTool
implements BuilderTool {
    private class_2338.class_2339 pos1 = null;
    private class_2338.class_2339 pos2 = null;
    private boolean overridingChunkRender = false;
    private final IntMatrix transformMatrix = new IntMatrix();
    private class_2338.class_2339 regionOffset = null;
    private ChunkedBlockRegion blockRegion = null;
    private Long2ObjectMap<CompressedBlockEntity> blockEntities = null;
    private final PendingAction pendingAction = new PendingAction();
    private int pendingCopyId = 0;

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.pos1 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.first_point"), class_310.method_1551().field_1690.field_1886, 0);
        } else if (this.pos2 == null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.second_point"), class_310.method_1551().field_1690.field_1904, 0);
        } else if (this.regionOffset == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_nudge"), 0);
            } else {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.move.scroll"), 0);
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_extend"), class_310.method_1551().field_1690.field_1871, 1);
            }
        } else {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.cancel"), class_310.method_1551().field_1690.field_1886, 0);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.confirm"), class_310.method_1551().field_1690.field_1904, 1);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.move_to"), class_310.method_1551().field_1690.field_1871, 2);
        }
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards) {
        if (nudgeForwards) {
            this.nudge(1);
        }
        if (nudgeBackwards) {
            this.nudge(-1);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.pos1 != null && class_310.method_1551().field_1755 == null && Keybinds.BUILDER_TOOL_DELETE.isDown()) {
            BuilderTool.delete((class_2338)this.pos1, (class_2338)(this.pos2 != null ? this.pos2 : this.pos1));
            this.reset(false);
        }
        if (this.regionOffset != null) {
            boolean rotatePressed = Keybinds.ROTATE_PLACEMENT.isPressed(false);
            boolean flipPressed = Keybinds.FLIP_PLACEMENT.isPressed(false);
            this.blockRegion = BuilderTool.handleMoveableBlockBuffer(camera, time, matrices, projection, this.blockRegion, (class_2338)this.regionOffset, this.transformMatrix, rotatePressed, flipPressed);
        } else if (this.pos1 != null && this.pos2 != null) {
            boolean rotatePressed = Keybinds.ROTATE_PLACEMENT.isPressed(false);
            boolean flipPressed = Keybinds.FLIP_PLACEMENT.isPressed(false);
            if (rotatePressed || flipPressed) {
                this.initiateMovement();
            }
            if (this.blockRegion != null) {
                if (rotatePressed) {
                    this.blockRegion = this.blockRegion.rotate(class_2350.class_2351.field_11052, -1);
                    this.transformMatrix.rotateY(-1);
                }
                if (flipPressed) {
                    direction = BuilderTool.calculateDirection();
                    this.blockRegion = this.blockRegion.flip(direction.method_10166());
                    this.transformMatrix.flip(direction.method_10166());
                }
            } else {
                if (rotatePressed) {
                    this.pendingAction.rotateY(-1);
                }
                if (flipPressed) {
                    direction = BuilderTool.calculateDirection();
                    switch (direction.method_10166()) {
                        case field_11048: {
                            this.pendingAction.flipX();
                            break;
                        }
                        case field_11052: {
                            this.pendingAction.flipY();
                            break;
                        }
                        case field_11051: {
                            this.pendingAction.flipZ();
                        }
                    }
                }
            }
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            BuilderTool.renderBoxWithArrow(BuilderTool.calculateDirection(), camera, time, matrices, projection, minX, minY, minZ, maxX, maxY, maxZ);
        } else if (this.pos1 != null) {
            float x = this.pos1.method_10263();
            float y = this.pos1.method_10264();
            float z = this.pos1.method_10260();
            if (this.regionOffset != null) {
                x += (float)this.regionOffset.method_10263();
                y += (float)this.regionOffset.method_10264();
                z += (float)this.regionOffset.method_10260();
            }
            EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)x, (double)y, (double)z), new class_243((double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f)), 3);
        }
    }

    @Override
    public boolean setPos1(class_2338 position) {
        if (this.regionOffset == null) {
            this.pos1 = position.method_25503();
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        if (this.regionOffset == null) {
            this.pos2 = position.method_25503();
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (this.regionOffset != null) {
            this.reset(false);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos1 = ((class_3965)hitResult).method_17777().method_25503();
            this.showTextInActionBar();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (this.regionOffset != null) {
            this.reset(true);
        } else if (this.pos1 != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            this.pos2 = ((class_3965)hitResult).method_17777().method_25503();
            this.showTextInActionBar();
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1333 && this.regionOffset != null && class_310.method_1551().field_1724 != null) {
            this.regionOffset.method_10101((class_2382)class_310.method_1551().field_1724.method_24515());
            this.showTextInActionBar();
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (this.regionOffset != null) {
                BuilderTool.setOffsetFromBlock(blockHitResult, this.regionOffset, (class_2338)this.pos1, (class_2338)this.pos2);
            } else if (this.pos1 == null) {
                this.pos1 = blockHitResult.method_17777().method_25503();
            } else if (this.pos2 == null) {
                this.pos2 = blockHitResult.method_17777().method_25503();
            } else {
                class_2338 pos = ((class_3965)hitResult).method_17777();
                BuilderTool.extend(pos, this.pos1, this.pos2);
            }
            this.showTextInActionBar();
        }
    }

    private void apply() {
        if (this.regionOffset != null) {
            Long2ObjectOpenHashMap blockEntities;
            class_2338 offset = this.regionOffset.method_10062();
            class_2338 min2 = this.blockRegion.min();
            class_2338 max2 = this.blockRegion.max();
            int minX = Math.min(min2.method_10263(), max2.method_10263());
            int minY = Math.min(min2.method_10264(), max2.method_10264());
            int minZ = Math.min(min2.method_10260(), max2.method_10260());
            int maxX = Math.max(min2.method_10263(), max2.method_10263());
            int maxY = Math.max(min2.method_10264(), max2.method_10264());
            int maxZ = Math.max(min2.method_10260(), max2.method_10260());
            float partialX = (float)((maxX - minX) % 2) / 2.0f;
            float partialY = (float)((maxY - minY) % 2) / 2.0f;
            float partialZ = (float)((maxZ - minZ) % 2) / 2.0f;
            int shiftX = (int)(-Math.floor(this.transformMatrix.transformDoubleX(partialX, partialY, partialZ)));
            int shiftY = (int)(-Math.floor(this.transformMatrix.transformDoubleY(partialX, partialY, partialZ)));
            int shiftZ = (int)(-Math.floor(this.transformMatrix.transformDoubleZ(partialX, partialY, partialZ)));
            offset = offset.method_10069(shiftX, shiftY, shiftZ);
            minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263()) - offset.method_10263();
            minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264()) - offset.method_10264();
            minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260()) - offset.method_10260();
            maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263()) - offset.method_10263();
            maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264()) - offset.method_10264();
            maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260()) - offset.method_10260();
            String description = AxiomI18n.get("axiom.history_description.moved", NumberFormat.getInstance().format(this.blockRegion.count()));
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        this.blockRegion.addBlockIfNotPresent(x, y, z, class_2246.field_10124.method_9564());
                    }
                }
            }
            if (this.blockEntities.isEmpty() || this.transformMatrix.isIdentity()) {
                blockEntities = this.blockEntities;
            } else {
                blockEntities = new Long2ObjectOpenHashMap();
                for (Long2ObjectMap.Entry entry : this.blockEntities.long2ObjectEntrySet()) {
                    long pos = entry.getLongKey();
                    int x = class_2338.method_10061((long)pos);
                    int y = class_2338.method_10071((long)pos);
                    int z = class_2338.method_10083((long)pos);
                    int nx = this.transformMatrix.transformX(x, y, z);
                    int ny = this.transformMatrix.transformY(x, y, z);
                    int nz = this.transformMatrix.transformZ(x, y, z);
                    blockEntities.put(class_2338.method_10064((int)nx, (int)ny, (int)nz), (Object)((CompressedBlockEntity)entry.getValue()));
                }
            }
            if (this.blockRegion.isEmpty()) {
                return;
            }
            MoveEntityAdditionalUndoOperation additionalUndoOperation = null;
            ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> manipulateEntries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
            class_638 level = class_310.method_1551().field_1687;
            if (level != null && ClientEvents.serverSupportsProtocol(SupportedProtocol.MANIPULATE_ENTITY) && BuilderToolManager.copyEntities) {
                minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
                minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
                minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
                maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
                maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
                maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
                class_238 bounds = new class_238(new class_243((double)minX, (double)minY, (double)minZ), new class_243((double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)));
                int originalOffsetX = Math.floorDiv(minX + maxX, 2);
                int originalOffsetY = Math.floorDiv(minY + maxY, 2);
                int originalOffsetZ = Math.floorDiv(minZ + maxZ, 2);
                List entities = level.method_8333((class_1297)class_310.method_1551().field_1724, bounds, BuilderTool::shouldEntityByCopied);
                if (!entities.isEmpty()) {
                    ArrayList<MoveEntityAdditionalUndoOperation.UUIDAndPosition> positions = new ArrayList<MoveEntityAdditionalUndoOperation.UUIDAndPosition>();
                    for (class_1297 entity : entities) {
                        float newPitch;
                        float newYaw;
                        class_243 position;
                        class_243 entityPos;
                        if (entity instanceof class_1530) {
                            class_1530 hangingEntity = (class_1530)entity;
                            entityPos = class_243.method_24953((class_2382)hangingEntity.method_6896());
                        } else {
                            entityPos = entity.method_19538();
                        }
                        double x = entityPos.field_1352 - (double)originalOffsetX - 0.5;
                        double y = entityPos.field_1351 - (double)originalOffsetY - 0.5;
                        double z = entityPos.field_1350 - (double)originalOffsetZ - 0.5;
                        if (this.transformMatrix.isIdentity()) {
                            position = new class_243(x + (double)offset.method_10263() + 0.5, y + (double)offset.method_10264() + 0.5, z + (double)offset.method_10260() + 0.5);
                            newYaw = entity.method_36454();
                            newPitch = entity.method_36455();
                        } else {
                            double nx = this.transformMatrix.transformDoubleX(x, y, z);
                            double ny = this.transformMatrix.transformDoubleY(x, y, z);
                            double nz = this.transformMatrix.transformDoubleZ(x, y, z);
                            position = new class_243(nx + (double)offset.method_10263() + 0.5, ny + (double)offset.method_10264() + 0.5, nz + (double)offset.method_10260() + 0.5);
                            class_243 viewVector = entity.method_5828(1.0f);
                            double viewX = this.transformMatrix.transformDoubleX(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewY = this.transformMatrix.transformDoubleY(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewZ = this.transformMatrix.transformDoubleZ(viewVector.field_1352, viewVector.field_1351, viewVector.field_1350);
                            double viewXZ = Math.sqrt(viewX * viewX + viewZ * viewZ);
                            newPitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)viewY, (double)viewXZ) * 57.2957763671875))));
                            newYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)viewZ, (double)viewX) * 57.2957763671875) - 90.0f));
                            newPitch = (float)Math.round(newPitch * 256.0f) / 256.0f;
                            newYaw = (float)Math.round(newYaw * 256.0f) / 256.0f;
                        }
                        manipulateEntries.add(new AxiomServerboundManipulateEntity.ManipulateEntry(entity.method_5667(), Set.of(), position, newYaw, newPitch, null));
                        positions.add(new MoveEntityAdditionalUndoOperation.UUIDAndPosition(entity.method_5667(), entityPos, entity.method_36454(), entity.method_36455()));
                    }
                    additionalUndoOperation = new MoveEntityAdditionalUndoOperation(positions);
                }
            }
            RegionHelper.pushBlockRegionChangeOffset(this.blockRegion, (Long2ObjectMap<CompressedBlockEntity>)blockEntities, offset, description, Dispatcher.simpleSourceInfo("Move Builder Tool"), HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME, additionalUndoOperation);
            if (!manipulateEntries.isEmpty()) {
                new AxiomServerboundManipulateEntity(manipulateEntries).send();
            }
        }
    }

    @Override
    public boolean scroll(int scroll) {
        if (this.pos1 == null || this.pos2 == null) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (this.regionOffset == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                this.nudge(scroll);
                return true;
            }
            this.initiateMovement();
        }
        if (this.regionOffset != null) {
            this.regionOffset.method_10104(BuilderTool.calculateDirection(), scroll);
            this.showTextInActionBar();
        } else {
            this.pendingAction.move(BuilderTool.calculateDirection(), scroll);
        }
        return true;
    }

    private void nudge(int amount) {
        if (this.regionOffset != null || this.pos1 == null) {
            return;
        }
        BuilderTool.nudge(this.pos1, this.pos2, amount);
        this.showTextInActionBar();
    }

    private void showTextInActionBar() {
        if (this.regionOffset != null) {
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            int offsetX = Math.floorDiv(minX + maxX, 2);
            int offsetY = Math.floorDiv(minY + maxY, 2);
            int offsetZ = Math.floorDiv(minZ + maxZ, 2);
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(this.regionOffset.method_10263() - offsetX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(this.regionOffset.method_10264() - offsetY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + (this.regionOffset.method_10260() - offsetZ))).method_27692(class_124.field_1075)), false);
        } else if (this.pos1 != null && this.pos2 != null) {
            int sizeX = Math.abs(this.pos1.method_10263() - this.pos2.method_10263()) + 1;
            int sizeY = Math.abs(this.pos1.method_10264() - this.pos2.method_10264()) + 1;
            int sizeZ = Math.abs(this.pos1.method_10260() - this.pos2.method_10260()) + 1;
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43470((String)"Size: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(sizeX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(sizeY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + sizeZ)).method_27692(class_124.field_1075)), false);
        }
    }

    private void initiateMovement() {
        int copyId;
        if (this.pendingCopyId != 0) {
            return;
        }
        if (!BuilderTool.applyLimitBounds(this.pos1, this.pos2)) {
            return;
        }
        int randomId = ThreadLocalRandom.current().nextInt();
        this.pendingCopyId = copyId = randomId == 0 ? 1 : randomId;
        this.pendingAction.reset();
        int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
        int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
        int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
        int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
        int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
        int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
        int offsetX = Math.floorDiv(minX + maxX, 2);
        int offsetY = Math.floorDiv(minY + maxY, 2);
        int offsetZ = Math.floorDiv(minZ + maxZ, 2);
        SelectionBuffer selection = new SelectionBuffer.AABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
        selection = Restrictions.constrainSelection(selection);
        selection.callCopy(false, BuilderToolManager.copyAir).thenAccept(copyResult -> {
            if (this.pendingCopyId != copyId) {
                return;
            }
            this.pendingCopyId = 0;
            if (copyResult.chunkedBlockRegion().isEmpty()) {
                this.reset(false);
                return;
            }
            this.transformMatrix.identity();
            this.blockRegion = copyResult.chunkedBlockRegion();
            this.blockEntities = copyResult.blockEntities();
            if (!this.overridingChunkRender) {
                ChunkRenderOverrider.INSTANCE.acquire("MoveBuilderTool");
                this.overridingChunkRender = true;
            }
            this.blockRegion.forEachEntry((x, y, z, block) -> ChunkRenderOverrider.INSTANCE.setBlock(x + offsetX, y + offsetY, z + offsetZ, class_2246.field_9996.method_9564()));
            this.regionOffset = new class_2338.class_2339(offsetX, offsetY, offsetZ);
            this.regionOffset.method_10100(this.pendingAction.moveX, this.pendingAction.moveY, this.pendingAction.moveZ);
            this.showTextInActionBar();
            this.blockRegion = this.blockRegion.rotate(class_2350.class_2351.field_11052, this.pendingAction.rotateY);
            this.transformMatrix.rotateY(this.pendingAction.rotateY);
            if (this.pendingAction.flipX) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11048);
                this.transformMatrix.flip(class_2350.class_2351.field_11048);
            }
            if (this.pendingAction.flipY) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11052);
                this.transformMatrix.flip(class_2350.class_2351.field_11052);
            }
            if (this.pendingAction.flipZ) {
                this.blockRegion = this.blockRegion.flip(class_2350.class_2351.field_11051);
                this.transformMatrix.flip(class_2350.class_2351.field_11051);
            }
            this.pendingAction.reset();
        });
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        if (this.pos1 != null) {
            if (this.pos2 != null) {
                if (this.regionOffset != null) {
                    return false;
                }
                int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
                int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
                int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
                int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
                int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
                int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
                int x = blockPos.method_10263();
                int y = blockPos.method_10264();
                int z = blockPos.method_10260();
                return x < minX || x > maxX || y < minY || y > maxY || z < minZ || z > maxZ;
            }
            return !blockPos.equals((Object)this.pos1);
        }
        return true;
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.move");
    }

    @Override
    public List<String> getKeyHints() {
        if (this.regionOffset != null) {
            return List.of("Ctrl+R - Rotate", "Ctrl+F - Flip");
        }
        return List.of();
    }

    @Override
    public boolean canBeReset() {
        return this.pos1 != null || this.pos2 != null || this.regionOffset != null;
    }

    @Override
    public void reset(boolean apply) {
        if (apply && this.pos1 != null && this.pos2 != null && this.regionOffset != null) {
            this.apply();
        }
        this.pos1 = null;
        this.pos2 = null;
        this.pendingCopyId = 0;
        this.pendingAction.reset();
        this.blockRegion = null;
        this.transformMatrix.identity();
        this.regionOffset = null;
        if (this.overridingChunkRender) {
            ChunkRenderOverrider.INSTANCE.release("MoveBuilderTool");
            this.overridingChunkRender = false;
        }
    }

    @Override
    public Box getBox() {
        if (this.pos1 == null || this.regionOffset != null) {
            return null;
        }
        return new Box((class_2338)this.pos1, (class_2338)this.pos2);
    }

    @Override
    public void setBox(Box box) {
        this.pos1 = box.pos1().method_25503();
        this.pos2 = box.pos2() == null ? null : box.pos2().method_25503();
    }
}

