/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.world_modification.undo.AdditionalUndoOperation;
import net.minecraft.class_2338;

public interface SelectionHistoryElement
extends AdditionalUndoOperation {
    public static final Empty EMPTY = new Empty();

    public void applyToSelection();

    @Override
    default public void perform() {
        this.applyToSelection();
    }

    public static class Empty
    implements SelectionHistoryElement {
        @Override
        public void applyToSelection() {
            Selection.clearSelectionNoHistory();
        }
    }

    public record AABB(class_2338 min, class_2338 max) implements SelectionHistoryElement
    {
        @Override
        public void applyToSelection() {
            Selection.clearSelectionNoHistory();
            Selection.addAABBWithHistory(this.min, this.max, false);
        }
    }

    public record Set(PositionSet blocks) implements SelectionHistoryElement
    {
        @Override
        public void applyToSelection() {
            Selection.clearSelectionNoHistory();
            Selection.modifyWithHistory(region -> {
                region.addAll(this.blocks);
                return region;
            }, false);
        }
    }
}

