/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.displayentity;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.collections.JoinedList;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.ItemStackDataHelper;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8104;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ItemList {
    public static ItemList INSTANCE = new ItemList();
    private String lastSearch = "";
    private boolean lastOnlyCustomModels = false;
    private List<Entry> searchedItems;
    private final List<Entry> itemsStartsWith = new ArrayList<Entry>();
    private final List<Entry> itemsContains = new ArrayList<Entry>();
    private List<Entry> itemsAll = List.of();
    private List<Entry> itemsAllLengthSorted;
    private List<Entry> itemsCustom;
    private List<Entry> itemsCustomLengthSorted;
    private boolean isDirty = false;

    private ItemList() {
        this.searchedItems = this.itemsAll;
        this.itemsAllLengthSorted = List.of();
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                this.isDirty = true;
            }
        });
    }

    public void markDirty() {
        this.isDirty = true;
    }

    private void reload() {
        this.isDirty = false;
        ArrayList<Entry> itemsAll = new ArrayList<Entry>();
        ArrayList<Entry> itemsAllImportant = new ArrayList<Entry>();
        ArrayList<Entry> itemsCustom = new ArrayList<Entry>();
        ArrayList<Entry> itemsCustomImportant = new ArrayList<Entry>();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_7706.method_47330((class_7699)player.field_3944.method_45735(), (player.method_7338() && (Boolean)class_310.method_1551().field_1690.method_47395().method_41753() != false ? 1 : 0) != 0, (class_7225.class_7874)player.method_37908().method_30349());
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Vector3f defaultTranslation = new Vector3f();
        Quaternionf defaultLeftRotation = new Quaternionf();
        Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
        Quaternionf defaultRightRotation = new Quaternionf();
        HashSet<String> registeredModels = new HashSet<String>();
        boolean loggedError = false;
        for (class_1799 stack : class_7706.method_47344().method_45414()) {
            if (stack.method_7960()) continue;
            class_2960 location = class_7923.field_41178.method_10221((Object)stack.method_7909());
            String name = AxiomI18n.get(stack.method_7909().method_7876());
            Entry defaultItemEntry = new Entry(stack, location, ItemList.createSearchKey(name), null, null);
            itemsAll.add(defaultItemEntry);
            List resourceStack = resourceManager.method_14489(new class_2960(location.method_12836(), "models/item/" + location.method_12832() + ".json"));
            Gson gson = new Gson();
            for (class_3298 resource : resourceStack) {
                try {
                    BufferedReader bufferedReader = resource.method_43039();
                    try {
                        JsonObject object = (JsonObject)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonObject.class);
                        ItemList.registerAdditionalCustomModelsLegacy(stack, object, registeredModels, defaultTranslation, defaultLeftRotation, defaultScale, defaultRightRotation, location, itemsCustomImportant, itemsAllImportant, itemsCustom, itemsAll);
                    }
                    finally {
                        if (bufferedReader == null) continue;
                        bufferedReader.close();
                    }
                }
                catch (Exception e) {
                    if (loggedError) continue;
                    Axiom.LOGGER.error("Error finding custom model data in resourcepack", e);
                    loggedError = true;
                }
            }
        }
        itemsCustom.addAll(0, itemsCustomImportant);
        itemsAll.addAll(0, itemsAllImportant);
        this.itemsAll = Collections.unmodifiableList(itemsAll);
        this.searchedItems = this.itemsAll;
        this.itemsCustom = Collections.unmodifiableList(itemsCustom);
        ArrayList<Entry> itemsAllLengthSorted = new ArrayList<Entry>(itemsAll);
        itemsAllLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.itemsAllLengthSorted = Collections.unmodifiableList(itemsAllLengthSorted);
        ArrayList<Entry> itemsCustomLengthSorted = new ArrayList<Entry>(itemsCustom);
        itemsCustomLengthSorted.sort(Comparator.comparingInt(entry -> entry.location.method_12832().length()));
        this.itemsCustomLengthSorted = Collections.unmodifiableList(itemsCustomLengthSorted);
        this.lastSearch = "";
        this.lastOnlyCustomModels = false;
    }

    private static void registerAdditionalCustomModelsLegacy(class_1799 stack, JsonObject object, HashSet<String> registeredModels, Vector3f defaultTranslation, Quaternionf defaultLeftRotation, Vector3f defaultScale, Quaternionf defaultRightRotation, class_2960 location, ArrayList<Entry> itemsCustomImportant, ArrayList<Entry> itemsAllImportant, ArrayList<Entry> itemsCustom, ArrayList<Entry> itemsAll) {
        JsonArray overrides = object.getAsJsonArray("overrides");
        if (overrides == null) {
            return;
        }
        for (JsonElement override : overrides) {
            try {
                JsonPrimitive jsonPrimitive;
                String searchKey;
                JsonElement leftRotation;
                JsonPrimitive jsonPrimitive2;
                JsonObject overrideObj = override.getAsJsonObject();
                JsonObject predicate = overrideObj.getAsJsonObject("predicate");
                JsonElement customModelData = predicate.get("custom_model_data");
                if (customModelData == null) continue;
                int customModelDataInt = customModelData.getAsInt();
                class_1799 customStack = stack.method_7972();
                String model = overrideObj.get("model").getAsString();
                JsonElement jsonElement = overrideObj.get("axiom:hide");
                if (jsonElement instanceof JsonPrimitive && (jsonPrimitive2 = (JsonPrimitive)jsonElement).getAsBoolean() || !registeredModels.add(model)) continue;
                ItemStackDataHelper.setCustomModelData(customStack, customModelDataInt);
                ItemStackDataHelper.setHoverName(customStack, (class_2561)class_2561.method_43470((String)model).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054)));
                class_4590 defaultItemDisplayTransformation = null;
                JsonElement jsonElement2 = overrideObj.get("axiom:default_transform");
                if (jsonElement2 instanceof JsonObject) {
                    JsonArray jsonArray;
                    JsonObject defaultTransform = (JsonObject)jsonElement2;
                    Vector3f translation = defaultTranslation;
                    leftRotation = defaultLeftRotation;
                    Vector3f scale = defaultScale;
                    Quaternionf rightRotation = defaultRightRotation;
                    JsonElement jsonElement3 = defaultTransform.get("translation");
                    if (jsonElement3 instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 3) {
                        translation = new Vector3f(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("left_rotation")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 4) {
                        leftRotation = new Quaternionf(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat(), jsonArray.get(3).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("scale")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 3) {
                        scale = new Vector3f(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    }
                    if ((jsonElement3 = defaultTransform.get("right_rotation")) instanceof JsonArray && (jsonArray = (JsonArray)jsonElement3).size() == 4) {
                        rightRotation = new Quaternionf(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat(), jsonArray.get(3).getAsFloat());
                    }
                    defaultItemDisplayTransformation = new class_4590(translation, (Quaternionf)leftRotation, scale, rightRotation);
                }
                class_8104 defaultItemDisplayBrightness = null;
                leftRotation = overrideObj.get("axiom:default_brightness");
                if (leftRotation instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)leftRotation;
                    defaultItemDisplayBrightness = new class_8104(jsonObject.get("block").getAsInt(), jsonObject.get("sky").getAsInt());
                }
                if ((searchKey = model.replaceAll("[^a-zA-Z]", "")).isEmpty()) {
                    searchKey = AxiomI18n.get(stack.method_7909().method_7876());
                }
                Entry entry = new Entry(customStack, location, ItemList.createSearchKey(searchKey), defaultItemDisplayTransformation, defaultItemDisplayBrightness);
                JsonElement jsonElement4 = overrideObj.get("axiom:important");
                if (jsonElement4 instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement4).getAsBoolean()) {
                    itemsCustomImportant.add(entry);
                    itemsAllImportant.add(entry);
                    continue;
                }
                itemsCustom.add(entry);
                itemsAll.add(entry);
            }
            catch (Exception exception) {}
        }
    }

    private static String createSearchKey(String string) {
        StringBuilder searchKey = new StringBuilder();
        for (char c : string.toLowerCase(Locale.ROOT).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            searchKey.append(c);
        }
        return searchKey.toString();
    }

    public void search(String search, boolean onlyCustomModels) {
        if (this.isDirty) {
            this.reload();
        }
        if ((search = ItemList.createSearchKey(search)).equals(this.lastSearch) && this.lastOnlyCustomModels == onlyCustomModels) {
            return;
        }
        if (search.isBlank()) {
            this.searchedItems = onlyCustomModels ? this.itemsCustom : this.itemsAll;
            this.lastOnlyCustomModels = onlyCustomModels;
            this.lastSearch = search;
            return;
        }
        if (!(this.searchedItems instanceof JoinedList) || !search.startsWith(this.lastSearch) || this.lastOnlyCustomModels != onlyCustomModels) {
            this.itemsStartsWith.clear();
            this.itemsContains.clear();
            for (Entry entry2 : onlyCustomModels ? this.itemsCustomLengthSorted : this.itemsAllLengthSorted) {
                if (entry2.searchKey.startsWith(search)) {
                    this.itemsStartsWith.add(entry2);
                    continue;
                }
                if (!entry2.searchKey.contains(search)) continue;
                this.itemsContains.add(entry2);
            }
            this.searchedItems = new JoinedList<Entry>(this.itemsStartsWith, this.itemsContains);
        } else {
            String searchF = search;
            this.itemsContains.removeIf(entry -> !entry.searchKey.contains(searchF));
            this.itemsStartsWith.removeIf(entry -> {
                if (entry.searchKey.startsWith(searchF)) {
                    return false;
                }
                if (entry.searchKey.contains(searchF)) {
                    this.itemsContains.add((Entry)entry);
                }
                return true;
            });
        }
        this.lastSearch = search;
        this.lastOnlyCustomModels = onlyCustomModels;
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public List<Entry> getItems() {
        if (this.isDirty) {
            this.reload();
        }
        return this.searchedItems;
    }

    public record Entry(class_1799 itemStack, class_2960 location, String searchKey, @Nullable class_4590 defaultItemDisplayTransformation, @Nullable class_8104 defaultItemDisplayBrightness) {
    }
}

