/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.downgrade;

import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.downgrade.Downgrader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockVersionCompatibility {
    private static DowngradeVersion latestVersion;
    private static DowngradeVersion compatibilityLevel;
    private static Set<class_2248> currentInvalidBlocks;

    public static boolean isCompatible(class_2248 block) {
        if (compatibilityLevel == latestVersion) {
            return true;
        }
        return !currentInvalidBlocks.contains(block);
    }

    @Nullable
    public static DowngradeVersion getCompatibilityLevel() {
        return compatibilityLevel;
    }

    public static void setCompatibilityLevel(DowngradeVersion downgradeVersion) {
        compatibilityLevel = downgradeVersion;
        Downgrader downgrader = new Downgrader(downgradeVersion);
        currentInvalidBlocks = new HashSet<class_2248>();
        for (class_2248 block : class_7923.field_41175) {
            String serialized = class_2259.method_9685((class_2680)block.method_9564());
            String downgraded = downgrader.downgrade(serialized);
            if (downgraded != null && !downgraded.startsWith("?")) continue;
            currentInvalidBlocks.add(block);
        }
    }

    static {
        DowngradeVersion lastVersion = DowngradeVersion.values()[DowngradeVersion.values().length - 1];
        latestVersion = lastVersion.getMaxDataVersion() < class_155.method_16673().method_37912().method_38494() ? null : lastVersion;
        compatibilityLevel = latestVersion;
        currentInvalidBlocks = Set.of();
    }
}

