/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.clipboard_installation;

import com.moulberry.axiom.utils.Authorization;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;

public interface ClipboardInstallationTask {
    public void renderConfirmationPopup();

    public void start();

    public float progress();

    public boolean isFinished();

    public Exception getException();

    public static int checkStatusCode(URL url) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestProperty("User-Agent", Authorization.getUserAgent());
        httpURLConnection.setRequestMethod("GET");
        return httpURLConnection.getResponseCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] downloadWithProgress(URL url, Consumer<Float> progress) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", Authorization.getUserAgent());
            httpURLConnection.setRequestMethod("GET");
            long completeFileSize = httpURLConnection.getContentLength();
            progress.accept(Float.valueOf(0.17f));
            try (BufferedInputStream in = new BufferedInputStream(httpURLConnection.getInputStream());){
                byte[] buf;
                int n;
                ArrayList<byte[]> bufs = null;
                byte[] result = null;
                int total = 0;
                do {
                    buf = new byte[16384];
                    int nread = 0;
                    while ((n = in.read(buf, nread, buf.length - nread)) > 0) {
                        nread += n;
                    }
                    System.out.println("Read: " + nread);
                    if (nread <= 0) continue;
                    if (0x7FFFFFF7 - total < nread) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    if (nread < buf.length) {
                        buf = Arrays.copyOfRange(buf, 0, nread);
                    }
                    total += nread;
                    if (completeFileSize > 0L) {
                        progress.accept(Float.valueOf(0.3f + 0.7f * (float)((double)total / (double)completeFileSize)));
                    }
                    if (result == null) {
                        result = buf;
                        continue;
                    }
                    if (bufs == null) {
                        bufs = new ArrayList<byte[]>();
                        bufs.add(result);
                    }
                    bufs.add(buf);
                } while (n >= 0);
                if (bufs == null) {
                    if (result == null) {
                        buf = new byte[]{};
                        return buf;
                    }
                    buf = result.length == total ? result : Arrays.copyOf(result, total);
                    return buf;
                }
                result = new byte[total];
                int offset = 0;
                int remaining = total;
                for (byte[] b : bufs) {
                    int count = Math.min(b.length, remaining);
                    System.arraycopy(b, 0, result, offset, count);
                    offset += count;
                    remaining -= count;
                }
                Object object = result;
                return object;
            }
        }
        catch (Exception e) {
            if (httpURLConnection == null) throw e;
            httpURLConnection.disconnect();
            throw e;
        }
    }
}

