/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.widgets;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SearchableCombo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axi\u03bfm.utils.Authorization;
import imgui.ImGui;
import imgui.type.ImString;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_4239;
import org.jetbrains.annotations.Nullable;

public class PresetWidget {
    private final Consumer<class_2487> loadSettings;
    private final Consumer<class_2487> writeSettings;
    private final Path path;
    private final int[] activePreset = new int[]{0};
    private final ImString createPresetName = new ImString(64);
    private NamedPreset[] loadedPresets = new NamedPreset[0];
    private String[] presetNames = new String[]{AxiomI18n.getOrDefault("axiom.preset.default", "Default")};
    private final SearchableCombo searchableCombo = new SearchableCombo(new String[0]);
    private boolean loaded = false;
    private Map<String, class_2487> defaultPresets;

    public PresetWidget(Consumer<class_2487> loadSettings, Consumer<class_2487> writeSettings, String identifier, Map<String, class_2487> defaultPresets) {
        this.loadSettings = loadSettings;
        this.writeSettings = writeSettings;
        this.path = Axiom.getInstance().getConfigDirectory().resolve("tool_presets").resolve(identifier);
        this.activePreset[0] = 0;
        this.defaultPresets = defaultPresets;
    }

    public PresetWidget(Consumer<class_2487> loadSettings, Consumer<class_2487> writeSettings, String identifier) {
        this(loadSettings, writeSettings, identifier, null);
    }

    public PresetWidget(Tool tool, String identifier) {
        this(tool::loadSettings, tool::writeSettings, identifier);
    }

    private Set<String> getLoadedDefaults() {
        try {
            HashSet<String> defaults = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                for (Path child : stream) {
                    if (!child.endsWith(".defaults")) continue;
                    defaults.addAll(Files.readAllLines(child));
                }
            }
            return defaults;
        }
        catch (Exception e) {
            return Set.of();
        }
    }

    private void loadPresetsFromDisk(@Nullable Path select2) {
        try {
            Object preset2;
            ArrayList<Object> namedPresets = new ArrayList<Object>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                for (Path child : stream) {
                    Optional<class_2487> settingsOptional;
                    Optional<String> nameOptional;
                    if (!child.toString().endsWith(".nbt") || (nameOptional = VersionUtilsNbt.helperCompoundTagGetString((class_2487)(preset2 = class_2507.method_30613((File)child.toFile())), "Name")).isEmpty() || (settingsOptional = VersionUtilsNbt.helperCompoundTagGetCompound((class_2487)preset2, "Settings")).isEmpty()) continue;
                    String name = nameOptional.get();
                    class_2487 settings = settingsOptional.get();
                    namedPresets.add(new NamedPreset(name, child, settings));
                }
            }
            namedPresets.sort(Comparator.comparing(preset -> ((NamedPreset)preset).name(), String::compareToIgnoreCase).thenComparing(preset -> ((NamedPreset)preset).path().toString(), String::compareToIgnoreCase));
            ArrayList<String> presetNames = new ArrayList<String>();
            presetNames.add(AxiomI18n.getOrDefault("axiom.preset.default", "Default"));
            int selectedIndex = -1;
            for (int i = 0; i < namedPresets.size(); ++i) {
                preset2 = (NamedPreset)namedPresets.get(i);
                presetNames.add(((NamedPreset)preset2).name());
                if (!((NamedPreset)preset2).path.equals(select2)) continue;
                selectedIndex = i + 1;
            }
            this.activePreset[0] = selectedIndex;
            this.presetNames = presetNames.toArray(new String[0]);
            this.searchableCombo.setElements(this.presetNames);
            this.loadedPresets = namedPresets.toArray(new NamedPreset[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.activePreset[0] = -1;
            this.presetNames = new String[]{AxiomI18n.getOrDefault("axiom.preset.default", "Default")};
            this.searchableCombo.setElements(this.presetNames);
            this.loadedPresets = new NamedPreset[0];
        }
    }

    public void setDefault() {
        this.activePreset[0] = 0;
    }

    public void displayImgui(boolean changed) {
        if (!this.loaded) {
            Set<String> alreadyLoaded;
            this.loaded = true;
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.loadPresetsFromDisk(null);
            boolean reloadFromDisk = false;
            if (this.defaultPresets != null && !(alreadyLoaded = this.getLoadedDefaults()).containsAll(this.defaultPresets.keySet())) {
                StringBuilder defaultFile = new StringBuilder();
                block10: for (Map.Entry<String, class_2487> entry : this.defaultPresets.entrySet()) {
                    defaultFile.append(entry.getKey());
                    defaultFile.append("\n");
                    if (alreadyLoaded.contains(entry.getKey())) continue;
                    for (NamedPreset loadedPreset : this.loadedPresets) {
                        if (loadedPreset.name.trim().equalsIgnoreCase(entry.getKey().trim())) continue block10;
                    }
                    String name = entry.getKey();
                    class_2487 settings = entry.getValue();
                    try {
                        String filename = class_4239.method_19773((Path)this.path, (String)name.toLowerCase(Locale.ROOT).replace(" ", "_"), (String)".nbt");
                        class_2487 preset = new class_2487();
                        preset.method_10582("Name", name);
                        preset.method_10582("Version", Authorization.getUserAgent());
                        preset.method_10566("Settings", (class_2520)settings);
                        class_2507.method_30614((class_2487)preset, (File)this.path.resolve(filename).toFile());
                        reloadFromDisk = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Files.writeString(this.path.resolve(".defaults"), (CharSequence)defaultFile.toString(), new OpenOption[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (reloadFromDisk) {
                this.loadPresetsFromDisk(null);
            }
            this.activePreset[0] = 0;
        }
        if (changed || this.activePreset[0] >= this.presetNames.length) {
            this.activePreset[0] = -1;
        }
        if (this.searchableCombo.render("##PresetCombo", this.activePreset)) {
            if (this.activePreset[0] == 0) {
                this.loadSettings.accept(new class_2487());
            } else if (this.activePreset[0] > 0) {
                this.loadSettings.accept(this.loadedPresets[this.activePreset[0] - 1].settings);
            }
        }
        if (ImGuiHelper.beginPopup("CreatePreset")) {
            ImGui.setNextItemWidth(160.0f);
            ImGui.inputText(AxiomI18n.get("axiom.preset.name"), this.createPresetName);
            if (ImGui.button(AxiomI18n.get("axiom.preset.save"))) {
                String name = ImGuiHelper.getString(this.createPresetName);
                Path saveTo = null;
                try {
                    String filename = class_4239.method_19773((Path)this.path, (String)name.toLowerCase(Locale.ROOT).replace(" ", "_"), (String)".nbt");
                    class_2487 settings = new class_2487();
                    this.writeSettings.accept(settings);
                    class_2487 preset = new class_2487();
                    preset.method_10582("Name", name);
                    preset.method_10582("Version", Authorization.getUserAgent());
                    preset.method_10566("Settings", (class_2520)settings);
                    saveTo = this.path.resolve(filename);
                    class_2507.method_30614((class_2487)preset, (File)saveTo.toFile());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.loadPresetsFromDisk(saveTo);
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
        if (this.activePreset[0] < 0) {
            ImGui.sameLine();
            if (ImGui.button("+")) {
                ImGui.openPopup("CreatePreset");
                this.createPresetName.set("", false);
            }
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.preset.create_new_preset"));
        } else if (this.activePreset[0] > 0) {
            String tooltip = AxiomI18n.get("axiom.preset.delete", this.presetNames[this.activePreset[0]]);
            ImGui.sameLine();
            if (ImGui.button("X")) {
                try {
                    NamedPreset preset = this.loadedPresets[this.activePreset[0] - 1];
                    Files.delete(preset.path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.loadPresetsFromDisk(null);
            }
            ImGuiHelper.tooltip(tooltip);
        }
    }

    private record NamedPreset(String name, Path path, class_2487 settings) {
    }
}

