/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BlockStateWidget;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.FillOperation;
import imgui.ImGui;
import net.minecraft.class_2246;

public class FillBlocksWindow {
    private static final BlockStateWidget blockStateWidget = new BlockStateWidget(class_2246.field_10340);
    private static int[] typeSelected = new int[]{0};
    private static int width = -1;
    private static float propertiesWidth = -1.0f;

    public static void setFillType(int fillType) {
        FillBlocksWindow.typeSelected[0] = fillType;
    }

    public static void render(BlockList blockList) {
        if (!EditorWindowType.FILL.isOpen()) {
            width = -1;
            return;
        }
        if (EditorWindowType.FILL.begin("###Fill", true)) {
            boolean disable;
            boolean docked = ImGui.isWindowDocked();
            String[] typeStrings = new String[]{AxiomI18n.get("axiom.editorui.window.fill.all"), AxiomI18n.get("axiom.editorui.window.fill.inside"), AxiomI18n.get("axiom.editorui.window.fill.outline"), AxiomI18n.get("axiom.editorui.window.fill.walls"), AxiomI18n.get("axiom.editorui.window.fill.top"), AxiomI18n.get("axiom.editorui.window.fill.bottom")};
            int buttonWidth = (int)(52.0f * EditorUI.getUiScale());
            if (width == -1) {
                for (String type2 : typeStrings) {
                    width = (int)Math.max((float)width, ImGuiHelper.calcTextWidth(type2));
                }
                if ((width += (int)Math.ceil(ImGui.getFrameHeight() + ImGui.getStyle().getFramePaddingX() * 2.0f)) < buttonWidth) {
                    width = buttonWidth;
                }
            }
            float currWidth = docked ? ImGui.getContentRegionAvailX() : Math.max(propertiesWidth, (float)width);
            ImGui.setNextItemWidth(currWidth);
            ImGuiHelper.combo("##SectionType", typeSelected, typeStrings);
            ImGui.setCursorPosX(ImGui.getCursorPosX() + (currWidth - (float)buttonWidth) / 2.0f);
            blockStateWidget.renderBlockSwitcher(blockList, "Block");
            if (blockStateWidget.hasEditableProperties()) {
                ImGui.textDisabled(AxiomI18n.get("axiom.widget.block_properties"));
                propertiesWidth = blockStateWidget.renderPropertySettings("Block", docked);
            }
            if (disable = Selection.getSelectionBuffer().isEmpty()) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.fill.do_fill"), currWidth, 0.0f)) {
                int flags = switch (typeSelected[0]) {
                    case 0 -> FillOperation.FILL_ALL;
                    case 1 -> FillOperation.FILL_INSIDE;
                    case 2 -> FillOperation.FILL_EXTERIOR;
                    case 3 -> FillOperation.FILL_WALLS;
                    case 4 -> FillOperation.FILL_CEILING;
                    case 5 -> FillOperation.FILL_FLOOR;
                    default -> throw new FaultyImplementationError();
                };
                FillOperation.fill(blockStateWidget.getBlockState().getVanillaState(), flags);
            }
            if (disable) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.FILL.end();
    }
}

