/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.selection;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BlockConditionWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.MaskSelection;
import imgui.ImGui;
import net.minecraft.class_2246;

public class MaskSelectionWindow {
    private static final BlockConditionWidget blockConditionWidget = new BlockConditionWidget(class_2246.field_10340);
    private static float propertiesWidth = -1.0f;

    public static void render(BlockList blockList) {
        if (!EditorWindowType.FILTER_SELECTION.isOpen()) {
            return;
        }
        if (EditorWindowType.FILTER_SELECTION.begin("###MaskSelection", true)) {
            boolean docked = ImGui.isWindowDocked();
            String name = EditorWindowType.FILTER_SELECTION.getName();
            float currWidth = docked ? ImGui.getContentRegionAvailX() : Math.max(propertiesWidth, ImGuiHelper.calcTextWidth(name) + 40.0f);
            ImGui.setCursorPosX(ImGui.getCursorPosX() + (currWidth - 52.0f) / 2.0f);
            blockConditionWidget.renderBlockSwitcher(blockList, "MaskBlock");
            propertiesWidth = blockConditionWidget.renderPropertySettings("MaskBlock", docked).width();
            boolean disable = Selection.getSelectionBuffer().isEmpty();
            if (disable) {
                ImGui.beginDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.filter_selection.filter") + "###MaskButton", currWidth, 0.0f)) {
                MaskSelection.mask(blockConditionWidget.createCondition());
            }
            if (disable) {
                ImGui.endDisabled();
            }
        }
        EditorWindowType.FILTER_SELECTION.end();
    }
}

