/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.funcinterfaces.BiFloatPredicate;
import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.shape.TerrainDistanceField;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class RasterizationHelper {
    public static float finiteOrMaxValue(float input) {
        if (!Float.isFinite(input)) {
            return Float.MAX_VALUE;
        }
        return input;
    }

    public static float calcInvRadiusSq(float radius) {
        float invRadiusSq = 1.0f / ((radius + 0.5f) * (radius + 0.5f));
        if (!Float.isFinite(invRadiusSq)) {
            invRadiusSq = Float.MAX_VALUE;
        }
        return invRadiusSq;
    }

    public static void planeCondition(Vector3i center, int diameterX, int diameterZ, Quaternionf quaternionf, BiFloatPredicate condition, TriIntConsumer accept) {
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f side = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f up = new Vector3f(0.0f, 0.0f, 1.0f);
        quaternionf.transformInverse(normal);
        quaternionf.transformInverse(side);
        quaternionf.transformInverse(up);
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        double normalX = Math.abs(normal.x());
        double normalY = Math.abs(normal.y());
        double normalZ = Math.abs(normal.z());
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        float offsetX = -(radiusX % 1.0f) * side.x - radiusZ % 1.0f * up.x;
        float offsetY = -(radiusX % 1.0f) * side.y - radiusZ % 1.0f * up.y;
        float offsetZ = -(radiusX % 1.0f) * side.z - radiusZ % 1.0f * up.z;
        float planarK = -(offsetX * normal.x + offsetY * normal.y + offsetZ * normal.z);
        Vector3f minimum = new Vector3f();
        Vector3f maximum = new Vector3f();
        for (int x = -1; x <= 1; x += 2) {
            for (int z = -1; z <= 1; z += 2) {
                Vector3f pos = new Vector3f(radiusX * (float)x, 0.0f, radiusZ * (float)z);
                quaternionf.transformInverse(pos);
                if (pos.x < minimum.x) {
                    minimum.x = pos.x;
                }
                if (pos.y < minimum.y) {
                    minimum.y = pos.y;
                }
                if (pos.z < minimum.z) {
                    minimum.z = pos.z;
                }
                if (pos.x > maximum.x) {
                    maximum.x = pos.x;
                }
                if (pos.y > maximum.y) {
                    maximum.y = pos.y;
                }
                if (!(pos.z > maximum.z)) continue;
                maximum.z = pos.z;
            }
        }
        if (normalX > normalY && normalX > normalZ) {
            int minY = (int)Math.floor(minimum.y);
            int maxY = (int)Math.ceil(maximum.y);
            int minZ = (int)Math.floor(minimum.z);
            int maxZ = (int)Math.ceil(maximum.z);
            Vector3f vec = new Vector3f();
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    float x = -(((float)y + offsetY) * normal.y + ((float)z + offsetZ) * normal.z + planarK) / normal.x;
                    vec.set(x, (float)y + offsetY, (float)z + offsetZ);
                    float rx = side.dot((Vector3fc)vec);
                    float rz = up.dot((Vector3fc)vec);
                    if (!condition.test(rx, rz)) continue;
                    int roundedX = Math.round(x);
                    accept.accept(roundedX + centerX, y + centerY, z + centerZ);
                }
            }
        } else if (normalY > normalZ) {
            minX = (int)Math.floor(minimum.x);
            maxX = (int)Math.ceil(maximum.x);
            int minZ = (int)Math.floor(minimum.z);
            int maxZ = (int)Math.ceil(maximum.z);
            Vector3f vec = new Vector3f();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    float y = -(((float)x + offsetX) * normal.x + ((float)z + offsetZ) * normal.z + planarK) / normal.y;
                    vec.set((float)x + offsetX, y, (float)z + offsetZ);
                    float rx = side.dot((Vector3fc)vec);
                    float rz = up.dot((Vector3fc)vec);
                    if (!condition.test(rx, rz)) continue;
                    int roundedY = Math.round(y);
                    accept.accept(x + centerX, roundedY + centerY, z + centerZ);
                }
            }
        } else {
            minX = (int)Math.floor(minimum.x);
            maxX = (int)Math.ceil(maximum.x);
            int minY = (int)Math.floor(minimum.y);
            int maxY = (int)Math.ceil(maximum.y);
            Vector3f vec = new Vector3f();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    float z = -(((float)x + offsetX) * normal.x + ((float)y + offsetY) * normal.y + planarK) / normal.z;
                    vec.set((float)x + offsetX, (float)y + offsetY, z);
                    float rx = side.dot((Vector3fc)vec);
                    float rz = up.dot((Vector3fc)vec);
                    if (!condition.test(rx, rz)) continue;
                    int roundedZ = Math.round(z);
                    accept.accept(x + centerX, y + centerY, roundedZ + centerZ);
                }
            }
        }
    }

    public static void metaball(class_1937 level, ChunkedBlockRegion region, int metaballRange, class_2680 block, class_2338 center, int maxRadiusX, int maxRadiusY, int maxRadiusZ, TriIntPredicate insideShape) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int centerX = center.method_10263();
        int centerY = center.method_10264();
        int centerZ = center.method_10260();
        TerrainDistanceField.calculateChamferEuclideanTwo((x, y, z) -> level.method_8320((class_2338)mutableBlockPos.method_10103(x + centerX, y + centerY, z + centerZ)).method_51366(), insideShape, -maxRadiusX, -maxRadiusY, -maxRadiusZ, maxRadiusX, maxRadiusY, maxRadiusZ, (x, y, z, terrainDistance, shapeDistance) -> {
            if (shapeDistance <= 0.0f) {
                region.addBlock(x + centerX, y + centerY, z + centerZ, block);
                return;
            }
            if (terrainDistance <= 0.0f) {
                return;
            }
            float terrainAmount = (float)metaballRange / ((float)metaballRange + terrainDistance * terrainDistance) - 1.0f / (float)(1 + metaballRange);
            float shapeAmount = (float)metaballRange / ((float)metaballRange + shapeDistance * shapeDistance) - 1.0f / (float)(1 + metaballRange);
            if (terrainAmount + shapeAmount >= 1.0f) {
                region.addBlock(x + centerX, y + centerY, z + centerZ, block);
            }
        });
    }

    private static float sqr(float x) {
        return x * x;
    }

    private static float getRootEllipse(float r0, float z0, float z1, float g2) {
        float n0 = r0 * z0;
        float s0 = z1 - 1.0f;
        float s1 = g2 < 0.0f ? 0.0f : (float)Math.sqrt(n0 * n0 + z1 * z1) - 1.0f;
        float s2 = 0.0f;
        for (int i = 0; i < 100; ++i) {
            s2 = (s0 + s1) / 2.0f;
            if (s1 - s0 < 0.01f) break;
            float ratio0 = n0 / (s2 + r0);
            float ratio1 = z1 / (s2 + 1.0f);
            g2 = RasterizationHelper.sqr(ratio0) + RasterizationHelper.sqr(ratio1) - 1.0f;
            if (g2 > 0.0f) {
                s0 = s2;
                continue;
            }
            if (!(g2 < 0.0f)) break;
            s1 = s2;
        }
        return s2;
    }

    public static float distancePointEllipse(float e0, float e1, float y0, float y1, @Nullable Vector2f intersection) {
        boolean swapped = false;
        if (e0 < e1) {
            float temp = e1;
            e1 = e0;
            e0 = temp;
            temp = y1;
            y1 = y0;
            y0 = temp;
            swapped = true;
        }
        boolean negate0 = false;
        if (y0 < 0.0f) {
            y0 = -y0;
            negate0 = true;
        }
        boolean negate1 = false;
        if (y1 < 0.0f) {
            y1 = -y1;
            negate1 = true;
        }
        float distance = RasterizationHelper.distancePointEllipseInner(e0, e1, y0, y1, intersection);
        if (intersection != null) {
            if (negate1) {
                intersection.y *= -1.0f;
            }
            if (negate0) {
                intersection.x *= -1.0f;
            }
            if (swapped) {
                float temp = intersection.x;
                intersection.x = intersection.y;
                intersection.y = temp;
            }
        }
        return distance;
    }

    private static float distancePointEllipseInner(float e0, float e1, float p0, float p1, @Nullable Vector2f intersection) {
        if (p1 > 0.0f) {
            if (p0 > 0.0f) {
                float z0 = p0 / e0;
                float z1 = p1 / e1;
                float g2 = RasterizationHelper.sqr(z0) + RasterizationHelper.sqr(z1) - 1.0f;
                if (g2 != 0.0f) {
                    float r0 = RasterizationHelper.sqr(e0 / e1);
                    float sbar = RasterizationHelper.getRootEllipse(r0, z0, z1, g2);
                    float c0 = r0 * p0 / (sbar + r0);
                    float c1 = p1 / (sbar + 1.0f);
                    if (intersection != null) {
                        intersection.set(c0, c1);
                    }
                    return (float)Math.sqrt(RasterizationHelper.sqr(c0 - p0) + RasterizationHelper.sqr(c1 - p1));
                }
                if (intersection != null) {
                    intersection.set(p0, p1);
                }
                return 0.0f;
            }
            if (intersection != null) {
                intersection.set(0.0f, e1);
            }
            return Math.abs(p1 - e1);
        }
        float numer0 = e0 * p0;
        float denom0 = RasterizationHelper.sqr(e0) - RasterizationHelper.sqr(e1);
        if (numer0 < denom0) {
            float xde0 = numer0 / denom0;
            float c0 = e0 * xde0;
            float c1 = e1 * (float)Math.sqrt(1.0f - xde0 * xde0);
            if (intersection != null) {
                intersection.set(c0, c1);
            }
            return (float)Math.sqrt(RasterizationHelper.sqr(c0 - p0) + RasterizationHelper.sqr(c1));
        }
        if (intersection != null) {
            intersection.set(e0, 0.0f);
        }
        return Math.abs(p0 - e0);
    }

    private static float getRootEllipsoid(float r0, float r1, float z0, float z1, float z2, float g2) {
        float n0 = r0 * z0;
        float n1 = r1 * z1;
        float s0 = z2 - 1.0f;
        float s1 = g2 < 0.0f ? 0.0f : (float)Math.sqrt(n0 * n0 + n1 * n1 + z2 * z2) - 1.0f;
        float s2 = 0.0f;
        for (int i = 0; i < 100; ++i) {
            s2 = (s0 + s1) / 2.0f;
            if (s1 - s0 < 0.01f) break;
            float ratio0 = n0 / (s2 + r0);
            float ratio1 = n1 / (s2 + r1);
            float ratio2 = z2 / (s2 + 1.0f);
            g2 = RasterizationHelper.sqr(ratio0) + RasterizationHelper.sqr(ratio1) + RasterizationHelper.sqr(ratio2) - 1.0f;
            if (g2 > 0.0f) {
                s0 = s2;
                continue;
            }
            if (!(g2 < 0.0f)) break;
            s1 = s2;
        }
        return s2;
    }

    public static float distancePointEllipsoid(float e0, float e1, float e2, float y0, float y1, float y2, @Nullable Vector3f intersection) {
        boolean swapped01 = false;
        if (e0 < e1) {
            float temp = e1;
            e1 = e0;
            e0 = temp;
            temp = y1;
            y1 = y0;
            y0 = temp;
            swapped01 = true;
        }
        boolean swapped02 = false;
        if (e0 < e2) {
            float temp = e2;
            e2 = e0;
            e0 = temp;
            temp = y2;
            y2 = y0;
            y0 = temp;
            swapped02 = true;
        }
        boolean swapped12 = false;
        if (e1 < e2) {
            float temp = e2;
            e2 = e1;
            e1 = temp;
            temp = y2;
            y2 = y1;
            y1 = temp;
            swapped12 = true;
        }
        boolean negate0 = false;
        if (y0 < 0.0f) {
            y0 = -y0;
            negate0 = true;
        }
        boolean negate1 = false;
        if (y1 < 0.0f) {
            y1 = -y1;
            negate1 = true;
        }
        boolean negate2 = false;
        if (y2 < 0.0f) {
            y2 = -y2;
            negate2 = true;
        }
        float distance = RasterizationHelper.distancePointEllipsoidInner(e0, e1, e2, y0, y1, y2, intersection);
        if (intersection != null) {
            float temp;
            if (negate2) {
                intersection.z *= -1.0f;
            }
            if (negate1) {
                intersection.y *= -1.0f;
            }
            if (negate0) {
                intersection.x *= -1.0f;
            }
            if (swapped12) {
                temp = intersection.y;
                intersection.y = intersection.z;
                intersection.z = temp;
            }
            if (swapped02) {
                temp = intersection.x;
                intersection.x = intersection.z;
                intersection.z = temp;
            }
            if (swapped01) {
                temp = intersection.x;
                intersection.x = intersection.y;
                intersection.y = temp;
            }
        }
        return distance;
    }

    private static float distancePointEllipsoidInner(float e0, float e1, float e2, float y0, float y1, float y2, @Nullable Vector3f intersection) {
        float xde1;
        float xde1sqr;
        float xde0;
        float xde0sqr;
        float discr;
        if (y2 > 0.0f) {
            if (y1 > 0.0f) {
                if (y0 > 0.0f) {
                    float z0 = y0 / e0;
                    float z1 = y1 / e1;
                    float z2 = y2 / e2;
                    float g2 = RasterizationHelper.sqr(z0) + RasterizationHelper.sqr(z1) + RasterizationHelper.sqr(z2) - 1.0f;
                    if (g2 != 0.0f) {
                        float r0 = RasterizationHelper.sqr(e0 / e2);
                        float r1 = RasterizationHelper.sqr(e1 / e2);
                        float sbar = RasterizationHelper.getRootEllipsoid(r0, r1, z0, z1, z2, g2);
                        float x0 = r0 * y0 / (sbar + r0);
                        float x1 = r1 * y1 / (sbar + r1);
                        float x2 = y2 / (sbar + 1.0f);
                        if (intersection != null) {
                            intersection.set(x0, x1, x2);
                        }
                        return (float)Math.sqrt(RasterizationHelper.sqr(x0 - y0) + RasterizationHelper.sqr(x1 - y1) + RasterizationHelper.sqr(x2 - y2));
                    }
                    if (intersection != null) {
                        intersection.set(y0, y1, y2);
                    }
                    return 0.0f;
                }
                if (intersection == null) {
                    return RasterizationHelper.distancePointEllipse(e1, e2, y1, y2, null);
                }
                Vector2f vector2f = new Vector2f();
                float distance = RasterizationHelper.distancePointEllipse(e1, e2, y1, y2, vector2f);
                intersection.set(0.0f, vector2f.x, vector2f.y);
                return distance;
            }
            if (y0 > 0.0f) {
                if (intersection == null) {
                    return RasterizationHelper.distancePointEllipse(e0, e2, y0, y2, null);
                }
                Vector2f vector2f = new Vector2f();
                float distance = RasterizationHelper.distancePointEllipse(e0, e2, y0, y2, vector2f);
                intersection.set(vector2f.x, 0.0f, vector2f.y);
                return distance;
            }
            if (intersection != null) {
                intersection.set(0.0f, 0.0f, e2);
            }
            return Math.abs(y2 - e2);
        }
        float denom0 = e0 * 0.0f - e2 * e2;
        float denom1 = e1 * e1 - e2 * e2;
        float numer0 = e0 * y0;
        float numer1 = e1 * y1;
        if (numer0 < denom0 && numer1 < denom1 && (discr = 1.0f - (xde0sqr = (xde0 = numer0 / denom0) * xde0) - (xde1sqr = (xde1 = numer1 / denom1) * xde1)) > 0.0f) {
            float x0 = e0 * xde0;
            float x1 = e1 * xde1;
            float x2 = e2 * (float)Math.sqrt(discr);
            float distance = (float)Math.sqrt((x0 - y0) * (x0 - y0) + (x1 - y1) * (x1 - y1) + x2 * x2);
            if (intersection != null) {
                intersection.set(x0, x1, x2);
            }
            return distance;
        }
        if (intersection == null) {
            return RasterizationHelper.distancePointEllipse(e0, e1, y0, y1, null);
        }
        Vector2f vector2f = new Vector2f();
        float distance = RasterizationHelper.distancePointEllipse(e0, e1, y0, y1, vector2f);
        intersection.set(vector2f.x, vector2f.y, 0.0f);
        return distance;
    }
}

