/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.screen;

import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.block_maps.BlockColourMap;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.hooks.CreativeModeInventoryScreenExt;
import com.moulberry.axiom.screen.CreativeGradientScreen;
import com.moulberry.axiom.screen.CustomCreativeTabButton;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.OkLabColourUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5916;
import net.minecraft.class_746;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class CreativeColourScreen
extends class_465<ItemPickerMenu> {
    private static final class_1277 CONTAINER = new class_1277(10);
    private static int scrollAmount = 0;
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("axiom", "textures/gui/creative_tab_colour_picker.png");
    private static final class_2960 DYNAMIC_TEXTURE_LOCATION = new class_2960("axiom", "dynamic/creative_colour_screen");
    private static final class_2960 INSET_CREATIVE_COLOUR_FLAG = new class_2960("axiom:inset_creative_colour_flag_toggle");
    private final class_481 creativeScreen;
    private AutoCleaningDynamicTexture dynamicTexture = null;
    public static int currentFlags = BlockColourMap.FLAG_SOLID | BlockColourMap.FLAG_OPAQUE | BlockColourMap.FLAG_FULL_CUBE;
    private static float currentHue = 0.0f;
    private static float currentSaturation = 1.0f;
    private static float currentBrightness = 1.0f;
    private float lastHue = currentHue;
    private int lastScale = 1;
    private float lastSaturation = currentSaturation;
    private float lastBrightness = currentBrightness;
    private int draggingElement = -1;
    private static int DRAGGING_SATVAL = 0;
    private static int DRAGGING_LARGE_HUE = 1;
    private static int DRAGGING_RGB_OR_HSV_START = 2;
    private final class_342[] rgbHsbInputs = new class_342[6];
    private class_342 hexEditBox = null;
    private boolean settingEditBoxes = false;

    public CreativeColourScreen(class_746 localPlayer, class_481 creativeScreen) {
        super((class_1703)new ItemPickerMenu((class_1657)localPlayer), localPlayer.method_31548(), class_5244.field_39003);
        localPlayer.field_7512 = this.field_2797;
        this.creativeScreen = creativeScreen;
        this.field_2779 = 136;
        this.field_2792 = 195;
    }

    protected void method_25426() {
        if (this.field_22787 != null && !this.field_22787.field_1724.method_31549().field_7477) {
            this.field_22787.method_1507((class_437)new class_490((class_1657)this.field_22787.field_1724));
            return;
        }
        super.method_25426();
        this.creativeScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
        CustomCreativeTabButton button = new CustomCreativeTabButton(this.field_2776 - 36, this.field_2800 + 30, 26, 26, (class_2561)class_2561.method_43470((String)"Colour Picker"), new class_1799((class_1935)class_1802.field_8192), () -> class_310.method_1551().method_1507((class_437)new CreativeColourScreen(this.field_22787.field_1724, this.creativeScreen)));
        button.field_22763 = false;
        this.method_37063((class_364)button);
        this.method_37063((class_364)new CustomCreativeTabButton(this.field_2776 - 36, this.field_2800 + 30 + 36, 26, 26, (class_2561)class_2561.method_43470((String)"Gradient Helper"), new class_1799((class_1935)class_1802.field_42716), () -> class_310.method_1551().method_1507((class_437)new CreativeGradientScreen(this.field_22787.field_1724, this.creativeScreen))));
        for (int i = 0; i < 6; ++i) {
            int y = this.field_2800 + 19 + 11 * i;
            if (i >= 3) {
                y += 6;
            }
            class_342 editBox = new class_342(this.field_22793, this.field_2776 + 156, y, 31, 9, class_5244.field_39003);
            editBox.method_1880(6);
            editBox.method_1858(false);
            editBox.method_1862(true);
            editBox.method_1868(0xFFFFFF);
            int editBoxType = i;
            editBox.method_1863(input -> {
                if (this.settingEditBoxes) {
                    return;
                }
                editBox.method_1868(0xFF0000);
                try {
                    float value = Float.parseFloat(input);
                    switch (editBoxType) {
                        case 0: {
                            this.setRGB(Math.max(0.0f, Math.min(255.0f, value)), -1.0f, -1.0f, true, false);
                            break;
                        }
                        case 1: {
                            this.setRGB(-1.0f, Math.max(0.0f, Math.min(255.0f, value)), -1.0f, true, false);
                            break;
                        }
                        case 2: {
                            this.setRGB(-1.0f, -1.0f, Math.max(0.0f, Math.min(255.0f, value)), true, false);
                            break;
                        }
                        case 3: {
                            this.setHSB(Math.max(0.0f, Math.min(360.0f, value)) / 360.0f, -1.0f, -1.0f, true);
                            break;
                        }
                        case 4: {
                            this.setHSB(-1.0f, Math.max(0.0f, Math.min(100.0f, value)) / 100.0f, -1.0f, true);
                            break;
                        }
                        case 5: {
                            this.setHSB(-1.0f, -1.0f, Math.max(0.0f, Math.min(100.0f, value) / 100.0f), true);
                        }
                    }
                    editBox.method_1868(0xFFFFFF);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)editBox);
            this.rgbHsbInputs[i] = editBox;
        }
        this.hexEditBox = new class_342(this.field_22793, this.field_2776 + 128, this.field_2800 + 94, 60, 9, class_5244.field_39003);
        this.hexEditBox.method_1880(10);
        this.hexEditBox.method_1858(false);
        this.hexEditBox.method_1868(0xFFFFFF);
        this.hexEditBox.method_47404((class_2561)class_2561.method_43470((String)"#FF0000"));
        this.hexEditBox.method_1863(input -> {
            String replaced;
            if (this.settingEditBoxes) {
                return;
            }
            this.hexEditBox.method_1868(0xFF0000);
            if (input.startsWith("0x")) {
                input = input.substring(2);
            }
            if ((replaced = input.trim().toLowerCase(Locale.ROOT).replaceAll("[^0-9a-f]", "")).isEmpty()) {
                return;
            }
            if (replaced.length() > 6) {
                replaced = replaced.substring(0, 6);
            } else if (replaced.length() < 6) {
                char lastChar = replaced.charAt(replaced.length() - 1);
                StringBuilder builder = new StringBuilder(replaced);
                while (builder.length() < 6) {
                    builder.append(lastChar);
                }
                replaced = builder.toString();
            }
            try {
                int hex = (int)Long.parseLong(replaced, 16);
                int red = hex >> 16 & 0xFF;
                int green = hex >> 8 & 0xFF;
                int blue = hex & 0xFF;
                this.setRGB(red, green, blue, false, true);
                this.hexEditBox.method_1868(0xFFFFFF);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.method_37063((class_364)this.hexEditBox);
        float[] rgb = new float[3];
        ColourUtils.HSBtoRGB(currentHue, currentSaturation, currentBrightness, rgb);
        this.settingEditBoxes = true;
        this.rgbHsbInputs[0].method_1852(String.format("%.1f", Float.valueOf(rgb[0])));
        this.rgbHsbInputs[1].method_1852(String.format("%.1f", Float.valueOf(rgb[1])));
        this.rgbHsbInputs[2].method_1852(String.format("%.1f", Float.valueOf(rgb[2])));
        this.rgbHsbInputs[3].method_1852(String.format("%.1f", Float.valueOf(currentHue * 360.0f)));
        this.rgbHsbInputs[4].method_1852(String.format("%.1f", Float.valueOf(currentSaturation * 100.0f)));
        this.rgbHsbInputs[5].method_1852(String.format("%.1f", Float.valueOf(currentBrightness * 100.0f)));
        this.hexEditBox.method_1852(String.format("#%06x", (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2]));
        this.settingEditBoxes = false;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.method_25423(minecraft, width, height);
    }

    public boolean method_25400(char c, int i) {
        for (class_342 rgbHsbInput : this.rgbHsbInputs) {
            if (!rgbHsbInput.method_25400(c, i)) continue;
            return true;
        }
        return this.hexEditBox.method_25400(c, i);
    }

    public boolean method_25404(int i, int j, int k) {
        boolean hasFocused = false;
        for (class_342 rgbHsbInput : this.rgbHsbInputs) {
            if (rgbHsbInput.method_25404(i, j, k)) {
                return true;
            }
            if (rgbHsbInput.method_25370() && i == 256) {
                rgbHsbInput.method_25365(false);
                return true;
            }
            hasFocused |= rgbHsbInput.method_25370();
        }
        if (this.hexEditBox.method_25404(i, j, k)) {
            return true;
        }
        if (this.hexEditBox.method_25370() && i == 256) {
            this.hexEditBox.method_25365(false);
            return true;
        }
        if (hasFocused |= this.hexEditBox.method_25370()) {
            return true;
        }
        if (this.field_22787.field_1690.field_1890.method_1417(i, j)) {
            ((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$selectTab(class_7706.method_47344());
            this.field_22787.method_1507((class_437)this.creativeScreen);
            return true;
        }
        return super.method_25404(i, j, k);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        for (class_1761 creativeModeTab : class_7706.method_47335()) {
            ((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$renderTabButton(guiGraphics, creativeModeTab, true);
        }
        VersionUtilsClient.genericBlit(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256, -1);
        int sliderHeight = 11;
        for (int i = 0; i < 6; ++i) {
            String letter = "RGBHSB".substring(i, i + 1);
            int y = this.field_2800 + 19 + sliderHeight * i;
            if (i >= 3) {
                y += 6;
            }
            guiGraphics.method_51433(this.field_22793, letter, this.field_2776 + 104, y, 0x404040, false);
        }
        guiGraphics.method_51433(this.field_22793, "Hex:", this.field_2776 + 103, this.field_2800 + 94, 0x404040, false);
        if ((currentFlags & BlockColourMap.FLAG_FULL_CUBE) != 0) {
            VersionUtilsClient.genericBlitSprite(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), INSET_CREATIVE_COLOUR_FLAG, this.field_2776 + 46, this.field_2800 + 92, 12, 12);
        }
        if ((currentFlags & BlockColourMap.FLAG_SOLID) != 0) {
            VersionUtilsClient.genericBlitSprite(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), INSET_CREATIVE_COLOUR_FLAG, this.field_2776 + 60, this.field_2800 + 92, 12, 12);
        }
        if ((currentFlags & BlockColourMap.FLAG_OPAQUE) != 0) {
            VersionUtilsClient.genericBlitSprite(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), INSET_CREATIVE_COLOUR_FLAG, this.field_2776 + 74, this.field_2800 + 92, 12, 12);
        }
        if ((currentFlags & BlockColourMap.FLAG_SAME_TEXTURE) != 0) {
            VersionUtilsClient.genericBlitSprite(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), INSET_CREATIVE_COLOUR_FLAG, this.field_2776 + 88, this.field_2800 + 92, 12, 12);
        }
        guiGraphics.method_25300(this.field_22793, "F", this.field_2776 + 52, this.field_2800 + 94, -1);
        guiGraphics.method_25300(this.field_22793, "S", this.field_2776 + 66, this.field_2800 + 94, -1);
        guiGraphics.method_25300(this.field_22793, "O", this.field_2776 + 80, this.field_2800 + 94, -1);
        guiGraphics.method_25300(this.field_22793, "T", this.field_2776 + 94, this.field_2800 + 94, -1);
        int scale = Math.max(1, (int)class_310.method_1551().method_22683().method_4495());
        if (this.dynamicTexture == null || this.lastHue != currentHue || this.lastSaturation != currentSaturation || this.lastBrightness != currentBrightness || this.lastScale != scale) {
            int x;
            int argb;
            this.lastHue = currentHue;
            this.lastSaturation = currentSaturation;
            this.lastBrightness = currentBrightness;
            if (this.dynamicTexture == null) {
                this.dynamicTexture = new AutoCleaningDynamicTexture(107 * scale, 70 * scale, true);
                this.lastScale = scale;
            } else if (this.lastScale != scale) {
                this.dynamicTexture.close();
                this.dynamicTexture = new AutoCleaningDynamicTexture(107 * scale, 70 * scale, true);
                this.lastScale = scale;
            }
            class_1011 image = this.dynamicTexture.method_4525();
            int currentHueH = (int)(currentHue * (float)(52 * scale - 1));
            float[] rgb = new float[3];
            for (int h2 = 0; h2 < 52 * scale; ++h2) {
                int currentHueDelta = Math.abs(currentHueH - h2);
                if (currentHueDelta == 0) {
                    argb = -16777216;
                } else if (currentHueDelta <= 1) {
                    argb = -1;
                } else {
                    float hue = (float)h2 / (52.0f * (float)scale - 1.0f);
                    ColourUtils.HSBtoRGB(hue, 1.0f, 1.0f, rgb);
                    argb = 0xFF000000 | (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2];
                }
                for (x = 45 * scale; x < 54 * scale; ++x) {
                    image.method_4305(x, h2, ColourUtils.argbToAbgr(argb));
                }
            }
            int currentSaturationX = (int)(currentSaturation * (float)(43 * scale - 1));
            int currentBrightnessY = (int)((1.0f - currentBrightness) * (float)(52 * scale - 1));
            for (int x2 = 0; x2 < 43 * scale; ++x2) {
                for (int y = 0; y < 52 * scale; ++y) {
                    int argb2;
                    int currentBrightnessDelta;
                    float saturation = (float)x2 / (43.0f * (float)scale - 1.0f);
                    float brightness = 1.0f - (float)y / (52.0f * (float)scale - 1.0f);
                    int currentSaturationDelta = Math.abs(currentSaturationX - x2);
                    int currentDelta = Math.min(currentSaturationDelta, currentBrightnessDelta = Math.abs(currentBrightnessY - y));
                    if (currentDelta == 0) {
                        argb2 = -16777216;
                    } else if (Math.abs(currentDelta) <= 1) {
                        argb2 = -1;
                    } else {
                        ColourUtils.HSBtoRGB(currentHue, saturation, brightness, rgb);
                        argb2 = 0xFF000000 | (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2];
                    }
                    image.method_4305(x2, y, ColourUtils.argbToAbgr(argb2));
                }
            }
            ColourUtils.HSBtoRGB(currentHue, currentSaturation, currentBrightness, rgb);
            argb = 0xFF000000 | (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2];
            for (x = 0; x < 36 * scale; ++x) {
                for (int y = 54 * scale; y < 70 * scale; ++y) {
                    image.method_4305(x, y, ColourUtils.argbToAbgr(argb));
                }
            }
            float currentRed = rgb[0];
            float currentGreen = rgb[1];
            float currentBlue = rgb[2];
            int currentRedX = (int)(currentRed / 255.0f * (float)(42 * scale - 1));
            int currentGreenX = (int)(currentGreen / 255.0f * (float)(42 * scale - 1));
            int currentBlueX = (int)(currentBlue / 255.0f * (float)(42 * scale - 1));
            int currentHX = (int)(currentHue * (float)(42 * scale - 1));
            int currentSX = (int)(currentSaturation * (float)(42 * scale - 1));
            int currentBX = (int)(currentBrightness * (float)(42 * scale - 1));
            for (int i = 0; i < 6; ++i) {
                int y;
                int currentDelta;
                int x3;
                if (i < 3) {
                    for (x3 = 0; x3 < 42 * scale; ++x3) {
                        currentDelta = i == 0 ? Math.abs(currentRedX - x3) : (i == 1 ? Math.abs(currentGreenX - x3) : Math.abs(currentBlueX - x3));
                        if (currentDelta == 0) {
                            argb = -16777216;
                        } else if (Math.abs(currentDelta) <= 1) {
                            argb = -1;
                        } else {
                            float red = i == 0 ? (float)x3 / (42.0f * (float)scale - 1.0f) * 255.0f : currentRed;
                            float green = i == 1 ? (float)x3 / (42.0f * (float)scale - 1.0f) * 255.0f : currentGreen;
                            float blue = i == 2 ? (float)x3 / (42.0f * (float)scale - 1.0f) * 255.0f : currentBlue;
                            argb = 0xFF000000 | (int)red << 16 | (int)green << 8 | (int)blue;
                        }
                        for (y = 0; y < 9 * scale; ++y) {
                            image.method_4305(x3 + 65 * scale, sliderHeight * i * scale + y, ColourUtils.argbToAbgr(argb));
                        }
                    }
                    continue;
                }
                for (x3 = 0; x3 < 42 * scale; ++x3) {
                    currentDelta = i == 3 ? Math.abs(currentHX - x3) : (i == 4 ? Math.abs(currentSX - x3) : Math.abs(currentBX - x3));
                    if (currentDelta == 0) {
                        argb = -16777216;
                    } else if (Math.abs(currentDelta) <= 1) {
                        argb = -1;
                    } else {
                        float h3 = i == 3 ? (float)x3 / (42.0f * (float)scale - 1.0f) : currentHue;
                        float s2 = i == 4 ? (float)x3 / (42.0f * (float)scale - 1.0f) : currentSaturation;
                        float b = i == 5 ? (float)x3 / (42.0f * (float)scale - 1.0f) : currentBrightness;
                        ColourUtils.HSBtoRGB(h3, s2, b, rgb);
                        argb = 0xFF000000 | (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2];
                    }
                    for (y = 0; y < 9 * scale; ++y) {
                        image.method_4305(x3 + 65 * scale, (6 + sliderHeight * i) * scale + y, ColourUtils.argbToAbgr(argb));
                    }
                }
            }
            this.dynamicTexture.method_4524();
            this.updateNearestBlocks(true);
        }
        class_310.method_1551().method_1531().method_4616(DYNAMIC_TEXTURE_LOCATION, (class_1044)this.dynamicTexture);
        VersionUtilsClient.genericBlit(guiGraphics, VersionUtilsClient.renderTypeGuiTextured(), DYNAMIC_TEXTURE_LOCATION, this.field_2776 + 46, this.field_2800 + 18, 0.0f, 0.0f, 107, 70, 107 * scale, 70 * scale, 107 * scale, 70 * scale, -1);
    }

    private void updateNearestBlocks(boolean resetScroll) {
        if (resetScroll) {
            scrollAmount = 0;
        }
        float[] rgb = new float[3];
        ColourUtils.HSBtoRGB(currentHue, currentSaturation, currentBrightness, rgb);
        double[] lab = new double[3];
        OkLabColourUtils.rgb2lab(rgb[0], rgb[1], rgb[2], lab);
        List<class_2680> blocks = BlockColourMap.getNearestLabN(lab[0], lab[1], lab[2], currentFlags, 20 + scrollAmount);
        CONTAINER.method_5448();
        int toSkip = scrollAmount;
        int index = 0;
        HashSet<class_1799> addedItems = new HashSet<class_1799>();
        for (int i = blocks.size() - 1; i >= 0; --i) {
            class_2680 blockState = blocks.get(i);
            class_1799 itemStack = ServerCustomBlocks.getCustomOrVanillaStateFor(blockState).getCustomBlock().axiom$asItemStack();
            if (itemStack.method_7960() || !addedItems.add(itemStack)) continue;
            if (toSkip > 0) {
                --toSkip;
                continue;
            }
            CONTAINER.method_5447(index, itemStack);
            if (++index >= 10) break;
        }
    }

    protected void method_2388(class_332 guiGraphics, int i, int j) {
        guiGraphics.method_51433(this.field_22793, "Colour Picker", 8, 6, 0x404040, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_1761 creativeModeTab;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.draggingElement != -1) {
            return;
        }
        if (mouseX >= this.field_2776 + 8 && mouseX <= this.field_2776 + 44 && mouseY >= this.field_2800 + 16 && mouseY <= this.field_2800 + 16 + 90) {
            guiGraphics.method_51448().method_22903();
            int scale = Math.max(1, (int)class_310.method_1551().method_22683().method_4495());
            float offset = (float)Math.floor((float)scale / 2.0f + 0.4f) / (float)scale;
            guiGraphics.method_51448().method_46416(offset, offset, 266.0f);
            for (int i = 0; i < 10; ++i) {
                int x = 17 + i % 2 * 18;
                int y = 22 + i / 2 * 18;
                guiGraphics.method_25300(this.field_22793, "#" + (i + 1 + scrollAmount), this.field_2776 + x, this.field_2800 + y, 0x40FFFFFF);
            }
            guiGraphics.method_51448().method_22909();
        }
        if (mouseY >= this.field_2800 + 92 && mouseY <= this.field_2800 + 104) {
            if (mouseX >= this.field_2776 + 46 && mouseX <= this.field_2776 + 58) {
                class_5250 enabledOrDisabled = (currentFlags & BlockColourMap.FLAG_FULL_CUBE) != 0 ? class_2561.method_43470((String)"[Enabled]").method_27692(class_124.field_1060) : class_2561.method_43470((String)"[Disabled]").method_27692(class_124.field_1061);
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43470((String)"Full Cube").method_27692(class_124.field_1054), class_2561.method_43470((String)"Must be a full 1x1x1 cube"), enabledOrDisabled), Optional.empty(), mouseX, mouseY);
                return;
            }
            if (mouseX >= this.field_2776 + 60 && mouseX <= this.field_2776 + 72) {
                class_5250 enabledOrDisabled = (currentFlags & BlockColourMap.FLAG_SOLID) != 0 ? class_2561.method_43470((String)"[Enabled]").method_27692(class_124.field_1060) : class_2561.method_43470((String)"[Disabled]").method_27692(class_124.field_1061);
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43470((String)"Solid").method_27692(class_124.field_1054), class_2561.method_43470((String)"Must be collidable"), enabledOrDisabled), Optional.empty(), mouseX, mouseY);
                return;
            }
            if (mouseX >= this.field_2776 + 74 && mouseX <= this.field_2776 + 86) {
                class_5250 enabledOrDisabled = (currentFlags & BlockColourMap.FLAG_OPAQUE) != 0 ? class_2561.method_43470((String)"[Enabled]").method_27692(class_124.field_1060) : class_2561.method_43470((String)"[Disabled]").method_27692(class_124.field_1061);
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43470((String)"Opaque").method_27692(class_124.field_1054), class_2561.method_43470((String)"Must not be transparent"), enabledOrDisabled), Optional.empty(), mouseX, mouseY);
                return;
            }
            if (mouseX >= this.field_2776 + 88 && mouseX <= this.field_2776 + 100) {
                class_5250 enabledOrDisabled = (currentFlags & BlockColourMap.FLAG_SAME_TEXTURE) != 0 ? class_2561.method_43470((String)"[Enabled]").method_27692(class_124.field_1060) : class_2561.method_43470((String)"[Disabled]").method_27692(class_124.field_1061);
                guiGraphics.method_51437(this.field_22793, List.of(class_2561.method_43470((String)"Same Texture").method_27692(class_124.field_1054), class_2561.method_43470((String)"Must have the same texture on all sides"), enabledOrDisabled), Optional.empty(), mouseX, mouseY);
                return;
            }
        }
        Iterator iterator = class_7706.method_47335().iterator();
        while (iterator.hasNext() && !((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$checkTabHovering(guiGraphics, creativeModeTab = (class_1761)iterator.next(), mouseX, mouseY)) {
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (this.draggingElement != -1) {
            float relX = (float)mouseX - (float)this.field_2776;
            float relY = (float)mouseY - (float)this.field_2800;
            if (this.draggingElement == DRAGGING_SATVAL) {
                float s2 = Math.max(0.0f, Math.min(1.0f, (relX - 46.0f) / 43.0f));
                float b = 1.0f - Math.max(0.0f, Math.min(1.0f, (relY - 18.0f) / 52.0f));
                this.setHSB(-1.0f, s2, b, false);
            } else if (this.draggingElement == DRAGGING_LARGE_HUE) {
                float h2 = Math.max(0.0f, Math.min(1.0f, (relY - 18.0f) / 52.0f));
                this.setHSB(h2, -1.0f, -1.0f, false);
            } else {
                float value = Math.max(0.0f, Math.min(1.0f, (relX - 111.0f) / 42.0f));
                switch (this.draggingElement) {
                    case 2: {
                        this.setRGB(value * 255.0f, -1.0f, -1.0f, false, false);
                        break;
                    }
                    case 3: {
                        this.setRGB(-1.0f, value * 255.0f, -1.0f, false, false);
                        break;
                    }
                    case 4: {
                        this.setRGB(-1.0f, -1.0f, value * 255.0f, false, false);
                        break;
                    }
                    case 5: {
                        this.setHSB(value, -1.0f, -1.0f, false);
                        break;
                    }
                    case 6: {
                        this.setHSB(-1.0f, value, -1.0f, false);
                        break;
                    }
                    case 7: {
                        this.setHSB(-1.0f, -1.0f, value, false);
                    }
                }
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
    }

    private void setRGB(float r, float g2, float b, boolean skipSameEditBox, boolean skipHex) {
        float[] rgb = new float[3];
        ColourUtils.HSBtoRGB(currentHue, currentSaturation, currentBrightness, rgb);
        if (r >= 0.0f) {
            rgb[0] = r;
        }
        if (g2 >= 0.0f) {
            rgb[1] = g2;
        }
        if (b >= 0.0f) {
            rgb[2] = b;
        }
        float[] hsb = new float[3];
        ColourUtils.RGBtoHSB(rgb[0], rgb[1], rgb[2], hsb);
        currentHue = hsb[0];
        currentSaturation = hsb[1];
        currentBrightness = hsb[2];
        this.settingEditBoxes = true;
        if (!skipSameEditBox || r < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[0], String.format("%.1f", Float.valueOf(rgb[0])));
        }
        if (!skipSameEditBox || g2 < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[1], String.format("%.1f", Float.valueOf(rgb[1])));
        }
        if (!skipSameEditBox || b < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[2], String.format("%.1f", Float.valueOf(rgb[2])));
        }
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[3], String.format("%.1f", Float.valueOf(currentHue * 360.0f)));
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[4], String.format("%.1f", Float.valueOf(currentSaturation * 100.0f)));
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[5], String.format("%.1f", Float.valueOf(currentBrightness * 100.0f)));
        if (!skipHex) {
            CreativeColourScreen.setValueIfDifferent(this.hexEditBox, String.format("#%06x", (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2]));
        }
        this.settingEditBoxes = false;
    }

    private void setHSB(float h2, float s2, float b, boolean skipSameEditBox) {
        if (h2 >= 0.0f) {
            currentHue = h2;
        }
        if (s2 >= 0.0f) {
            currentSaturation = s2;
        }
        if (b >= 0.0f) {
            currentBrightness = b;
        }
        float[] rgb = new float[3];
        ColourUtils.HSBtoRGB(currentHue, currentSaturation, currentBrightness, rgb);
        this.settingEditBoxes = true;
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[0], String.format("%.1f", Float.valueOf(rgb[0])));
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[1], String.format("%.1f", Float.valueOf(rgb[1])));
        CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[2], String.format("%.1f", Float.valueOf(rgb[2])));
        if (!skipSameEditBox || h2 < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[3], String.format("%.1f", Float.valueOf(currentHue * 360.0f)));
        }
        if (!skipSameEditBox || s2 < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[4], String.format("%.1f", Float.valueOf(currentSaturation * 100.0f)));
        }
        if (!skipSameEditBox || b < 0.0f) {
            CreativeColourScreen.setValueIfDifferent(this.rgbHsbInputs[5], String.format("%.1f", Float.valueOf(currentBrightness * 100.0f)));
        }
        CreativeColourScreen.setValueIfDifferent(this.hexEditBox, String.format("#%06x", (int)rgb[0] << 16 | (int)rgb[1] << 8 | (int)rgb[2]));
        this.settingEditBoxes = false;
    }

    private static void setValueIfDifferent(class_342 editBox, String value) {
        if (!editBox.method_1882().equals(value)) {
            editBox.method_1852(value);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        VersionUtilsClient.helperClearFocus((class_437)this);
        if (mouseButton == 0) {
            this.draggingElement = -1;
            double relX = mouseX - (double)this.field_2776;
            double relY = mouseY - (double)this.field_2800;
            if (mouseY >= (double)(this.field_2800 + 92) && mouseY <= (double)(this.field_2800 + 104)) {
                if (mouseX >= (double)(this.field_2776 + 46) && mouseX <= (double)(this.field_2776 + 58)) {
                    currentFlags = (currentFlags & BlockColourMap.FLAG_FULL_CUBE) != 0 ? (currentFlags &= ~BlockColourMap.FLAG_FULL_CUBE) : (currentFlags |= BlockColourMap.FLAG_FULL_CUBE);
                    this.updateNearestBlocks(true);
                    return true;
                }
                if (mouseX >= (double)(this.field_2776 + 60) && mouseX <= (double)(this.field_2776 + 72)) {
                    currentFlags = (currentFlags & BlockColourMap.FLAG_SOLID) != 0 ? (currentFlags &= ~BlockColourMap.FLAG_SOLID) : (currentFlags |= BlockColourMap.FLAG_SOLID);
                    this.updateNearestBlocks(true);
                    return true;
                }
                if (mouseX >= (double)(this.field_2776 + 74) && mouseX <= (double)(this.field_2776 + 86)) {
                    currentFlags = (currentFlags & BlockColourMap.FLAG_OPAQUE) != 0 ? (currentFlags &= ~BlockColourMap.FLAG_OPAQUE) : (currentFlags |= BlockColourMap.FLAG_OPAQUE);
                    this.updateNearestBlocks(true);
                    return true;
                }
                if (mouseX >= (double)(this.field_2776 + 88) && mouseX <= (double)(this.field_2776 + 100)) {
                    currentFlags = (currentFlags & BlockColourMap.FLAG_SAME_TEXTURE) != 0 ? (currentFlags &= ~BlockColourMap.FLAG_SAME_TEXTURE) : (currentFlags |= BlockColourMap.FLAG_SAME_TEXTURE);
                    this.updateNearestBlocks(true);
                    return true;
                }
            }
            for (class_1761 creativeModeTab : class_7706.method_47335()) {
                if (!((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$checkTabClicked(creativeModeTab, relX, relY)) continue;
                return true;
            }
            if (relX >= 46.0 && relX <= 89.0 && relY >= 18.0 && relY <= 70.0) {
                this.draggingElement = DRAGGING_SATVAL;
            } else if (relX >= 91.0 && relX <= 100.0 && relY >= 18.0 && relY <= 70.0) {
                this.draggingElement = DRAGGING_LARGE_HUE;
            } else if (relX >= 111.0 && relX <= 153.0) {
                for (int i = 0; i < 6; ++i) {
                    int y = 18 + 11 * i;
                    if (i >= 3) {
                        y += 6;
                    }
                    if (!(relY >= (double)y) || !(relY <= (double)(y + 9))) continue;
                    this.draggingElement = DRAGGING_RGB_OR_HSV_START + i;
                }
            }
            if (this.draggingElement != -1) {
                class_1041 window = class_310.method_1551().method_22683();
                double[] xpos = new double[1];
                double[] ypos = new double[1];
                GLFW.glfwGetCursorPos((long)window.method_4490(), (double[])xpos, (double[])ypos);
                double mouseXD = xpos[0] * (double)window.method_4486() / (double)window.method_4480();
                double mouseYD = ypos[0] * (double)window.method_4502() / (double)window.method_4507();
                this.method_25403(mouseXD, mouseYD, mouseButton, 0.0, 0.0);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.draggingElement != -1) {
                this.draggingElement = -1;
                return true;
            }
            double relX = mouseX - (double)this.field_2776;
            double relY = mouseY - (double)this.field_2800;
            for (class_1761 creativeModeTab : class_7706.method_47335()) {
                if (!((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$checkTabClicked(creativeModeTab, relX, relY)) continue;
                ((CreativeModeInventoryScreenExt)this.creativeScreen).axiom$selectTab(creativeModeTab);
                class_310.method_1551().method_1507((class_437)this.creativeScreen);
                return true;
            }
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        int newScrollAmount;
        if (super.method_25401(mouseX, mouseY, scroll)) {
            return true;
        }
        if (mouseX >= (double)(this.field_2776 + 8) && mouseX <= (double)(this.field_2776 + 44) && mouseY >= (double)(this.field_2800 + 16) && mouseY <= (double)(this.field_2800 + 16 + 90) && (newScrollAmount = Math.max(0, Math.min(90, scrollAmount - (int)Math.signum(scroll) * 2))) != scrollAmount) {
            scrollAmount = newScrollAmount;
            this.updateNearestBlocks(false);
            return true;
        }
        return false;
    }

    protected void method_2383(@Nullable class_1735 slot, int i, int j, class_1713 clickType) {
        boolean isShiftClick = clickType == class_1713.field_7794;
        class_1713 class_17132 = clickType = i == -999 && clickType == class_1713.field_7790 ? class_1713.field_7795 : clickType;
        if (slot == null && clickType != class_1713.field_7789) {
            ((ItemPickerMenu)this.field_2797).method_34254(class_1799.field_8037);
            return;
        }
        if (slot != null && !slot.method_7674((class_1657)this.field_22787.field_1724)) {
            return;
        }
        if (slot == ((ItemPickerMenu)this.field_2797).pickColourItemSlot) {
            double[] lab;
            class_1799 carried = ((ItemPickerMenu)this.field_2797).method_34255();
            CustomBlock block = ServerCustomBlocks.getFromItemStack(carried);
            if (block != null && block != class_2246.field_10124 && (lab = BlockColourMap.getLab(block)) != null) {
                int rgb = OkLabColourUtils.lab2rgb(lab[0], lab[1], lab[2]);
                float[] hsb = new float[3];
                ColourUtils.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
                this.setHSB(hsb[0], hsb[1], hsb[2], false);
            }
            return;
        }
        if (slot == ((ItemPickerMenu)this.field_2797).destroyItemSlot && isShiftClick) {
            for (int slotIndex = 0; slotIndex < this.field_22787.field_1724.field_7498.method_7602().size(); ++slotIndex) {
                if (!class_1723.method_36211((int)slotIndex)) continue;
                this.field_22787.field_1724.field_7498.method_7611(slotIndex).method_7673(class_1799.field_8037);
                this.field_22787.field_1761.method_2909(class_1799.field_8037, slotIndex);
            }
            return;
        }
        if (slot == ((ItemPickerMenu)this.field_2797).destroyItemSlot) {
            ((ItemPickerMenu)this.field_2797).method_34254(class_1799.field_8037);
            return;
        }
        if (clickType != class_1713.field_7789 && slot.field_7871 == CONTAINER) {
            class_1799 itemStack = ((ItemPickerMenu)this.field_2797).method_34255();
            class_1799 itemStack2 = slot.method_7677();
            if (clickType == class_1713.field_7791) {
                if (!itemStack2.method_7960()) {
                    this.field_22787.field_1724.method_31548().method_5447(j, itemStack2.method_46651(itemStack2.method_7914()));
                    ((ItemPickerMenu)this.field_2797).method_7623();
                    this.field_22787.field_1724.field_7498.method_7623();
                }
                return;
            }
            if (clickType == class_1713.field_7796) {
                if (((ItemPickerMenu)this.field_2797).method_34255().method_7960() && slot.method_7681()) {
                    class_1799 itemStack3 = slot.method_7677();
                    ((ItemPickerMenu)this.field_2797).method_34254(itemStack3.method_46651(itemStack3.method_7914()));
                }
                return;
            }
            if (!itemStack.method_7960() && !itemStack2.method_7960() && class_1799.method_31577((class_1799)itemStack, (class_1799)itemStack2)) {
                if (j == 0) {
                    if (isShiftClick) {
                        itemStack.method_7939(itemStack.method_7914());
                    } else if (itemStack.method_7947() < itemStack.method_7914()) {
                        itemStack.method_7933(1);
                    }
                } else {
                    itemStack.method_7934(1);
                }
            } else if (!itemStack2.method_7960() && itemStack.method_7960()) {
                int l = isShiftClick ? itemStack2.method_7914() : itemStack2.method_7947();
                ((ItemPickerMenu)this.field_2797).method_34254(itemStack2.method_46651(l));
            } else if (j == 0) {
                ((ItemPickerMenu)this.field_2797).method_34254(class_1799.field_8037);
            } else if (!((ItemPickerMenu)this.field_2797).method_34255().method_7960()) {
                ((ItemPickerMenu)this.field_2797).method_34255().method_7934(1);
            }
        } else if (this.field_2797 != null) {
            ((ItemPickerMenu)this.field_2797).method_7593(slot == null ? i : slot.field_7874, j, clickType, (class_1657)this.field_22787.field_1724);
            ((ItemPickerMenu)this.field_2797).method_7623();
            this.field_22787.field_1724.field_7498.method_7623();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemPickerMenu
    extends class_1703 {
        private final class_1703 inventoryMenu;
        private final class_1735 destroyItemSlot;
        private final class_1735 pickColourItemSlot;

        public ItemPickerMenu(class_1657 player) {
            super(null, 0);
            this.inventoryMenu = player.field_7498;
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < CONTAINER.method_5439(); ++i) {
                this.method_7621(new class_1735((class_1263)CONTAINER, i, 9 + i % 2 * 18, 18 + i / 2 * 18));
            }
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new class_1735((class_1263)inventory, k, 9 + k * 18, 112));
            }
            this.pickColourItemSlot = new class_1735((class_1263)CONTAINER, 999, 84, 72);
            this.method_7621(this.pickColourItemSlot);
            this.destroyItemSlot = new class_1735((class_1263)CONTAINER, 999, 173, 112);
            this.method_7621(this.destroyItemSlot);
            this.method_34248(new class_5916(){

                public void method_34263(class_1703 abstractContainerMenu, class_2371<class_1799> nonNullList, class_1799 itemStack, int[] is) {
                }

                public void method_34261(class_1703 abstractContainerMenu, int index, class_1799 itemStack) {
                    if (index >= CONTAINER.method_5439() && index < CONTAINER.method_5439() + 9) {
                        class_310.method_1551().field_1761.method_2909(itemStack, 36 + index - CONTAINER.method_5439());
                    }
                }

                public void method_34262(class_1703 abstractContainerMenu, class_1799 itemStack) {
                }

                public void method_34260(class_1703 abstractContainerMenu, int i, int j) {
                }
            });
        }

        public boolean method_7597(class_1657 player) {
            return true;
        }

        public class_1799 method_7601(class_1657 player, int i) {
            class_1735 slot;
            if (i >= this.field_7761.size() - 11 && i < this.field_7761.size() - 2 && (slot = (class_1735)this.field_7761.get(i)) != null && slot.method_7681()) {
                slot.method_48931(class_1799.field_8037);
            }
            return class_1799.field_8037;
        }

        public boolean method_7613(class_1799 itemStack, class_1735 slot) {
            return slot.field_7871 != CONTAINER;
        }

        public boolean method_7615(class_1735 slot) {
            return slot.field_7871 != CONTAINER;
        }

        public class_1799 method_34255() {
            return this.inventoryMenu.method_34255();
        }

        public void method_34254(class_1799 itemStack) {
            this.inventoryMenu.method_34254(itemStack);
        }

        public void method_7619(int index, int state, class_1799 itemStack) {
            if (index >= CONTAINER.method_5439() && index < CONTAINER.method_5439() + 9) {
                super.method_7619(index, state, itemStack);
            }
        }
    }
}

