/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.extrude;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.extrude.ExtrudeExpandTask;
import com.moulberry.axiom.tools.extrude.ExtrudeShrinkTask;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class ExtrudeTool
implements Tool {
    private ChunkedBooleanRegion shrinkRegion = new ChunkedBooleanRegion();
    private ChunkedBlockRegion expandRegion = new ChunkedBlockRegion();
    private class_2338 lastHoveredBlockPos = null;
    private class_2350 lastHoveredDirection = null;
    private long lastUseMillis = 0L;
    private boolean shrink = false;
    private boolean displace = false;
    private int[] compareMode = new int[]{0};
    private final float[] limit = new float[]{100000.0f};
    private int[] count = new int[]{1};
    private boolean corners = false;
    private Future<Object> livePreviewFuture = null;

    @Override
    public void reset() {
        this.lastHoveredBlockPos = null;
        this.lastHoveredDirection = null;
        this.lastUseMillis = System.currentTimeMillis();
        this.expandRegion.clear();
        this.shrinkRegion.clear();
        if (this.livePreviewFuture != null) {
            this.livePreviewFuture.cancel(true);
            this.livePreviewFuture = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public void rightClick() {
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        class_2487 sourceInfo = Tool.getSourceInfo(this);
        if (this.shrink) {
            ExtrudeShrinkTask task = new ExtrudeShrinkTask((class_1937)world, result.getBlockPos(), result.getDirection(), this.compareMode[0], true, this.displace, this.count[0], this.corners);
            task.perform((int)this.limit[0]);
            String countString = NumberFormat.getInstance().format(task.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.extrude_tool", countString);
            RegionHelper.pushBlockRegionChange(task.chunkedBlockRegion, historyDescription, sourceInfo);
        } else {
            ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
            ExtrudeExpandTask task = new ExtrudeExpandTask((class_1937)world, result.getBlockPos(), result.getDirection(), this.compareMode[0], this.displace, this.count[0], this.corners);
            task.perform((int)this.limit[0]);
            task.expandBlocks.forEachEntry(chunkedBlockRegion::addBlock);
            String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.extrude_tool", countString);
            RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, sourceInfo);
        }
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (Tool.getLookDirection() == null) {
            Selection.render(camera, time, matrices, projection, 7);
            return;
        }
        Selection.render(camera, time, matrices, projection, 4);
        if (this.livePreviewFuture != null && this.livePreviewFuture.isDone()) {
            try {
                Object extrudeTask = this.livePreviewFuture.get();
                if (extrudeTask instanceof ExtrudeExpandTask) {
                    ExtrudeExpandTask extrudeExpandTask = (ExtrudeExpandTask)extrudeTask;
                    if (!this.shrink) {
                        this.lastHoveredDirection = extrudeExpandTask.direction;
                        this.lastHoveredBlockPos = extrudeExpandTask.initialPosition;
                        this.expandRegion.clear();
                        extrudeExpandTask.expandBlocks.forEachEntry(this.expandRegion::addBlockWithoutDirty);
                        this.expandRegion.dirtyAll();
                    }
                } else if (extrudeTask instanceof ExtrudeShrinkTask) {
                    ExtrudeShrinkTask extrudeShrinkTask = (ExtrudeShrinkTask)extrudeTask;
                    if (this.shrink) {
                        this.lastHoveredDirection = extrudeShrinkTask.direction;
                        this.lastHoveredBlockPos = extrudeShrinkTask.initialPosition;
                        this.shrinkRegion.clear();
                        extrudeShrinkTask.shrinkBlocks.forEach(this.shrinkRegion::add);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            this.livePreviewFuture = null;
        }
        if (this.livePreviewFuture == null) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                return;
            }
            if (!result.getDirection().equals((Object)this.lastHoveredDirection)) {
                this.updateSelectedBlocks(result);
            } else if (!result.getBlockPos().equals((Object)this.lastHoveredBlockPos)) {
                this.updateSelectedBlocks(result);
            }
        }
        if (this.shrink) {
            this.shrinkRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
        } else {
            long sinceLastUse = System.currentTimeMillis() - this.lastUseMillis;
            if ((double)sinceLastUse > 1000000.0) {
                this.lastUseMillis = System.currentTimeMillis() - 2000L;
            }
            float opacity = (float)Math.sin((float)sinceLastUse / 400.0f - 3.429f);
            if (sinceLastUse > 0L && sinceLastUse < 2000L) {
                this.expandRegion.render(camera, class_243.field_1353, matrices, projection, (float)sinceLastUse / 2000.0f, 0.75f - opacity * 0.5f);
            } else {
                this.expandRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.75f - opacity * 0.5f);
            }
        }
    }

    private void updateSelectedBlocks(RayCaster.RaycastResult result) {
        class_638 world = class_310.method_1551().field_1687;
        if (this.shrink) {
            ExtrudeShrinkTask task = new ExtrudeShrinkTask((class_1937)world, result.getBlockPos(), result.getDirection(), this.compareMode[0], false, false, this.count[0], this.corners);
            this.livePreviewFuture = Tool.sharedPoolThreadExecutor.submit(() -> {
                task.perform((int)this.limit[0]);
                return task;
            });
        } else {
            ExtrudeExpandTask task = new ExtrudeExpandTask((class_1937)world, result.getBlockPos(), result.getDirection(), this.compareMode[0], false, this.count[0], this.corners);
            this.livePreviewFuture = Tool.sharedPoolThreadExecutor.submit(() -> {
                task.perform((int)this.limit[0]);
                return task;
            });
        }
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.extrude.mode"));
        int newShrink = -1;
        if (!this.shrink) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.extrude.mode.expand"))) {
            newShrink = 0;
        }
        if (!this.shrink) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        if (this.shrink) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.extrude.mode.shrink"))) {
            newShrink = 1;
        }
        if (this.shrink) {
            ImGui.endDisabled();
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.extrude.displace"), this.displace)) {
            this.displace = !this.displace;
        }
        ImGui.sameLine();
        if (this.shrink) {
            ImGuiHelper.helpMarker(AxiomI18n.get("axiom.tool.extrude.displace_shrink_description"));
        } else {
            ImGuiHelper.helpMarker(AxiomI18n.get("axiom.tool.extrude.displace_expand_description"));
        }
        if (newShrink != -1) {
            boolean bl = this.shrink = newShrink == 1;
            if (this.shrink) {
                this.expandRegion.clear();
            } else {
                this.shrinkRegion.clear();
            }
            if (this.livePreviewFuture != null) {
                this.livePreviewFuture.cancel(true);
                this.livePreviewFuture = null;
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.extrude"));
        ImGuiHelper.Label compare = ImGuiHelper.translateLabel("axiom.tool.magic_select.compare_mode");
        ImGuiHelper.Label limit = ImGuiHelper.translateLabel("axiom.tool.generic.limit");
        ImGuiHelper.LabelPosition labelPosition = ImGuiHelper.calcLabelPosition(compare, limit);
        ImGuiHelper.drawLabelledWidget(compare, labelPosition, label -> ImGuiHelper.combo(label, this.compareMode, new String[]{AxiomI18n.get("axiom.tool.magic_select.compare_block"), AxiomI18n.get("axiom.tool.magic_select.compare_blockstate"), AxiomI18n.get("axiom.tool.magic_select.compare_solid"), AxiomI18n.get("axiom.tool.magic_select.compare_any")}));
        ImGuiHelper.drawLabelledWidget(limit, labelPosition, label -> ImGui.sliderFloat(label, this.limit, 2.0f, 1.0E7f, "%'.0f", 32));
        if (!this.displace) {
            ImGui.sliderInt("Count", this.count, 1, 32);
        }
        if (ImGui.checkbox("Corners", this.corners)) {
            this.corners = !this.corners;
        }
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.extrude");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Extrude Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10556("Shrink", this.shrink);
        tag.method_10556("Displace", this.displace);
        tag.method_10569("Compare", this.compareMode[0]);
        tag.method_10569("Limit", (int)this.limit[0]);
        tag.method_10569("Count", this.count[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.shrink = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "Shrink", false);
        this.displace = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "Displace", false);
        this.compareMode[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Compare", 0);
        this.limit[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "Limit", 100000);
    }

    @Override
    public char iconChar() {
        return '\ue904';
    }

    @Override
    public String keybindId() {
        return "extrude";
    }

    @Override
    public int defaultKeybind() {
        return 89;
    }
}

