/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.fluidball;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2ByteMap;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.text.NumberFormat;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class FluidBall
implements Tool {
    private final ChunkedBooleanRegion chunkedBooleanRegion = new ChunkedBooleanRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private final int[] quality = new int[]{10};
    private final int[] flowLength = new int[]{8};
    private boolean removeFluidsWithoutSource = true;
    private boolean fillEdges = true;
    private final int[] fluidType = new int[]{0};
    private boolean infiniteSources = true;
    private boolean requireSupportToFlow = false;
    private FluidSimulation currentJob = null;

    @Override
    public void reset() {
        this.usingTool = false;
        this.currentJob = null;
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
        this.chunkedBooleanRegion.clear();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                this.usingTool = true;
                BrushShape brushShape = this.brushWidget.getBrushShape();
                MaskElement maskElement = MaskManager.getDestMask();
                MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
                this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                    maskContext.reset();
                    class_2680 blockState = maskContext.getBlockState(x, y, z);
                    if (blockState.method_45474() && maskElement.test(maskContext, x, y, z)) {
                        this.chunkedBooleanRegion.add(x, y, z);
                    }
                }));
                this.pathProvider.includeFluids = true;
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.currentJob != null) {
            this.runFluidSimulationJob(250L, false);
            return;
        }
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 1);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            FluidSimulation job = this.createFluidSimulationJob();
            this.reset();
            this.currentJob = job;
            this.runFluidSimulationJob(1000L, false);
        } else {
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            this.chunkedBooleanRegion.render(camera, class_243.field_1353, matrices, projection, time, 1);
        }
    }

    private Position2FloatMap createInitialLevelMap() {
        Position2FloatMap levelMap = new Position2FloatMap();
        this.chunkedBooleanRegion.forEach((x, y, z) -> levelMap.put(x, y, z, 8.0f));
        return levelMap;
    }

    private FluidSimulation createFluidSimulationJob() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        PositionSet checkedExistingWater = new PositionSet();
        Position2ByteMap worldStateMap = FluidBall.createWorldStateMap(level, this.fluidType[0]);
        this.chunkedBooleanRegion.forEach((x, y, z) -> {
            checkedExistingWater.add(x, y, z);
            worldStateMap.put(x, y, z, (byte)0);
        });
        float minDelta = 8.0f / (float)Math.max(1, Math.min(32, this.flowLength[0]));
        return new FluidSimulation(this.createInitialLevelMap(), checkedExistingWater, worldStateMap, minDelta, this.infiniteSources, this.requireSupportToFlow);
    }

    private void runFluidSimulationJob(long millis, boolean forceFinish) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            this.currentJob = null;
            return;
        }
        int maxIterations = this.quality[0] * 1000;
        this.currentJob.runUntil(maxIterations, millis);
        if (this.currentJob.iterations >= maxIterations || this.currentJob.isFinished() || forceFinish) {
            class_2758 property;
            class_2680 fluid;
            Position2FloatMap oldLevelMap;
            Position2FloatMap newLevelMap;
            Position2FloatMap levelMap = this.currentJob.levelMap;
            Position2ByteMap worldStateMap = this.currentJob.worldStateMap;
            PositionSet checkedExistingWater = this.currentJob.checkedExistingWater;
            float minDelta = this.currentJob.minDelta;
            BooleanWrapper booleanWrapper = new BooleanWrapper(true);
            while (booleanWrapper.value) {
                booleanWrapper.value = false;
                newLevelMap = new Position2FloatMap();
                oldLevelMap = levelMap;
                levelMap.forEachEntry((x, y, z, f) -> {
                    byte belowState = worldStateMap.getOrCreate(x, y - 1, z);
                    if (belowState >= 0) {
                        float belowLevel;
                        if (belowState >= 1 && checkedExistingWater.add(x, y - 1, z)) {
                            belowLevel = newLevelMap.add(x, y - 1, z, belowState);
                            booleanWrapper.value = true;
                        } else {
                            belowLevel = oldLevelMap.get(x, y - 1, z);
                        }
                        if (belowLevel < 8.0f) {
                            float transferred = Math.min(f, 8.0f - belowLevel);
                            newLevelMap.add(x, y - 1, z, transferred);
                            f -= transferred;
                            booleanWrapper.value = true;
                        }
                    }
                    if (f > 8.0f) {
                        newLevelMap.add(x, y, z, 8.0f);
                        newLevelMap.add(x, y + 1, z, f - 8.0f);
                        booleanWrapper.value = true;
                    } else {
                        newLevelMap.add(x, y, z, f);
                    }
                });
                levelMap = newLevelMap;
            }
            if (this.removeFluidsWithoutSource) {
                LongOpenHashSet check = new LongOpenHashSet();
                Position2FloatMap newLevelMap2 = new Position2FloatMap();
                levelMap.forEachEntry((arg_0, arg_1, arg_2, arg_3) -> FluidBall.lambda$runFluidSimulationJob$4(newLevelMap2, (LongSet)check, arg_0, arg_1, arg_2, arg_3));
                LongOpenHashSet currentCheck = check;
                while (!currentCheck.isEmpty()) {
                    LongOpenHashSet newCheck = new LongOpenHashSet();
                    LongIterator longIterator = currentCheck.longIterator();
                    while (longIterator.hasNext()) {
                        float minusZ;
                        float plusZ;
                        float minusX;
                        int z2;
                        int y2;
                        long pos = longIterator.nextLong();
                        int x2 = class_2338.method_10061((long)pos);
                        float threshold = newLevelMap2.get(x2, y2 = class_2338.method_10071((long)pos), z2 = class_2338.method_10083((long)pos));
                        if (Math.round(threshold) <= 0) continue;
                        float plusX = levelMap.get(x2 + 1, y2, z2);
                        if (Math.round(plusX) > 0 && newLevelMap2.max(x2 + 1, y2, z2, Math.min(plusX, threshold - minDelta))) {
                            newCheck.add(class_2338.method_10064((int)(x2 + 1), (int)y2, (int)z2));
                        }
                        if (Math.round(minusX = levelMap.get(x2 - 1, y2, z2)) > 0 && newLevelMap2.max(x2 - 1, y2, z2, Math.min(minusX, threshold - minDelta))) {
                            newCheck.add(class_2338.method_10064((int)(x2 - 1), (int)y2, (int)z2));
                        }
                        if (Math.round(plusZ = levelMap.get(x2, y2, z2 + 1)) > 0 && newLevelMap2.max(x2, y2, z2 + 1, Math.min(plusZ, threshold - minDelta))) {
                            newCheck.add(class_2338.method_10064((int)x2, (int)y2, (int)(z2 + 1)));
                        }
                        if (Math.round(minusZ = levelMap.get(x2, y2, z2 - 1)) <= 0 || !newLevelMap2.max(x2, y2, z2 - 1, Math.min(minusZ, threshold - minDelta))) continue;
                        newCheck.add(class_2338.method_10064((int)x2, (int)y2, (int)(z2 - 1)));
                    }
                    currentCheck = newCheck;
                }
                levelMap = newLevelMap2;
            }
            if (this.fillEdges) {
                newLevelMap = new Position2FloatMap();
                oldLevelMap = levelMap;
                int[] offsets = new int[]{1, 0, -1, 0, 0, 1, 0, -1};
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                levelMap.forEachEntry((x, y, z, f) -> {
                    newLevelMap.max(x, y, z, f);
                    if (Math.round(f) <= 0) {
                        return;
                    }
                    class_2680 below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z));
                    if (below.method_45474()) {
                        return;
                    }
                    for (int offsetIndex = 0; offsetIndex < offsets.length; offsetIndex += 2) {
                        class_2680 down;
                        int offsetX = offsets[offsetIndex];
                        int offsetZ = offsets[offsetIndex + 1];
                        if (oldLevelMap.get(x + offsetX, y, z + offsetZ) > 0.5f || !level.method_8320((class_2338)mutableBlockPos.method_10103(x + offsetX, y, z + offsetZ)).method_45474() || !(down = level.method_8320((class_2338)mutableBlockPos.method_10103(x + offsetX, y - 1, z + offsetZ))).method_45474() || newLevelMap.get(x + offsetX, y, z + offsetZ) > 1.0f) continue;
                        boolean foundFluid = false;
                        int ny = y - 1;
                        while (down.method_45474() && down.method_26204() != class_2246.field_10243) {
                            if (oldLevelMap.get(x + offsetX, ny, z + offsetZ) > 0.5f) {
                                foundFluid = true;
                                break;
                            }
                            down = level.method_8320((class_2338)mutableBlockPos.method_10103(x + offsetX, --ny, z + offsetZ));
                        }
                        if (!foundFluid) continue;
                        newLevelMap.put(x + offsetX, y, z + offsetZ, 1.0f);
                        for (int yo = ny; yo < y; ++yo) {
                            newLevelMap.put(x + offsetX, yo, z + offsetZ, 8.0f);
                        }
                    }
                });
                levelMap = newLevelMap;
            }
            ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            if (this.fluidType[0] == 1) {
                fluid = class_2246.field_10164.method_9564();
                property = class_2741.field_12538;
            } else if (this.fluidType[0] == 2) {
                fluid = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(8));
                property = class_2741.field_12536;
            } else {
                fluid = class_2246.field_10382.method_9564();
                property = class_2741.field_12538;
            }
            Position2FloatMap finalLevelMap = levelMap;
            checkedExistingWater.forEach((x, y, z) -> {
                class_2680 existing = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (existing.method_26204() == class_2246.field_10243) {
                    return;
                }
                if (finalLevelMap.get(x, y, z) > 0.0f) {
                    return;
                }
                if (this.fluidType[0] == 0 && existing.method_28498((class_2769)class_2741.field_12508)) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)existing.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
                } else {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, class_2246.field_10124.method_9564());
                }
            });
            levelMap.forEachEntry((x, y, z, f) -> {
                class_2680 existing = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (existing.method_26204() == class_2246.field_10243) {
                    return;
                }
                int roundedLevel = Math.round(f);
                if (this.fluidType[0] == 0 && existing.method_26204() != fluid.method_26204()) {
                    class_3610 fluidState;
                    if (existing.method_28498((class_2769)class_2741.field_12508)) {
                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)existing.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(roundedLevel > 0)));
                        return;
                    }
                    if (roundedLevel > 0 && ((fluidState = existing.method_26227()).method_39360((class_3611)class_3612.field_15910) || fluidState.method_39360((class_3611)class_3612.field_15909))) {
                        return;
                    }
                }
                if (roundedLevel >= 8) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fluid);
                } else if (roundedLevel > 0) {
                    class_2680 blockState = property == class_2741.field_12538 ? (class_2680)fluid.method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(8 - roundedLevel)) : (class_2680)fluid.method_11657((class_2769)property, (Comparable)Integer.valueOf(roundedLevel));
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, blockState);
                } else {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, class_2246.field_10124.method_9564());
                }
            });
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.drew", countString);
            RegionHelper.pushBlockRegionChange(chunkedBlockRegion, historyDescription, sourceInfo);
            this.currentJob = null;
            this.reset();
        }
    }

    private static float getSpreadAmount(byte neighborState, int x, int y, int z, float f, Position2FloatMap oldLevelMap) {
        if (neighborState < 0 || neighborState >= 8) {
            return 0.0f;
        }
        if (neighborState >= 1 && (double)(f - (float)neighborState) <= 0.0) {
            return 0.0f;
        }
        float neighborLevel = oldLevelMap.get(x, y, z);
        return Math.max(0.0f, f - neighborLevel);
    }

    private static byte getSpreadCount(Position2ByteMap worldStateMap, Position2ByteMap spreadFromMap, int x, int y, int z, float minDelta, Position2FloatMap oldLevelMap) {
        byte spreadFrom = spreadFromMap.get(x, y, z);
        if (spreadFrom == -1) {
            float minusZ;
            float plusZ;
            float minusX;
            float centerLevel = oldLevelMap.get(x, y, z);
            byte centerState = worldStateMap.getOrCreate(x, y, z);
            if (centerState < 0 || centerState >= 8) {
                spreadFromMap.put(x, y, z, (byte)0);
                return 0;
            }
            spreadFrom = 4;
            float plusX = oldLevelMap.get(x + 1, y, z);
            if ((double)(plusX - minDelta - centerLevel) < 0.05) {
                spreadFrom = (byte)(spreadFrom - 1);
            }
            if ((double)((minusX = oldLevelMap.get(x - 1, y, z)) - minDelta - centerLevel) < 0.05) {
                spreadFrom = (byte)(spreadFrom - 1);
            }
            if ((double)((plusZ = oldLevelMap.get(x, y, z + 1)) - minDelta - centerLevel) < 0.05) {
                spreadFrom = (byte)(spreadFrom - 1);
            }
            if ((double)((minusZ = oldLevelMap.get(x, y, z - 1)) - minDelta - centerLevel) < 0.05) {
                spreadFrom = (byte)(spreadFrom - 1);
            }
            spreadFromMap.put(x, y, z, spreadFrom);
        }
        return spreadFrom;
    }

    @NotNull
    private static Position2ByteMap createWorldStateMap(class_638 level, int fluidType) {
        class_2338.class_2339 mutableBlockPosForWorldState = new class_2338.class_2339();
        Position2ByteMap worldStateMap = new Position2ByteMap(-1, k -> {
            byte[] values = new byte[4096];
            int cx = class_2338.method_10061((long)k) * 16;
            int cy = class_2338.method_10071((long)k) * 16;
            int cz = class_2338.method_10083((long)k) * 16;
            for (int index = 0; index < 4096; ++index) {
                int x = cx + (index & 0xF);
                int y = cy + (index >> 4 & 0xF);
                int z = cz + (index >> 8 & 0xF);
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPosForWorldState.method_10103(x, y, z));
                class_3610 fluidState = blockState.method_26227();
                if (fluidType == 1) {
                    if (fluidState.method_39360((class_3611)class_3612.field_15908) || fluidState.method_39360((class_3611)class_3612.field_15907)) {
                        values[index] = (byte)fluidState.method_15761();
                        continue;
                    }
                } else if (fluidType == 2) {
                    if (blockState.method_26204() == class_2246.field_10491) {
                        values[index] = 8;
                        continue;
                    }
                    if (blockState.method_26204() == class_2246.field_10477) {
                        values[index] = (byte)((Integer)blockState.method_11654((class_2769)class_2741.field_12536)).intValue();
                        continue;
                    }
                } else {
                    if (fluidState.method_39360((class_3611)class_3612.field_15910) || fluidState.method_39360((class_3611)class_3612.field_15909)) {
                        values[index] = (byte)fluidState.method_15761();
                        continue;
                    }
                    if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                        if (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                            values[index] = 8;
                            continue;
                        }
                        values[index] = 0;
                        continue;
                    }
                }
                values[index] = !fluidState.method_15769() ? -1 : (blockState.method_45474() && blockState.method_26204() != class_2246.field_10243 ? 0 : -1);
            }
            return values;
        });
        return worldStateMap;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.fluid_ball"));
        ImGuiHelper.combo("Fluid Type", this.fluidType, new String[]{"Water", "Lava", "Snow"});
        ImGui.sliderInt("Quality", this.quality, 0, 100);
        ImGui.sliderInt("Flow Length", this.flowLength, 2, 16);
        if (ImGui.checkbox("Remove Fluids Without Sources", this.removeFluidsWithoutSource)) {
            this.removeFluidsWithoutSource = !this.removeFluidsWithoutSource;
        }
        ImGuiHelper.tooltip("Removes extraneous fluids at the end of the operation if it isn't connected to a source block");
        if (ImGui.checkbox("Fill Edges", this.fillEdges)) {
            this.fillEdges = !this.fillEdges;
        }
        ImGuiHelper.tooltip("Adds fluid around the edge of blocks to make it look like it's flowing over the edge");
        if (ImGui.checkbox("Infinite Sources", this.infiniteSources)) {
            this.infiniteSources = !this.infiniteSources;
        }
        ImGuiHelper.tooltip("Turns the initial region into infinite sources, making them able to propagate water without being drained");
        if (ImGui.checkbox("Require Support To Flow", this.requireSupportToFlow)) {
            this.requireSupportToFlow = !this.requireSupportToFlow;
        }
        ImGuiHelper.tooltip("Only propagates water sideways if the block below is solid");
        if (this.currentJob != null) {
            if (!ImGui.isPopupOpen("Fluid Simulation")) {
                ImGui.openPopup("Fluid Simulation");
            }
            if (ImGuiHelper.beginPopupModal("Fluid Simulation", 64)) {
                int maxIterations = this.quality[0] * 1000;
                int percentage = this.currentJob.iterations * 100 / maxIterations;
                ImGui.text("Progress: " + percentage + "%");
                long currentTime = System.currentTimeMillis();
                if (currentTime < this.currentJob.startTime) {
                    this.currentJob.startTime = 0L;
                }
                if (this.currentJob.startTime > 0L) {
                    long duration = (currentTime - this.currentJob.startTime) / 1000L;
                    String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                    ImGui.text(durationString);
                }
                if (ImGui.button("Cancel")) {
                    this.currentJob = null;
                    this.reset();
                }
                ImGui.sameLine();
                if (ImGui.button("Finish Early")) {
                    this.runFluidSimulationJob(250L, true);
                    this.reset();
                }
                ImGui.endPopup();
            }
        }
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.fluid_ball");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Fluid Ball Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue920';
    }

    @Override
    public String keybindId() {
        return "fluid_ball";
    }

    private static /* synthetic */ void lambda$runFluidSimulationJob$4(Position2FloatMap newLevelMap, LongSet check, int x, int y, int z, float f) {
        if (Math.round(f) >= 8) {
            newLevelMap.put(x, y, z, 8.0f);
            check.add(class_2338.method_10064((int)x, (int)y, (int)z));
        }
    }

    private static class FluidSimulation {
        private float minDelta;
        private final boolean requireSupportToFlow;
        private long startTime = System.currentTimeMillis();
        private Position2FloatMap levelMap;
        private PositionSet shouldPropagate = null;
        private final PositionSet checkedExistingWater;
        private final PositionSet initialWater;
        private final Position2ByteMap worldStateMap;
        private int iterations = 0;

        public FluidSimulation(Position2FloatMap levelMap, PositionSet checkedExistingWater, Position2ByteMap worldStateMap, float minDelta, boolean infiniteSources, boolean requireSupportToFlow) {
            this.levelMap = levelMap;
            this.checkedExistingWater = checkedExistingWater;
            this.initialWater = infiniteSources ? checkedExistingWater.copy() : new PositionSet();
            this.worldStateMap = worldStateMap;
            this.minDelta = minDelta;
            this.requireSupportToFlow = requireSupportToFlow;
        }

        private boolean isFinished() {
            return this.shouldPropagate != null && this.shouldPropagate.isEmpty();
        }

        private void runUntil(int maxIterations, long maxTime) {
            long start = System.currentTimeMillis();
            while (!this.isFinished() && System.currentTimeMillis() - start < maxTime && this.iterations < maxIterations) {
                int index;
                ++this.iterations;
                Position2FloatMap newLevelMap = new Position2FloatMap();
                Position2ByteMap spreadFromMap = new Position2ByteMap(-1);
                Position2FloatMap oldLevelMap = this.levelMap;
                LongOpenHashSet newlyUsedWater = new LongOpenHashSet();
                PositionSet newShouldPropagate = new PositionSet();
                LongArrayList directCopy = new LongArrayList();
                LongSet propagatedChunks = this.shouldPropagate == null ? null : this.shouldPropagate.chunkKeySet();
                for (Long2ObjectMap.Entry entry : this.levelMap.unsafeGetRawMap().long2ObjectEntrySet()) {
                    if (propagatedChunks != null && !propagatedChunks.contains(entry.getLongKey())) {
                        directCopy.add(entry.getLongKey());
                        continue;
                    }
                    int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
                    int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
                    int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
                    float[] array = (float[])entry.getValue();
                    index = 0;
                    for (int zo = 0; zo < 16; ++zo) {
                        int z = cz + zo;
                        for (int yo = 0; yo < 16; ++yo) {
                            float f;
                            int xo;
                            int y = cy + yo;
                            if (this.shouldPropagate != null && !this.shouldPropagate.containsInXRow(cx, y, z)) {
                                for (xo = 0; xo < 16; ++xo) {
                                    int n = index++;
                                    f = array[n];
                                    if (!((double)f > 0.0)) continue;
                                    newLevelMap.add(cx + xo, y, z, f);
                                }
                                continue;
                            }
                            for (xo = 0; xo < 16; ++xo) {
                                byte aboveState;
                                if ((double)(f = array[index++]) == 0.0) continue;
                                boolean propagatedThis = false;
                                int x = cx + xo;
                                if (this.shouldPropagate != null && !this.shouldPropagate.contains(x, y, z)) {
                                    newLevelMap.add(x, y, z, f);
                                    continue;
                                }
                                byte belowState = this.worldStateMap.getOrCreate(x, y - 1, z);
                                if (belowState >= 0) {
                                    float belowLevel;
                                    if (belowState >= 1 && this.checkedExistingWater.add(x, y - 1, z)) {
                                        newlyUsedWater.add(class_2338.method_10064((int)x, (int)(y - 1), (int)z));
                                        newLevelMap.add(x, y - 1, z, belowState);
                                    }
                                    if ((belowLevel = oldLevelMap.get(x, y - 1, z) + (float)belowState) < 8.0f) {
                                        float transferred = Math.min(f, 8.0f - belowLevel);
                                        newLevelMap.add(x, y - 1, z, transferred);
                                        f -= transferred;
                                        propagatedThis = true;
                                    }
                                }
                                if ((aboveState = this.worldStateMap.getOrCreate(x, y + 1, z)) >= 1 && this.checkedExistingWater.add(x, y + 1, z)) {
                                    newlyUsedWater.add(class_2338.method_10064((int)x, (int)(y + 1), (int)z));
                                    newLevelMap.add(x, y + 1, z, aboveState);
                                }
                                if (Math.round(f) <= 1 || this.requireSupportToFlow && belowState >= 0 && !this.initialWater.contains(x, y - 1, z)) {
                                    newLevelMap.add(x, y, z, this.initialWater.contains(x, y, z) ? 8.0f : f);
                                } else {
                                    float currentLevel = f;
                                    float cappedCurrentLevel = Math.min(f, 8.0f) - this.minDelta;
                                    byte statePX = this.worldStateMap.getOrCreate(x + 1, y, z);
                                    byte stateNX = this.worldStateMap.getOrCreate(x - 1, y, z);
                                    byte statePZ = this.worldStateMap.getOrCreate(x, y, z + 1);
                                    byte stateNZ = this.worldStateMap.getOrCreate(x, y, z - 1);
                                    float spreadPX = FluidBall.getSpreadAmount(statePX, x + 1, y, z, cappedCurrentLevel, oldLevelMap);
                                    float spreadNX = FluidBall.getSpreadAmount(stateNX, x - 1, y, z, cappedCurrentLevel, oldLevelMap);
                                    float spreadPZ = FluidBall.getSpreadAmount(statePZ, x, y, z + 1, cappedCurrentLevel, oldLevelMap);
                                    float spreadNZ = FluidBall.getSpreadAmount(stateNZ, x, y, z - 1, cappedCurrentLevel, oldLevelMap);
                                    int spreadableNeighbors = 0;
                                    if ((double)spreadPX > 0.05) {
                                        ++spreadableNeighbors;
                                    }
                                    if ((double)spreadNX > 0.05) {
                                        ++spreadableNeighbors;
                                    }
                                    if ((double)spreadPZ > 0.05) {
                                        ++spreadableNeighbors;
                                    }
                                    if ((double)spreadNZ > 0.05) {
                                        ++spreadableNeighbors;
                                    }
                                    if (spreadableNeighbors > 0) {
                                        float transferred;
                                        byte spreadableFrom;
                                        if ((double)spreadPX > 0.05) {
                                            if (statePX > 0) {
                                                if (this.checkedExistingWater.add(x + 1, y, z)) {
                                                    newlyUsedWater.add(class_2338.method_10064((int)(x + 1), (int)y, (int)z));
                                                    newLevelMap.add(x + 1, y, z, statePX);
                                                }
                                            } else {
                                                spreadableFrom = FluidBall.getSpreadCount(this.worldStateMap, spreadFromMap, x + 1, y, z, this.minDelta, oldLevelMap);
                                                transferred = spreadPX / (float)(spreadableNeighbors + spreadableFrom);
                                                newLevelMap.add(x + 1, y, z, transferred);
                                                currentLevel -= transferred;
                                            }
                                        }
                                        if ((double)spreadNX > 0.05) {
                                            if (stateNX > 0) {
                                                if (this.checkedExistingWater.add(x - 1, y, z)) {
                                                    newlyUsedWater.add(class_2338.method_10064((int)(x - 1), (int)y, (int)z));
                                                    newLevelMap.add(x - 1, y, z, stateNX);
                                                }
                                            } else {
                                                spreadableFrom = FluidBall.getSpreadCount(this.worldStateMap, spreadFromMap, x - 1, y, z, this.minDelta, oldLevelMap);
                                                transferred = spreadNX / (float)(spreadableNeighbors + spreadableFrom);
                                                newLevelMap.add(x - 1, y, z, transferred);
                                                currentLevel -= transferred;
                                            }
                                        }
                                        if ((double)spreadPZ > 0.05) {
                                            if (statePZ > 0) {
                                                if (this.checkedExistingWater.add(x, y, z + 1)) {
                                                    newlyUsedWater.add(class_2338.method_10064((int)x, (int)y, (int)(z + 1)));
                                                    newLevelMap.add(x, y, z + 1, statePZ);
                                                }
                                            } else {
                                                spreadableFrom = FluidBall.getSpreadCount(this.worldStateMap, spreadFromMap, x, y, z + 1, this.minDelta, oldLevelMap);
                                                transferred = spreadPZ / (float)(spreadableNeighbors + spreadableFrom);
                                                newLevelMap.add(x, y, z + 1, transferred);
                                                currentLevel -= transferred;
                                            }
                                        }
                                        if ((double)spreadNZ > 0.05) {
                                            if (stateNZ > 0) {
                                                if (this.checkedExistingWater.add(x, y, z - 1)) {
                                                    newlyUsedWater.add(class_2338.method_10064((int)x, (int)y, (int)(z - 1)));
                                                    newLevelMap.add(x, y, z - 1, stateNZ);
                                                }
                                            } else {
                                                spreadableFrom = FluidBall.getSpreadCount(this.worldStateMap, spreadFromMap, x, y, z - 1, this.minDelta, oldLevelMap);
                                                transferred = spreadNZ / (float)(spreadableNeighbors + spreadableFrom);
                                                newLevelMap.add(x, y, z - 1, transferred);
                                                currentLevel -= transferred;
                                            }
                                        }
                                        propagatedThis = true;
                                    }
                                    if (currentLevel > 8.0f && aboveState >= 0) {
                                        newLevelMap.add(x, y, z, 8.0f);
                                        newLevelMap.add(x, y + 1, z, currentLevel - 8.0f);
                                        propagatedThis = true;
                                    } else {
                                        newLevelMap.add(x, y, z, this.initialWater.contains(x, y, z) ? 8.0f : Math.max(0.01f, currentLevel));
                                    }
                                }
                                if (!propagatedThis) continue;
                                newShouldPropagate.add(x, y, z);
                                newShouldPropagate.add(x + 1, y, z);
                                newShouldPropagate.add(x - 1, y, z);
                                newShouldPropagate.add(x, y + 1, z);
                                newShouldPropagate.add(x, y - 1, z);
                                newShouldPropagate.add(x, y, z + 1);
                                newShouldPropagate.add(x, y, z - 1);
                            }
                        }
                    }
                }
                newlyUsedWater.forEach(value -> {
                    int x = class_2338.method_10061((long)value);
                    int y = class_2338.method_10071((long)value);
                    int z = class_2338.method_10083((long)value);
                    this.worldStateMap.put(x, y, z, (byte)0);
                });
                LongIterator directCopyIterator = directCopy.longIterator();
                while (directCopyIterator.hasNext()) {
                    long pos = directCopyIterator.nextLong();
                    float[] oldChunk = this.levelMap.getChunk(pos);
                    float[] newChunk = newLevelMap.getChunk(pos);
                    if (newChunk == null) {
                        newLevelMap.unsafeGetRawMap().put(pos, (Object)oldChunk);
                        continue;
                    }
                    int length = oldChunk.length;
                    for (index = 0; index < length; ++index) {
                        int n = index;
                        newChunk[n] = newChunk[n] + oldChunk[index];
                    }
                }
                this.levelMap = newLevelMap;
                this.shouldPropagate = newShouldPropagate;
            }
        }
    }
}

