/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.magic_select;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.IntWrapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;

public class MagicSelectionFast {
    private static CalculatedSection calculateSection(class_1937 world, int cx, int cy, int cz, class_2248 block) {
        class_2818 chunk = world.method_8497(cx, cz);
        int sectionIndex = chunk.method_31603(cy);
        if (sectionIndex < 0 || sectionIndex >= chunk.method_32890()) {
            return new BooleanCalculatedSection(false, cx << 4, cy << 4, cz << 4);
        }
        class_2826 section = chunk.method_38259(sectionIndex);
        if (section.method_38292()) {
            return new BooleanCalculatedSection(block == class_2246.field_10124, cx << 4, cy << 4, cz << 4);
        }
        if (section.method_19523(state -> state.method_26204() == block)) {
            int index = 0;
            int count = 0;
            boolean[] contains = new boolean[4096];
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 blockState = section.method_12254(x, y, z);
                        if (blockState.method_26204() == block) {
                            contains[index] = true;
                            ++count;
                        }
                        ++index;
                    }
                }
            }
            if (count == 0) {
                return new BooleanCalculatedSection(false, cx << 4, cy << 4, cz << 4);
            }
            if (count == 4096) {
                return new BooleanCalculatedSection(true, cx << 4, cy << 4, cz << 4);
            }
            return new ArrayCalculatedSection(contains, cx << 4, cy << 4, cz << 4);
        }
        return new BooleanCalculatedSection(false, cx << 4, cy << 4, cz << 4);
    }

    private static class BooleanCalculatedSection
    implements CalculatedSection {
        boolean contains;
        int chunkOriginX;
        int chunkOriginY;
        int chunkOriginZ;
        boolean alreadyChecked = false;

        public BooleanCalculatedSection(boolean contains, int chunkOriginX, int chunkOriginY, int chunkOriginZ) {
            this.contains = contains;
            this.chunkOriginX = chunkOriginX;
            this.chunkOriginY = chunkOriginY;
            this.chunkOriginZ = chunkOriginZ;
        }

        @Override
        public void check(ChunkedBooleanRegion region, IntWrapper count, int posX, int posY, int posZ, PositionSet alreadyChecked, LongArrayFIFOQueue toCheck, ShortArrayFIFOQueue sharedQueue) {
            if (this.alreadyChecked) {
                return;
            }
            this.alreadyChecked = true;
            if (this.contains) {
                int z;
                int y;
                int x;
                for (x = this.chunkOriginX; x <= this.chunkOriginX + 15; ++x) {
                    for (y = this.chunkOriginY; y <= this.chunkOriginY + 15; ++y) {
                        for (int z2 = this.chunkOriginZ; z2 <= this.chunkOriginZ + 15; ++z2) {
                            region.add(x, y, z2);
                            alreadyChecked.add(x, y, z2);
                        }
                    }
                }
                count.value += 4096;
                for (int y2 = this.chunkOriginY - 1; y2 <= this.chunkOriginY + 16; ++y2) {
                    for (z = this.chunkOriginZ - 1; z <= this.chunkOriginZ + 16; ++z) {
                        if (alreadyChecked.add(this.chunkOriginX - 1, y2, z)) {
                            toCheck.enqueue(class_2338.method_10064((int)(this.chunkOriginX - 1), (int)y2, (int)z));
                        }
                        if (!alreadyChecked.add(this.chunkOriginX + 16, y2, z)) continue;
                        toCheck.enqueue(class_2338.method_10064((int)(this.chunkOriginX + 16), (int)y2, (int)z));
                    }
                }
                for (x = this.chunkOriginX; x <= this.chunkOriginX + 15; ++x) {
                    for (z = this.chunkOriginZ - 1; z <= this.chunkOriginZ + 16; ++z) {
                        if (alreadyChecked.add(x, this.chunkOriginY - 1, z)) {
                            toCheck.enqueue(class_2338.method_10064((int)x, (int)(this.chunkOriginY - 1), (int)z));
                        }
                        if (!alreadyChecked.add(x, this.chunkOriginY + 16, z)) continue;
                        toCheck.enqueue(class_2338.method_10064((int)x, (int)(this.chunkOriginY + 16), (int)z));
                    }
                }
                for (x = this.chunkOriginX; x <= this.chunkOriginX + 15; ++x) {
                    for (y = this.chunkOriginY; y <= this.chunkOriginY + 15; ++y) {
                        if (alreadyChecked.add(x, y, this.chunkOriginZ - 1)) {
                            toCheck.enqueue(class_2338.method_10064((int)x, (int)y, (int)(this.chunkOriginZ - 1)));
                        }
                        if (!alreadyChecked.add(x, y, this.chunkOriginZ - 1)) continue;
                        toCheck.enqueue(class_2338.method_10064((int)x, (int)y, (int)(this.chunkOriginZ - 1)));
                    }
                }
            }
        }
    }

    private record ArrayCalculatedSection(boolean[] contains, int chunkOriginX, int chunkOriginY, int chunkOriginZ) implements CalculatedSection
    {
        @Override
        public void check(ChunkedBooleanRegion region, IntWrapper count, int x, int y, int z, PositionSet alreadyChecked, LongArrayFIFOQueue toCheck, ShortArrayFIFOQueue sharedQueue) {
            int localZ = z & 0xF;
            int localY = y & 0xF;
            int localX = x & 0xF;
            short index = (short)(localZ * 16 * 16 + localY * 16 + localX);
            if (!this.contains[index]) {
                return;
            }
            this.contains[index] = false;
            sharedQueue.enqueue(index);
            while (!sharedQueue.isEmpty()) {
                short packed = sharedQueue.dequeueShort();
                int locZ = packed >> 8 & 0xF;
                int locY = packed >> 4 & 0xF;
                int locX = packed & 0xF;
                region.add(this.chunkOriginX + locX, this.chunkOriginY + locY, this.chunkOriginZ + locZ);
                ++count.value;
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int yo = -1; yo <= 1; ++yo) {
                        for (int zo = -1; zo <= 1; ++zo) {
                            int newLocX = locX + xo;
                            int newLocY = locY + yo;
                            int newLocZ = locZ + zo;
                            if (((newLocX | newLocY | newLocZ) & 0x10) != 0) {
                                if (!alreadyChecked.add(this.chunkOriginX + newLocX, this.chunkOriginY + newLocY, this.chunkOriginZ + newLocZ)) continue;
                                toCheck.enqueue(class_2338.method_10064((int)(this.chunkOriginX + newLocX), (int)(this.chunkOriginY + newLocY), (int)(this.chunkOriginZ + newLocZ)));
                                continue;
                            }
                            short packedO = (short)(newLocZ * 16 * 16 + newLocY * 16 + newLocX);
                            if (!this.contains[packedO]) continue;
                            this.contains[packedO] = false;
                            sharedQueue.enqueue(packedO);
                        }
                    }
                }
            }
        }
    }

    public static class MagicSelectionTask {
        public Long2ObjectMap<CalculatedSection> calculatedSections;
        public PositionSet alreadyChecked = new PositionSet();
        public LongArrayFIFOQueue toCheck = new LongArrayFIFOQueue();
        public class_1937 world;
        public ChunkedBooleanRegion region;
        public class_2248 originalBlock;

        public MagicSelectionTask(ChunkedBooleanRegion region, class_1937 world, class_2338 position) {
            this.calculatedSections = new Long2ObjectOpenHashMap();
            this.originalBlock = world.method_8320(position).method_26204();
            this.region = region;
            this.world = world;
            this.toCheck.enqueue(class_2338.method_10064((int)position.method_10263(), (int)position.method_10264(), (int)position.method_10260()));
            this.alreadyChecked.add(position.method_10263(), position.method_10264(), position.method_10260());
        }

        public void fill(int until) {
            IntWrapper count = new IntWrapper();
            ShortArrayFIFOQueue sharedQueue = new ShortArrayFIFOQueue(64);
            while (!this.toCheck.isEmpty() && count.value < until) {
                long pos = this.toCheck.dequeueLong();
                int x = class_2338.method_10061((long)pos);
                int y = class_2338.method_10071((long)pos);
                int z = class_2338.method_10083((long)pos);
                int cx = x >> 4;
                int cy = y >> 4;
                int cz = z >> 4;
                CalculatedSection section = (CalculatedSection)this.calculatedSections.computeIfAbsent(class_2338.method_10064((int)cx, (int)cy, (int)cz), k -> MagicSelectionFast.calculateSection(this.world, cx, cy, cz, this.originalBlock));
                section.check(this.region, count, x, y, z, this.alreadyChecked, this.toCheck, sharedQueue);
            }
        }
    }

    private static interface CalculatedSection {
        public void check(ChunkedBooleanRegion var1, IntWrapper var2, int var3, int var4, int var5, PositionSet var6, LongArrayFIFOQueue var7, ShortArrayFIFOQueue var8);
    }
}

