/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modelling;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.tools.path.CatmullRomSpline;
import com.moulberry.axiom.utils.BezierOperator;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import java.util.List;
import net.minecraft.class_2338;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class GridSurface {
    private static int calculateMinSubdivisionCount(List<List<class_2338>> grid) {
        int count = grid.size();
        for (List<class_2338> line : grid) {
            count = Math.max(line.size(), count);
        }
        if (count <= 4) {
            return count;
        }
        double log2 = Math.log(count) / Math.log(2.0);
        return Math.max(4, (int)Math.ceil(log2));
    }

    public static void calculateBezier(List<List<class_2338>> grid, TriIntConsumer consumer) {
        BezierOperator[] factorsU = new BezierOperator[grid.size()];
        BezierOperator[][] factorsV = new BezierOperator[grid.size()][];
        for (int i = 0; i < grid.size(); ++i) {
            factorsU[i] = new BezierOperator(i, grid.size());
            int gizmoLineCount = grid.get(i).size();
            factorsV[i] = new BezierOperator[gizmoLineCount];
            for (int i1 = 0; i1 < gizmoLineCount; ++i1) {
                factorsV[i][i1] = new BezierOperator(i1, gizmoLineCount);
            }
        }
        Vector3d pos00 = new Vector3d();
        Vector3d pos01 = new Vector3d();
        Vector3d pos10 = new Vector3d();
        Vector3d pos11 = new Vector3d();
        for (int i = 0; i < grid.size(); ++i) {
            List<class_2338> gizmoLine = grid.get(i);
            double factorU0 = factorsU[i].applyAsDouble(0.0);
            double factorU1 = factorsU[i].applyAsDouble(1.0);
            for (int j = 0; j < gizmoLine.size(); ++j) {
                double factorV0 = factorsV[i][j].applyAsDouble(0.0);
                double factorV1 = factorsV[i][j].applyAsDouble(1.0);
                class_2338 pos = gizmoLine.get(j);
                pos00.add((double)pos.method_10263() * factorU0 * factorV0, (double)pos.method_10264() * factorU0 * factorV0, (double)pos.method_10260() * factorU0 * factorV0);
                pos01.add((double)pos.method_10263() * factorU0 * factorV1, (double)pos.method_10264() * factorU0 * factorV1, (double)pos.method_10260() * factorU0 * factorV1);
                pos10.add((double)pos.method_10263() * factorU1 * factorV0, (double)pos.method_10264() * factorU1 * factorV0, (double)pos.method_10260() * factorU1 * factorV0);
                pos11.add((double)pos.method_10263() * factorU1 * factorV1, (double)pos.method_10264() * factorU1 * factorV1, (double)pos.method_10260() * factorU1 * factorV1);
            }
        }
        int remainingSubdivisions = GridSurface.calculateMinSubdivisionCount(grid);
        GridSurface.surfaceBezier(pos00, pos01, pos10, pos11, 0.0, 1.0, 0.0, 1.0, factorsU, factorsV, grid, consumer, new Vector3f(), new Vector3f(), remainingSubdivisions);
    }

    private static void surfaceBezier(Vector3d pos00, Vector3d pos01, Vector3d pos10, Vector3d pos11, double u0, double u1, double v0, double v1, BezierOperator[] factorsU, BezierOperator[][] factorsV, List<List<class_2338>> grid, TriIntConsumer consumer, Vector3f from, Vector3f to, int remainingSubdivisions) {
        if (remainingSubdivisions <= 0) {
            double maximumDistance = 0.0;
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos01));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos11));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos01));
            if ((maximumDistance = Math.max(maximumDistance, pos10.distanceSquared((Vector3dc)pos01))) <= 4.0) {
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                return;
            }
        } else {
            --remainingSubdivisions;
        }
        double midU = (u0 + u1) / 2.0;
        double midV = (v0 + v1) / 2.0;
        Vector3d zeroUMidV = new Vector3d();
        Vector3d midUZeroV = new Vector3d();
        Vector3d oneUMidV = new Vector3d();
        Vector3d midUoneV = new Vector3d();
        Vector3d midUmidV = new Vector3d();
        for (int i = 0; i < grid.size(); ++i) {
            List<class_2338> gizmoLine = grid.get(i);
            double factorU0 = factorsU[i].applyAsDouble(u0);
            double factorMidU = factorsU[i].applyAsDouble(midU);
            double factorU1 = factorsU[i].applyAsDouble(u1);
            for (int j = 0; j < gizmoLine.size(); ++j) {
                double factorV0 = factorsV[i][j].applyAsDouble(v0);
                double factorMidV = factorsV[i][j].applyAsDouble(midV);
                double factorV1 = factorsV[i][j].applyAsDouble(v1);
                class_2338 pos = gizmoLine.get(j);
                zeroUMidV.add((double)pos.method_10263() * factorU0 * factorMidV, (double)pos.method_10264() * factorU0 * factorMidV, (double)pos.method_10260() * factorU0 * factorMidV);
                midUZeroV.add((double)pos.method_10263() * factorMidU * factorV0, (double)pos.method_10264() * factorMidU * factorV0, (double)pos.method_10260() * factorMidU * factorV0);
                oneUMidV.add((double)pos.method_10263() * factorU1 * factorMidV, (double)pos.method_10264() * factorU1 * factorMidV, (double)pos.method_10260() * factorU1 * factorMidV);
                midUoneV.add((double)pos.method_10263() * factorMidU * factorV1, (double)pos.method_10264() * factorMidU * factorV1, (double)pos.method_10260() * factorMidU * factorV1);
                midUmidV.add((double)pos.method_10263() * factorMidU * factorMidV, (double)pos.method_10264() * factorMidU * factorMidV, (double)pos.method_10260() * factorMidU * factorMidV);
            }
        }
        GridSurface.surfaceBezier(pos00, zeroUMidV, midUZeroV, midUmidV, u0, midU, v0, midV, factorsU, factorsV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceBezier(midUZeroV, midUmidV, pos10, oneUMidV, midU, u1, v0, midV, factorsU, factorsV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceBezier(zeroUMidV, pos01, midUmidV, midUoneV, u0, midU, midV, v1, factorsU, factorsV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceBezier(midUmidV, midUoneV, oneUMidV, pos11, midU, u1, midV, v1, factorsU, factorsV, grid, consumer, from, to, remainingSubdivisions);
    }

    public static void calculateCatmullRom(List<List<class_2338>> grid, TriIntConsumer consumer) {
        Vector3d pos00 = GridSurface.catmullRom2D(0.0, 0.0, grid);
        Vector3d pos01 = GridSurface.catmullRom2D(0.0, 1.0, grid);
        Vector3d pos10 = GridSurface.catmullRom2D(1.0, 0.0, grid);
        Vector3d pos11 = GridSurface.catmullRom2D(1.0, 1.0, grid);
        int remainingSubdivisions = GridSurface.calculateMinSubdivisionCount(grid);
        GridSurface.surfaceCatmullRom(pos00, pos01, pos10, pos11, 0.0, 1.0, 0.0, 1.0, grid, consumer, new Vector3f(), new Vector3f(), remainingSubdivisions);
    }

    private static Vector3d catmullRom2D(double u, double v, List<List<class_2338>> grid) {
        double partialV = v * (double)(grid.size() - 1);
        int floorPartialV = (int)partialV;
        double remainderPartialV = partialV - (double)floorPartialV;
        int indexV0 = Math.max(0, floorPartialV - 1);
        int indexV1 = floorPartialV;
        int indexV2 = Math.min(grid.size() - 1, floorPartialV + 1);
        int indexV3 = Math.min(grid.size() - 1, floorPartialV + 2);
        if (indexV1 == indexV2) {
            return GridSurface.catmullRom1D(u, grid.get(indexV1));
        }
        Vector3d position1 = GridSurface.catmullRom1D(u, grid.get(indexV1));
        Vector3d position2 = GridSurface.catmullRom1D(u, grid.get(indexV2));
        Vector3d position0 = indexV0 == indexV1 ? position1 : GridSurface.catmullRom1D(u, grid.get(indexV0));
        Vector3d position3 = indexV3 == indexV2 ? position2 : GridSurface.catmullRom1D(u, grid.get(indexV3));
        return CatmullRomSpline.position(position0, position1, position2, position3, (float)remainderPartialV);
    }

    private static Vector3d catmullRom1D(double u, List<class_2338> line) {
        double partialU = u * (double)(line.size() - 1);
        int floorPartialU = (int)partialU;
        double remainderPartialU = partialU - (double)floorPartialU;
        int indexU0 = Math.max(0, floorPartialU - 1);
        int indexU1 = floorPartialU;
        int indexU2 = Math.min(line.size() - 1, floorPartialU + 1);
        int indexU3 = Math.min(line.size() - 1, floorPartialU + 2);
        class_2338 blockPos1 = line.get(indexU1);
        Vector3d position1 = new Vector3d((double)blockPos1.method_10263(), (double)blockPos1.method_10264(), (double)blockPos1.method_10260());
        if (indexU1 == indexU2) {
            return position1;
        }
        class_2338 blockPos0 = line.get(indexU0);
        Vector3d position0 = new Vector3d((double)blockPos0.method_10263(), (double)blockPos0.method_10264(), (double)blockPos0.method_10260());
        class_2338 blockPos2 = line.get(indexU2);
        Vector3d position2 = new Vector3d((double)blockPos2.method_10263(), (double)blockPos2.method_10264(), (double)blockPos2.method_10260());
        class_2338 blockPos3 = line.get(indexU3);
        Vector3d position3 = new Vector3d((double)blockPos3.method_10263(), (double)blockPos3.method_10264(), (double)blockPos3.method_10260());
        return CatmullRomSpline.position(position0, position1, position2, position3, (float)remainderPartialU);
    }

    private static void surfaceCatmullRom(Vector3d pos00, Vector3d pos01, Vector3d pos10, Vector3d pos11, double u0, double u1, double v0, double v1, List<List<class_2338>> grid, TriIntConsumer consumer, Vector3f from, Vector3f to, int remainingSubdivisions) {
        if (remainingSubdivisions <= 0) {
            double maximumDistance = 0.0;
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos01));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos11));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos01));
            if ((maximumDistance = Math.max(maximumDistance, pos10.distanceSquared((Vector3dc)pos01))) <= 4.0) {
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                return;
            }
        } else {
            --remainingSubdivisions;
        }
        double midU = (u0 + u1) / 2.0;
        double midV = (v0 + v1) / 2.0;
        Vector3d zeroUMidV = GridSurface.catmullRom2D(u0, midV, grid);
        Vector3d midUZeroV = GridSurface.catmullRom2D(midU, v0, grid);
        Vector3d oneUMidV = GridSurface.catmullRom2D(u1, midV, grid);
        Vector3d midUoneV = GridSurface.catmullRom2D(midU, v1, grid);
        Vector3d midUmidV = GridSurface.catmullRom2D(midU, midV, grid);
        GridSurface.surfaceCatmullRom(pos00, zeroUMidV, midUZeroV, midUmidV, u0, midU, v0, midV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceCatmullRom(midUZeroV, midUmidV, pos10, oneUMidV, midU, u1, v0, midV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceCatmullRom(zeroUMidV, pos01, midUmidV, midUoneV, u0, midU, midV, v1, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceCatmullRom(midUmidV, midUoneV, oneUMidV, pos11, midU, u1, midV, v1, grid, consumer, from, to, remainingSubdivisions);
    }

    public static void calculateFlat(List<List<class_2338>> grid, TriIntConsumer consumer) {
        Vector3d pos00 = GridSurface.flat2D(0.0, 0.0, grid);
        Vector3d pos01 = GridSurface.flat2D(0.0, 1.0, grid);
        Vector3d pos10 = GridSurface.flat2D(1.0, 0.0, grid);
        Vector3d pos11 = GridSurface.flat2D(1.0, 1.0, grid);
        int remainingSubdivisions = GridSurface.calculateMinSubdivisionCount(grid);
        GridSurface.surfaceFlat(pos00, pos01, pos10, pos11, 0.0, 1.0, 0.0, 1.0, grid, consumer, new Vector3f(), new Vector3f(), remainingSubdivisions);
    }

    private static Vector3d flat2D(double u, double v, List<List<class_2338>> grid) {
        double partialV = v * (double)(grid.size() - 1);
        int floorPartialV = (int)partialV;
        double remainderPartialV = partialV - (double)floorPartialV;
        int indexV1 = floorPartialV;
        int indexV2 = Math.min(grid.size() - 1, floorPartialV + 1);
        if (indexV1 == indexV2) {
            return GridSurface.flat1D(u, grid.get(indexV1));
        }
        Vector3d position1 = GridSurface.flat1D(u, grid.get(indexV1));
        Vector3d position2 = GridSurface.flat1D(u, grid.get(indexV2));
        return position1.lerp((Vector3dc)position2, (double)((float)remainderPartialV));
    }

    private static Vector3d flat1D(double u, List<class_2338> line) {
        double partialU = u * (double)(line.size() - 1);
        int floorPartialU = (int)partialU;
        double remainderPartialU = partialU - (double)floorPartialU;
        int indexU1 = floorPartialU;
        int indexU2 = Math.min(line.size() - 1, floorPartialU + 1);
        class_2338 blockPos1 = line.get(indexU1);
        Vector3d position1 = new Vector3d((double)blockPos1.method_10263(), (double)blockPos1.method_10264(), (double)blockPos1.method_10260());
        if (indexU1 == indexU2) {
            return position1;
        }
        class_2338 blockPos2 = line.get(indexU2);
        Vector3d position2 = new Vector3d((double)blockPos2.method_10263(), (double)blockPos2.method_10264(), (double)blockPos2.method_10260());
        return position1.lerp((Vector3dc)position2, (double)((float)remainderPartialU));
    }

    private static void surfaceFlat(Vector3d pos00, Vector3d pos01, Vector3d pos10, Vector3d pos11, double u0, double u1, double v0, double v1, List<List<class_2338>> grid, TriIntConsumer consumer, Vector3f from, Vector3f to, int remainingSubdivisions) {
        if (remainingSubdivisions <= 0) {
            double maximumDistance = 0.0;
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos01));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos00.distanceSquared((Vector3dc)pos11));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos10));
            maximumDistance = Math.max(maximumDistance, pos11.distanceSquared((Vector3dc)pos01));
            if ((maximumDistance = Math.max(maximumDistance, pos10.distanceSquared((Vector3dc)pos01))) <= 4.0) {
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos00).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos11).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                Rasterization3D.dda(from.set((Vector3dc)pos10).add(0.5f, 0.5f, 0.5f), to.set((Vector3dc)pos01).add(0.5f, 0.5f, 0.5f), consumer);
                return;
            }
        } else {
            --remainingSubdivisions;
        }
        double midU = (u0 + u1) / 2.0;
        double midV = (v0 + v1) / 2.0;
        Vector3d zeroUMidV = GridSurface.flat2D(u0, midV, grid);
        Vector3d midUZeroV = GridSurface.flat2D(midU, v0, grid);
        Vector3d oneUMidV = GridSurface.flat2D(u1, midV, grid);
        Vector3d midUoneV = GridSurface.flat2D(midU, v1, grid);
        Vector3d midUmidV = GridSurface.flat2D(midU, midV, grid);
        GridSurface.surfaceFlat(pos00, zeroUMidV, midUZeroV, midUmidV, u0, midU, v0, midV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceFlat(midUZeroV, midUmidV, pos10, oneUMidV, midU, u1, v0, midV, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceFlat(zeroUMidV, pos01, midUmidV, midUoneV, u0, midU, midV, v1, grid, consumer, from, to, remainingSubdivisions);
        GridSurface.surfaceFlat(midUmidV, midUoneV, oneUMidV, pos11, midU, u1, midV, v1, grid, consumer, from, to, remainingSubdivisions);
    }
}

