/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.roughen;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class RoughenTool
implements Tool {
    private final ChunkedBooleanRegion surfaceBlockHighlight = new ChunkedBooleanRegion();
    private AsyncToolPathProvider pathProvider = null;
    private boolean usingTool = false;
    private final BrushWidget brushWidget = new BrushWidget();
    private final int[] minFaces = new int[]{1};
    private final float[] ratio = new float[]{0.2f};
    private boolean addBlocks = true;
    private boolean removeBlocks = true;
    private final LongList surfaceBlocks = new LongArrayList();
    private final PresetWidget presetWidget = new PresetWidget(this, "roughen");
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    @Override
    public void reset() {
        this.usingTool = false;
        this.surfaceBlocks.clear();
        this.surfaceBlockHighlight.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                if (!this.addBlocks && !this.removeBlocks) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.usingTool = true;
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                MaskElement maskElement = MaskManager.getSourceMask();
                MaskContext maskContext = new MaskContext((class_1937)level);
                this.pathProvider = new AsyncToolPathProvider(new AsyncToolPatherUnique(this.brushWidget.getBrushShape(), (x, y, z) -> {
                    if (this.isOnSurface(x, y, z, mutableBlockPos, level) && maskElement.test(maskContext.reset(), x, y, z)) {
                        this.surfaceBlocks.add(class_2338.method_10064((int)x, (int)y, (int)z));
                        this.surfaceBlockHighlight.add(x, y, z);
                    }
                }));
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrix, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrix, projection, 7);
                return;
            }
            Selection.render(camera, time, matrix, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrix, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            boolean finished;
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                this.reset();
                return;
            }
            this.pathProvider.finish();
            Selection.render(camera, time, matrix, projection, 4);
            LongArrayList airBlocks = new LongArrayList();
            PositionSet airBlockSet = new PositionSet();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            int surfaceBlocksSize = this.surfaceBlocks.size();
            for (int i = 0; i < surfaceBlocksSize; ++i) {
                long position = this.surfaceBlocks.getLong(i);
                int x = class_2338.method_10061((long)position);
                int y = class_2338.method_10071((long)position);
                int z = class_2338.method_10083((long)position);
                for (class_2350 direction : class_2350.values()) {
                    mutableBlockPos.method_10103(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                    if (blockState.method_51366() || !airBlockSet.add(mutableBlockPos.method_10263(), mutableBlockPos.method_10264(), mutableBlockPos.method_10260())) continue;
                    airBlocks.add(mutableBlockPos.method_10063());
                }
            }
            int totalSolidBlocks = this.surfaceBlocks.size();
            int totalAirBlocks = airBlocks.size();
            float solidRatio = 1.0f - this.ratio[0] * (this.addBlocks ? 0.5f : 1.0f);
            float airRatio = 1.0f - this.ratio[0] * (this.removeBlocks ? 0.5f : 1.0f);
            int solidBlocksDesiredCount = (int)((float)totalSolidBlocks * solidRatio);
            int airBlocksDesiredCount = (int)((float)totalAirBlocks * airRatio);
            ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
            int minFaces = Math.max(0, this.minFaces[0] - 1);
            ThreadLocalRandom random2 = ThreadLocalRandom.current();
            do {
                int z;
                int y;
                int x;
                long position;
                int index;
                int size;
                finished = true;
                if (this.removeBlocks && solidBlocksDesiredCount < this.surfaceBlocks.size()) {
                    finished = false;
                    size = this.surfaceBlocks.size();
                    index = ((Random)random2).nextInt(size);
                    if (index < size - 1) {
                        long tail = this.surfaceBlocks.removeLong(size - 1);
                        position = this.surfaceBlocks.set(index, tail);
                    } else {
                        position = this.surfaceBlocks.removeLong(size - 1);
                    }
                    x = class_2338.method_10061((long)position);
                    y = class_2338.method_10071((long)position);
                    z = class_2338.method_10083((long)position);
                    int airNeighborCount = this.airNeighborCount(x, y, z, blockRegion, mutableBlockPos, level);
                    if (airNeighborCount <= minFaces) {
                        solidBlocksDesiredCount = (int)((float)(--totalSolidBlocks) * solidRatio);
                    } else if (airNeighborCount * airNeighborCount <= ((Random)random2).nextInt(36)) {
                        this.surfaceBlocks.add(position);
                    } else {
                        blockRegion.addBlock(x, y, z, AIR);
                    }
                }
                if (!this.addBlocks || airBlocksDesiredCount >= airBlocks.size()) continue;
                finished = false;
                size = airBlocks.size();
                index = ((Random)random2).nextInt(size);
                if (index < size - 1) {
                    long tail = airBlocks.removeLong(size - 1);
                    position = airBlocks.set(index, tail);
                } else {
                    position = airBlocks.removeLong(size - 1);
                }
                x = class_2338.method_10061((long)position);
                y = class_2338.method_10071((long)position);
                z = class_2338.method_10083((long)position);
                int solidNeighborCount = this.solidNeighborCount(x, y, z, blockRegion, mutableBlockPos, level);
                if (solidNeighborCount <= minFaces) {
                    airBlocksDesiredCount = (int)((float)(--totalAirBlocks) * airRatio);
                    continue;
                }
                if (solidNeighborCount * solidNeighborCount <= ((Random)random2).nextInt(36)) {
                    airBlocks.add(position);
                    continue;
                }
                ArrayList<class_2680> possibleBlocks = new ArrayList<class_2680>();
                for (class_2350 direction : class_2350.values()) {
                    mutableBlockPos.method_10103(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
                    class_2680 blockState = blockRegion.getBlockStateOrDelegate((class_2338)mutableBlockPos, (class_1937)level);
                    if (!blockState.method_51366()) continue;
                    possibleBlocks.add(blockState);
                }
                class_2680 blockState = (class_2680)possibleBlocks.get(((Random)random2).nextInt(possibleBlocks.size()));
                blockRegion.addBlock(x, y, z, blockState);
            } while (!finished);
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(blockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.roughen_tool", countString);
            RegionHelper.pushBlockRegionChange(blockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            this.pathProvider.update();
            this.surfaceBlockHighlight.render(camera, class_243.field_1353, matrix, projection, time, 3);
        }
    }

    private boolean isOnSurface(int x, int y, int z, class_2338.class_2339 mutableBlockPos, class_638 level) {
        mutableBlockPos.method_10103(x, y, z);
        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
        if (!blockState.method_51366()) {
            return false;
        }
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10103(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
            blockState = level.method_8320((class_2338)mutableBlockPos);
            if (blockState.method_51366()) continue;
            return true;
        }
        return false;
    }

    private int airNeighborCount(int x, int y, int z, ChunkedBlockRegion blockRegion, class_2338.class_2339 mutableBlockPos, class_638 level) {
        int adjacent = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10103(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
            class_2680 blockState = blockRegion.getBlockStateOrDelegate((class_2338)mutableBlockPos, (class_1937)level);
            if (blockState.method_51366()) continue;
            ++adjacent;
        }
        return adjacent;
    }

    private int solidNeighborCount(int x, int y, int z, ChunkedBlockRegion blockRegion, class_2338.class_2339 mutableBlockPos, class_638 level) {
        int adjacent = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10103(x + direction.method_10148(), y + direction.method_10164(), z + direction.method_10165());
            class_2680 blockState = blockRegion.getBlockStateOrDelegate((class_2338)mutableBlockPos, (class_1937)level);
            if (!blockState.method_51366()) continue;
            ++adjacent;
        }
        return adjacent;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.roughen"));
        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.roughen.ratio"), this.ratio, 0.0f, 1.0f);
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.roughen.min_faces"), this.minFaces, 1, 4);
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.roughen.mode_add"), this.addBlocks)) {
            this.addBlocks = !this.addBlocks;
            changed = true;
        }
        ImGui.sameLine();
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.roughen.mode_remove"), this.removeBlocks)) {
            this.removeBlocks = !this.removeBlocks;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.roughen");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Roughen Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10569("MinFaces", this.minFaces[0]);
        tag.method_10548("Ratio", this.ratio[0]);
        tag.method_10556("AddBlocks", this.addBlocks);
        tag.method_10556("RemoveBlocks", this.removeBlocks);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.minFaces[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "MinFaces", 1);
        this.ratio[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "Ratio", 0.2f);
        this.addBlocks = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "AddBlocks", true);
        this.removeBlocks = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "RemoveBlocks", true);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue916';
    }

    @Override
    public String keybindId() {
        return "roughen";
    }
}

