/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.script_brush;

import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.mask.LuaHelper;
import imgui.ImGui;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ScriptArgument {
    public String name;
    public Type type;
    public Object value;
    private float floatMin = 0.0f;
    private float floatMax = 1.0f;
    private int intMin = 0;
    private int intMax = 64;

    public ScriptArgument(String name, Type type2, Object value) {
        this.name = name;
        this.type = type2;
        this.value = value;
    }

    public static ScriptArgument parse(String id, String args) {
        switch (id.toLowerCase(Locale.ROOT)) {
            case "blockstate": {
                String name = "Block";
                class_2680 defaultBlock = class_2246.field_10340.method_9564();
                if (args != null) {
                    Optional holder;
                    class_2960 location;
                    String[] split = args.split(",");
                    if (split.length >= 1) {
                        name = split[0].trim();
                    }
                    if (split.length >= 2 && (location = class_2960.method_12829((String)split[1].trim())) != null && (holder = class_7923.field_41175.method_40264(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)location))).isPresent()) {
                        defaultBlock = ((class_2248)((class_6880.class_6883)holder.get()).comp_349()).method_9564();
                    }
                }
                return new ScriptArgument(name, Type.BLOCK_STATE, defaultBlock);
            }
            case "boolean": {
                String name = "Boolean";
                boolean defaultValue = false;
                if (args != null) {
                    String[] split = args.split(",");
                    if (split.length >= 1) {
                        name = split[0].trim();
                    }
                    if (split.length >= 2) {
                        defaultValue = split[1].trim().equalsIgnoreCase("true");
                    }
                }
                return new ScriptArgument(name, Type.BOOLEAN, defaultValue);
            }
            case "float": {
                String name = "Float";
                float defaultValue = 0.5f;
                float floatMin = 0.0f;
                float floatMax = 1.0f;
                if (args != null) {
                    String[] split = args.split(",");
                    if (split.length >= 1) {
                        name = split[0].trim();
                    }
                    if (split.length >= 2) {
                        try {
                            defaultValue = Float.parseFloat(split[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        floatMin = Math.min(floatMin, defaultValue);
                        floatMax = Math.max(floatMax, defaultValue);
                    }
                    if (split.length >= 3) {
                        try {
                            floatMin = Float.parseFloat(split[2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (split.length >= 4) {
                        try {
                            floatMax = Float.parseFloat(split[3].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ScriptArgument scriptArgument = new ScriptArgument(name, Type.FLOAT, Float.valueOf(defaultValue));
                scriptArgument.floatMin = floatMin;
                scriptArgument.floatMax = floatMax;
                return scriptArgument;
            }
            case "int": {
                String name = "Integer";
                int defaultValue = 0;
                int intMin = 0;
                int intMax = 64;
                if (args != null) {
                    String[] split = args.split(",");
                    if (split.length >= 1) {
                        name = split[0].trim();
                    }
                    if (split.length >= 2) {
                        try {
                            defaultValue = Integer.parseInt(split[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        intMin = Math.min(intMin, defaultValue);
                        intMax = Math.max(intMax, defaultValue);
                    }
                    if (split.length >= 3) {
                        try {
                            intMin = Integer.parseInt(split[2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (split.length >= 4) {
                        try {
                            intMax = Integer.parseInt(split[3].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ScriptArgument scriptArgument = new ScriptArgument(name, Type.INT, defaultValue);
                scriptArgument.intMin = intMin;
                scriptArgument.intMax = intMax;
                return scriptArgument;
            }
        }
        return null;
    }

    public void displayImgui(SelectBlockWidget selectBlockWidget, int id) {
        switch (this.type.ordinal()) {
            case 0: {
                CustomBlockState blockState = (CustomBlockState)this.value;
                this.value = ImGuiHelper.blockStateWidget(selectBlockWidget, blockState, this.name, id);
                break;
            }
            case 1: {
                boolean boolValue = (Boolean)this.value;
                ImGui.pushID(id);
                if (ImGui.checkbox(this.name, boolValue)) {
                    this.value = !boolValue;
                }
                ImGui.popID();
                break;
            }
            case 2: {
                float[] floatValue = new float[]{((Float)this.value).floatValue()};
                ImGui.pushID(id);
                if (ImGui.sliderFloat(this.name, floatValue, this.floatMin, this.floatMax)) {
                    this.value = Float.valueOf(floatValue[0]);
                }
                ImGui.popID();
                break;
            }
            case 3: {
                int[] intValue = new int[]{(Integer)this.value};
                ImGui.pushID(id);
                if (ImGui.sliderInt(this.name, intValue, this.intMin, this.intMax)) {
                    this.value = intValue[0];
                }
                ImGui.popID();
            }
        }
    }

    public String toLuaString() {
        switch (this.type.ordinal()) {
            case 0: {
                return String.valueOf(LuaHelper.stateToInternalId(((CustomBlockState)this.value).getVanillaState()));
            }
            case 1: 
            case 2: 
            case 3: {
                return String.valueOf(this.value);
            }
        }
        return "";
    }

    public static enum Type {
        BLOCK_STATE,
        BOOLEAN,
        FLOAT,
        INT;

    }
}

