/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.smooth;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ClosestBlockMap {
    private static final int STRIDE_X = 2304;
    private static final int STRIDE_Y = 48;
    private static final int STRIDE_Z = 1;
    private final Predicate<class_2680> blockFilter;
    private final class_2680[] emptyArray;
    private final Long2ObjectMap<class_2680[]> map = new Long2ObjectOpenHashMap();
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private class_2680[] lastChunk = null;
    private final PropagateData[] propagateDataArray = new PropagateData[110592];

    public ClosestBlockMap(Predicate<class_2680> blockFilter, class_2680 emptyState) {
        this.blockFilter = blockFilter;
        if (!blockFilter.test(emptyState)) {
            throw new FaultyImplementationError();
        }
        this.emptyArray = new class_2680[4096];
        Arrays.fill(this.emptyArray, emptyState);
    }

    public class_2680 get(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        class_2680[] array = this.getOrCreateChunk(xC, yC, zC);
        return array[(x & 0xF) + (y & 0xF) * 16 + (z & 0xF) * 16 * 16];
    }

    private class_2680[] getOrCreateChunk(int xC, int yC, int zC) {
        return this.getOrCreateChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    private class_2680[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            class_2680[] chunk = (class_2680[])this.map.computeIfAbsent(pos, this::calculateBlocks);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    private class_2680[] calculateBlocks(long pos) {
        int index;
        int cx = class_2338.method_10061((long)pos);
        int cy = class_2338.method_10071((long)pos);
        int cz = class_2338.method_10083((long)pos);
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return this.emptyArray;
        }
        Arrays.fill(this.propagateDataArray, null);
        IntArrayFIFOQueue propagateQueue = new IntArrayFIFOQueue();
        class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
        if (chunk == null) {
            return this.emptyArray;
        }
        int sectionIndex = chunk.method_31603(cy);
        if (sectionIndex < 0 || sectionIndex >= chunk.method_32890()) {
            return this.emptyArray;
        }
        class_2826 section = chunk.method_38259(sectionIndex);
        if (section.method_38292()) {
            if (this.blockFilter.test(class_2246.field_10124.method_9564())) {
                return this.emptyArray;
            }
        } else if (section.method_19523(this.blockFilter)) {
            this.initialQueueChunkSection(propagateQueue, 0, 0, 0, section);
        }
        for (int cxo = -1; cxo <= 1; ++cxo) {
            for (int czo = -1; czo <= 1; ++czo) {
                class_2818 chunk2 = (class_2818)world.method_8402(cx + cxo, cz + czo, class_2806.field_12803, false);
                if (chunk2 == null) continue;
                for (int cyo = -1; cyo <= 1; ++cyo) {
                    int sectionIndex2;
                    if (cxo == 0 && cyo == 0 && czo == 0 || (sectionIndex2 = chunk2.method_31603(cy + cyo)) < 0 || sectionIndex2 >= chunk2.method_32890()) continue;
                    class_2826 section2 = chunk2.method_38259(sectionIndex2);
                    if (section2.method_38292()) {
                        if (!this.blockFilter.test(class_2246.field_10124.method_9564())) continue;
                        class_2680 air = class_2246.field_10124.method_9564();
                        int baseIndex = (cxo + 1) * 16 * 2304 + (cyo + 1) * 16 * 48 + (czo + 1) * 16 * 1;
                        int minX = 0;
                        int minY = 0;
                        int minZ = 0;
                        int maxX = 16;
                        int maxY = 16;
                        int maxZ = 16;
                        if (cxo == -1) {
                            minX = 15;
                        } else if (cxo == 1) {
                            maxX = 1;
                        }
                        if (cyo == -1) {
                            minY = 15;
                        } else if (cyo == 1) {
                            maxY = 1;
                        }
                        if (czo == -1) {
                            minZ = 15;
                        } else if (czo == 1) {
                            maxZ = 1;
                        }
                        for (int x = minX; x < maxX; ++x) {
                            for (int y = minY; y < maxY; ++y) {
                                for (int z = minZ; z < maxZ; ++z) {
                                    int index2 = baseIndex + x * 2304 + y * 48 + z * 1;
                                    PropagateDataBlock propagateDataBlock = new PropagateDataBlock(index2, air);
                                    PropagateData propagateData = new PropagateData(0, List.of(propagateDataBlock));
                                    propagateData.queued = true;
                                    this.propagateDataArray[index2] = propagateData;
                                    propagateQueue.enqueue(index2);
                                }
                            }
                        }
                        continue;
                    }
                    if (!section2.method_19523(this.blockFilter)) continue;
                    this.initialQueueChunkSection(propagateQueue, cxo, czo, cyo, section2);
                }
            }
        }
        if (propagateQueue.isEmpty()) {
            return this.emptyArray;
        }
        while (!propagateQueue.isEmpty()) {
            index = propagateQueue.dequeueInt();
            int x = index / 2304;
            int y = (index - x * 2304) / 48;
            int z = (index - x * 2304 - y * 48) / 1;
            PropagateData propagateData = this.propagateDataArray[index];
            propagateData.queued = false;
            if (x < 31) {
                ClosestBlockMap.propagateTo(index + 2304, this.propagateDataArray, propagateQueue, propagateData.blocks);
            }
            if (x > 16) {
                ClosestBlockMap.propagateTo(index - 2304, this.propagateDataArray, propagateQueue, propagateData.blocks);
            }
            if (y < 31) {
                ClosestBlockMap.propagateTo(index + 48, this.propagateDataArray, propagateQueue, propagateData.blocks);
            }
            if (y > 16) {
                ClosestBlockMap.propagateTo(index - 48, this.propagateDataArray, propagateQueue, propagateData.blocks);
            }
            if (z < 31) {
                ClosestBlockMap.propagateTo(index + 1, this.propagateDataArray, propagateQueue, propagateData.blocks);
            }
            if (z <= 16) continue;
            ClosestBlockMap.propagateTo(index - 1, this.propagateDataArray, propagateQueue, propagateData.blocks);
        }
        class_2680[] finalBlocks = new class_2680[4096];
        index = 0;
        for (int z = 16; z < 32; ++z) {
            for (int y = 16; y < 32; ++y) {
                for (int x = 16; x < 32; ++x) {
                    List<PropagateDataBlock> blockList = this.propagateDataArray[x * 2304 + y * 48 + z * 1].blocks;
                    if (blockList.size() == 1) {
                        finalBlocks[index++] = blockList.get((int)0).blockState;
                        continue;
                    }
                    class_2680 bestBlock = null;
                    int leastVerticalDistance = Integer.MAX_VALUE;
                    for (PropagateDataBlock block : blockList) {
                        int oy = (block.origin - block.origin / 2304 * 2304) / 48;
                        int dy = Math.abs(oy - y);
                        if (dy >= leastVerticalDistance) continue;
                        leastVerticalDistance = dy;
                        bestBlock = block.blockState;
                    }
                    finalBlocks[index++] = bestBlock;
                }
            }
        }
        return finalBlocks;
    }

    private void initialQueueChunkSection(IntArrayFIFOQueue propagateQueue, int cxo, int czo, int cyo, class_2826 section) {
        class_2841 container = section.method_12265();
        int index = (cxo + 1) * 16 * 2304 + (cyo + 1) * 16 * 48 + (czo + 1) * 16 * 1;
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2680 block = (class_2680)container.method_12321(x, y, z);
                    if (this.blockFilter.test(block)) {
                        PropagateDataBlock propagateDataBlock = new PropagateDataBlock(index, block);
                        PropagateData propagateData = new PropagateData(0, List.of(propagateDataBlock));
                        propagateData.queued = true;
                        this.propagateDataArray[index] = propagateData;
                        propagateQueue.enqueue(index);
                    }
                    ++index;
                }
                index += 32;
            }
            index += 1536;
        }
    }

    private static void propagateTo(int index, PropagateData[] propagateDataArray, IntArrayFIFOQueue propagateQueue, List<PropagateDataBlock> blocks) {
        PropagateData propagateData = propagateDataArray[index];
        if (propagateData != null && propagateData.minDistanceSq == 0) {
            return;
        }
        int minDistanceSq = Integer.MAX_VALUE;
        PropagateDataBlock minPropagate = null;
        int x = index / 2304;
        int y = (index - x * 2304) / 48;
        int z = (index - x * 2304 - y * 48) / 1;
        for (PropagateDataBlock block : blocks) {
            int ox = block.origin / 2304;
            int dx = ox - x;
            int oy = (block.origin - ox * 2304) / 48;
            int dy = oy - y;
            int oz = (block.origin - ox * 2304 - oy * 48) / 1;
            int dz = oz - z;
            int distanceSq = dx * dx + dy * dy + dz * dz;
            if (distanceSq >= minDistanceSq) continue;
            minDistanceSq = distanceSq;
            minPropagate = block;
        }
        if (propagateData == null) {
            ArrayList<PropagateDataBlock> list = new ArrayList<PropagateDataBlock>();
            list.add(minPropagate);
            propagateData = new PropagateData(minDistanceSq, list);
            propagateData.queued = true;
            propagateDataArray[index] = propagateData;
            propagateQueue.enqueue(index);
        } else if (minDistanceSq < propagateData.minDistanceSq) {
            propagateData.minDistanceSq = minDistanceSq;
            propagateData.blocks.clear();
            propagateData.blocks.add(minPropagate);
            if (!propagateData.queued) {
                propagateQueue.enqueue(index);
                propagateData.queued = true;
            }
        } else if (minDistanceSq == propagateData.minDistanceSq) {
            propagateData.blocks.add(minPropagate);
        }
    }

    private static final class PropagateData {
        private int minDistanceSq;
        private boolean queued = false;
        private final List<PropagateDataBlock> blocks;

        private PropagateData(int minDistanceSq, List<PropagateDataBlock> blocks) {
            this.minDistanceSq = minDistanceSq;
            this.blocks = blocks;
        }
    }

    private record PropagateDataBlock(int origin, class_2680 blockState) {
    }
}

