/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.stamp;

import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class TransformedBlockRegions {
    private final ChunkedBlockRegion[] regions = new ChunkedBlockRegion[16];
    private final Long2ObjectMap<CompressedBlockEntity>[] blockEntities = new Long2ObjectMap[16];

    public TransformedBlockRegions(ChunkedBlockRegion base, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        this.regions[0] = base;
        this.blockEntities[0] = blockEntities;
    }

    public ChunkedBlockRegion getBlocks(int rotation, boolean flipX, boolean flipZ) {
        ChunkedBlockRegion region;
        int index = rotation % 4;
        if (index < 0) {
            index += 4;
        }
        if (flipX) {
            index += 4;
        }
        if (flipZ) {
            index += 8;
        }
        if ((region = this.regions[index]) == null) {
            region = this.regions[0];
            if (flipX) {
                region = region.flip(class_2350.class_2351.field_11048);
            }
            if (flipZ) {
                region = region.flip(class_2350.class_2351.field_11051);
            }
            this.regions[index] = region = region.rotate(class_2350.class_2351.field_11052, rotation);
        }
        return region;
    }

    public Long2ObjectMap<CompressedBlockEntity> getBlockEntities(int rotation, boolean flipX, boolean flipZ) {
        Long2ObjectOpenHashMap blockEntities;
        int index = rotation % 4;
        if (index < 0) {
            index += 4;
        }
        if (flipX) {
            index += 4;
        }
        if (flipZ) {
            index += 8;
        }
        if ((blockEntities = this.blockEntities[index]) == null) {
            IntMatrix matrix = new IntMatrix();
            if (flipX) {
                matrix.flip(class_2350.class_2351.field_11048);
            }
            if (flipZ) {
                matrix.flip(class_2350.class_2351.field_11051);
            }
            matrix.rotate(class_2350.class_2351.field_11052, rotation);
            blockEntities = new Long2ObjectOpenHashMap();
            for (Long2ObjectMap.Entry entry : this.blockEntities[0].long2ObjectEntrySet()) {
                long pos = entry.getLongKey();
                int x = class_2338.method_10061((long)pos);
                int y = class_2338.method_10071((long)pos);
                int z = class_2338.method_10083((long)pos);
                int nx = matrix.transformX(x, y, z);
                int ny = matrix.transformY(x, y, z);
                int nz = matrix.transformZ(x, y, z);
                blockEntities.put(class_2338.method_10064((int)nx, (int)ny, (int)nz), (Object)((CompressedBlockEntity)entry.getValue()));
            }
            this.blockEntities[index] = blockEntities;
        }
        return blockEntities;
    }
}

