/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

public class OkLabColourUtils {
    public static float forwardGamma(float component) {
        return component * component;
    }

    public static float reverseGamma(float component) {
        return (float)Math.sqrt(component);
    }

    public static float forwardLight(float L) {
        return (float)Math.sqrt(L * L * L);
    }

    public static float reverseLight(double L) {
        return (float)Math.cbrt(L * L);
    }

    public static double cube(double value) {
        return value * value * value;
    }

    public static void rgb2lab(float R, float G, float B, double[] lab) {
        float r = OkLabColourUtils.forwardGamma(R * 0.003921569f);
        float g2 = OkLabColourUtils.forwardGamma(G * 0.003921569f);
        float b = OkLabColourUtils.forwardGamma(B * 0.003921569f);
        float l = (float)Math.cbrt(0.4121656f * r + 0.5362752f * g2 + 0.051457565f * b);
        float m4 = (float)Math.cbrt(0.2118591f * r + 0.68071896f * g2 + 0.10740658f * b);
        float s2 = (float)Math.cbrt(0.088309795f * r + 0.28184742f * g2 + 0.63026136f * b);
        lab[0] = OkLabColourUtils.forwardLight(0.21045426f * l + 0.7936178f * m4 - 0.004072047f * s2) * 100.0f;
        lab[1] = (1.9779985f * l - 2.4285922f * m4 + 0.4505937f * s2) * 127.5f;
        lab[2] = (0.025904037f * l + 0.78277177f * m4 - 0.80867577f * s2) * 127.5f;
    }

    public static int lab2rgb(double L, double A2, double B) {
        L = OkLabColourUtils.reverseLight(L / 100.0);
        float l = (float)OkLabColourUtils.cube(L + 0.3963377774 * (A2 /= 127.5) + 0.2158037573 * (B /= 127.5));
        float m4 = (float)OkLabColourUtils.cube(L - 0.1055613458 * A2 - 0.0638541728 * B);
        float s2 = (float)OkLabColourUtils.cube(L - 0.0894841775 * A2 - 1.291485548 * B);
        int r = (int)(OkLabColourUtils.reverseGamma(Math.min(Math.max(4.0767245f * l - 3.307217f * m4 + 0.23075905f * s2, 0.0f), 1.0f)) * 255.999f);
        int g2 = (int)(OkLabColourUtils.reverseGamma(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m4 - 0.34113443f * s2, 0.0f), 1.0f)) * 255.999f);
        int b = (int)(OkLabColourUtils.reverseGamma(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m4 + 1.7068626f * s2, 0.0f), 1.0f)) * 255.999f);
        return r << 16 | g2 << 8 | b;
    }
}

