/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.collections.Position2ByteMap;
import com.moulberry.axiom.collections.PositionConsumer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BiomeBuffer
implements BlockOrBiomeBuffer {
    public final Position2ByteMap map;
    public final class_5321<class_1959>[] palette;
    private final Object2ByteMap<class_5321<class_1959>> paletteReverse;
    public int paletteSize = 0;

    public BiomeBuffer() {
        this.map = new Position2ByteMap();
        this.palette = new class_5321[255];
        this.paletteReverse = new Object2ByteOpenHashMap();
    }

    private BiomeBuffer(Position2ByteMap map, class_5321<class_1959>[] palette, Object2ByteMap<class_5321<class_1959>> paletteReverse) {
        this.map = map;
        this.palette = palette;
        this.paletteReverse = paletteReverse;
        this.paletteSize = this.paletteReverse.size();
    }

    public void save(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeByte(this.paletteSize);
        for (int i = 0; i < this.paletteSize; ++i) {
            friendlyByteBuf.method_44116(this.palette[i]);
        }
        this.map.save(friendlyByteBuf);
    }

    public static BiomeBuffer load(class_2540 friendlyByteBuf) {
        int paletteSize = friendlyByteBuf.readByte();
        class_5321[] palette = new class_5321[255];
        Object2ByteOpenHashMap paletteReverse = new Object2ByteOpenHashMap();
        for (int i = 0; i < paletteSize; ++i) {
            class_5321 key;
            palette[i] = key = friendlyByteBuf.method_44112(class_7924.field_41236);
            paletteReverse.put((Object)key, (byte)(i + 1));
        }
        Position2ByteMap map = Position2ByteMap.load(friendlyByteBuf);
        return new BiomeBuffer(map, palette, (Object2ByteMap<class_5321<class_1959>>)paletteReverse);
    }

    public void clear() {
        this.map.clear();
    }

    public void forEachEntry(PositionConsumer<class_5321<class_1959>> consumer) {
        this.map.forEachEntry((int x, int y, int z, byte v) -> {
            if (v != 0) {
                consumer.accept(x, y, z, this.palette[(v & 0xFF) - 1]);
            }
        });
    }

    public class_5321<class_1959> get(int quartX, int quartY, int quartZ) {
        int index = this.map.get(quartX, quartY, quartZ) & 0xFF;
        if (index == 0) {
            return null;
        }
        return this.palette[index - 1];
    }

    private int getPaletteIndex(class_5321<class_1959> biome) {
        int index = this.paletteReverse.getOrDefault(biome, (byte)0) & 0xFF;
        if (index != 0) {
            return index;
        }
        if ((index = this.paletteSize++) >= this.palette.length) {
            throw new UnsupportedOperationException("Too many biomes! :(");
        }
        this.palette[index] = biome;
        this.paletteReverse.put(biome, (byte)(index + 1));
        return index + 1;
    }

    public void set(int quartX, int quartY, int quartZ, class_5321<class_1959> biome) {
        this.map.put(quartX, quartY, quartZ, (byte)this.getPaletteIndex(biome));
    }
}

