/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties;

import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.client.ClientWorldProperty;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertyButton;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertyButtonArray;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertyCheckbox;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertySlider;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertyTextbox;
import com.moulberry.axiom.world_properties.client.ClientWorldPropertyTime;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3902;

public interface WorldPropertyWidgetType<T> {
    public static final WorldPropertyWidgetType<Boolean> CHECKBOX = new WorldPropertyWidgetType<Boolean>(){

        @Override
        public WorldPropertyDataType<Boolean> dataType() {
            return WorldPropertyDataType.BOOLEAN;
        }

        @Override
        public ClientWorldProperty<Boolean> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertyCheckbox(id, name, localizeName, this.dataType().deserialize(data));
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(0);
        }
    };
    public static final WorldPropertyWidgetType<String> TEXTBOX = new WorldPropertyWidgetType<String>(){

        @Override
        public WorldPropertyDataType<String> dataType() {
            return WorldPropertyDataType.STRING;
        }

        @Override
        public ClientWorldProperty<String> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertyTextbox(id, name, localizeName, this.dataType().deserialize(data));
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(2);
        }
    };
    public static final WorldPropertyWidgetType<class_3902> TIME = new WorldPropertyWidgetType<class_3902>(){

        @Override
        public WorldPropertyDataType<class_3902> dataType() {
            return WorldPropertyDataType.EMPTY;
        }

        @Override
        public ClientWorldProperty<class_3902> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertyTime(id, name, localizeName);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(3);
        }
    };
    public static final WorldPropertyWidgetType<class_3902> BUTTON = new WorldPropertyWidgetType<class_3902>(){

        @Override
        public WorldPropertyDataType<class_3902> dataType() {
            return WorldPropertyDataType.EMPTY;
        }

        @Override
        public ClientWorldProperty<class_3902> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertyButton(id, name, localizeName);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(4);
        }
    };

    public WorldPropertyDataType<T> dataType();

    public ClientWorldProperty<T> create(class_2960 var1, String var2, boolean var3, byte[] var4);

    public void write(class_2540 var1);

    public static WorldPropertyWidgetType<?> read(class_2540 friendlyByteBuf) {
        int type2 = friendlyByteBuf.method_10816();
        return switch (type2) {
            case 0 -> CHECKBOX;
            case 1 -> new Slider(friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
            case 2 -> TEXTBOX;
            case 3 -> TIME;
            case 4 -> BUTTON;
            case 5 -> new ButtonArray(friendlyByteBuf.method_34066(class_2540::method_19772));
            default -> throw new RuntimeException("Unknown widget type: " + type2);
        };
    }

    public record Slider(int min, int max) implements WorldPropertyWidgetType<Integer>
    {
        @Override
        public WorldPropertyDataType<Integer> dataType() {
            return WorldPropertyDataType.INTEGER;
        }

        @Override
        public ClientWorldProperty<Integer> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertySlider(id, name, localizeName, this.dataType().deserialize(data), this.min, this.max);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(1);
            friendlyByteBuf.writeInt(this.min);
            friendlyByteBuf.writeInt(this.max);
        }
    }

    public record ButtonArray(List<String> otherButtons) implements WorldPropertyWidgetType<Integer>
    {
        @Override
        public WorldPropertyDataType<Integer> dataType() {
            return WorldPropertyDataType.INTEGER;
        }

        @Override
        public ClientWorldProperty<Integer> create(class_2960 id, String name, boolean localizeName, byte[] data) {
            return new ClientWorldPropertyButtonArray(id, name, localizeName, this.otherButtons);
        }

        @Override
        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10804(5);
            friendlyByteBuf.method_34062(this.otherButtons, class_2540::method_10814);
        }
    }
}

