/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.core.util;

public final class HashUtil {
    public static final int X_PRIME = 1619;
    public static final int Y_PRIME = 31337;
    public static final int Z_PRIME = 6971;
    public static final int W_PRIME = 1013;

    private HashUtil() {
    }

    public static int hash1D(long seed, long x) {
        long hash = seed ^ 1619L * x;
        return (int)HashUtil.finalizeHash(hash);
    }

    public static int hash2D(long seed, long x, long y) {
        long hash = seed ^ 1619L * x;
        return (int)HashUtil.finalizeHash(hash ^= 31337L * y);
    }

    public static int hash3D(long seed, long x, long y, long z) {
        long hash = seed ^ 1619L * x;
        hash ^= 31337L * y;
        return (int)HashUtil.finalizeHash(hash ^= 6971L * z);
    }

    public static int hash4D(long seed, long x, long y, long z, long w) {
        long hash = seed ^ 1619L * x;
        hash ^= 31337L * y;
        hash ^= 6971L * z;
        return (int)HashUtil.finalizeHash(hash ^= 1013L * w);
    }

    private static long finalizeHash(long hash) {
        hash = hash * hash * hash * 60493L;
        return hash >> 13 ^ hash;
    }
}

