/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.transformers.scale;

import de.articdive.jnoise.core.api.transformers.SimpleTransformer;

public final class ScaleTransformer
implements SimpleTransformer {
    private final double scaleX;
    private final double scaleY;
    private final double scaleZ;
    private final double scaleW;

    public ScaleTransformer(double scale) {
        this(scale, scale, scale, scale);
    }

    public ScaleTransformer(double scaleX, double scaleY, double scaleZ, double scaleW) {
        if (scaleX == 0.0 || scaleY == 0.0 || scaleZ == 0.0 || scaleW == 0.0) {
            throw new IllegalArgumentException("A scale value must be a non-zero value");
        }
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.scaleW = scaleW;
    }

    @Override
    public double transformX(double x) {
        return x * this.scaleX;
    }

    @Override
    public double transformY(double y) {
        return y * this.scaleY;
    }

    @Override
    public double transformZ(double z) {
        return z * this.scaleZ;
    }

    @Override
    public double transformW(double w) {
        return w * this.scaleW;
    }
}

