/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JavaConstructor;
import org.luaj.vm2.lib.jse.JavaInstance;
import org.luaj.vm2.lib.jse.JavaMethod;

class JavaClass
extends JavaInstance
implements CoerceJavaToLua.Coercion {
    static final Map classes = Collections.synchronizedMap(new HashMap());
    static final LuaValue NEW = JavaClass.valueOf("new");
    Map fields;
    Map methods;
    Map innerclasses;

    static JavaClass forClass(Class c) {
        JavaClass j = (JavaClass)classes.get(c);
        if (j == null) {
            j = new JavaClass(c);
            classes.put(c, j);
        }
        return j;
    }

    JavaClass(Class c) {
        super(c);
        this.jclass = this;
    }

    @Override
    public LuaValue coerce(Object javaValue) {
        return this;
    }

    Field getField(LuaValue key) {
        if (this.fields == null) {
            Field[] f;
            HashMap<LuaString, Field> m4 = new HashMap<LuaString, Field>();
            for (Field fi : f = ((Class)this.m_instance).getFields()) {
                if (!Modifier.isPublic(fi.getModifiers())) continue;
                m4.put(LuaValue.valueOf(fi.getName()), fi);
                try {
                    if (fi.isAccessible()) continue;
                    fi.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.fields = m4;
        }
        return (Field)this.fields.get(key);
    }

    LuaValue getMethod(LuaValue key) {
        if (this.methods == null) {
            Method[] m4;
            HashMap<String, ArrayList<JavaMethod>> namedlists = new HashMap<String, ArrayList<JavaMethod>>();
            for (Method method : m4 = ((Class)this.m_instance).getMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                ArrayList<JavaMethod> list = (ArrayList<JavaMethod>)namedlists.get(name);
                if (list == null) {
                    list = new ArrayList<JavaMethod>();
                    namedlists.put(name, list);
                }
                list.add(JavaMethod.forMethod(method));
            }
            HashMap<LuaValue, Object> map = new HashMap<LuaValue, Object>();
            Constructor<?>[] c = ((Class)this.m_instance).getConstructors();
            ArrayList<JavaConstructor> list = new ArrayList<JavaConstructor>();
            for (Constructor<?> element : c) {
                if (!Modifier.isPublic(element.getModifiers())) continue;
                list.add(JavaConstructor.forConstructor(element));
            }
            switch (list.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    map.put(NEW, list.get(0));
                    break;
                }
                default: {
                    map.put(NEW, JavaConstructor.forConstructors(list.toArray(new JavaConstructor[list.size()])));
                }
            }
            for (Map.Entry e : namedlists.entrySet()) {
                String name = (String)e.getKey();
                List methods = (List)e.getValue();
                map.put(LuaValue.valueOf(name), methods.size() == 1 ? methods.get(0) : JavaMethod.forMethods(methods.toArray(new JavaMethod[methods.size()])));
            }
            this.methods = map;
        }
        return (LuaValue)this.methods.get(key);
    }

    Class getInnerClass(LuaValue key) {
        if (this.innerclasses == null) {
            Class<?>[] c;
            HashMap m4 = new HashMap();
            for (Class<?> ci : c = ((Class)this.m_instance).getClasses()) {
                String name = ci.getName();
                String stub = name.substring(Math.max(name.lastIndexOf(36), name.lastIndexOf(46)) + 1);
                m4.put(LuaValue.valueOf(stub), ci);
            }
            this.innerclasses = m4;
        }
        return (Class)this.innerclasses.get(key);
    }

    public LuaValue getConstructor() {
        return this.getMethod(NEW);
    }
}

