/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.luajc.JavaGen;
import org.luaj.vm2.luajc.JavaLoader;

public class LuaJC
implements Globals.Loader {
    public static final LuaJC instance = new LuaJC();

    public static final void install(Globals G) {
        G.loader = instance;
    }

    protected LuaJC() {
    }

    public Hashtable compileAll(InputStream script, String chunkname, String filename, Globals globals, boolean genmain) throws IOException {
        String classname = LuaJC.toStandardJavaClassName(chunkname);
        Prototype p = globals.loadPrototype(script, classname, "bt");
        return this.compileProtoAndSubProtos(p, classname, filename, genmain);
    }

    public Hashtable compileAll(Reader script, String chunkname, String filename, Globals globals, boolean genmain) throws IOException {
        String classname = LuaJC.toStandardJavaClassName(chunkname);
        Prototype p = globals.compilePrototype(script, classname);
        return this.compileProtoAndSubProtos(p, classname, filename, genmain);
    }

    private Hashtable compileProtoAndSubProtos(Prototype p, String classname, String filename, boolean genmain) throws IOException {
        String luaname = LuaJC.toStandardLuaFileName(filename);
        Hashtable h2 = new Hashtable();
        JavaGen gen = new JavaGen(p, classname, luaname, genmain);
        this.insert(h2, gen);
        return h2;
    }

    private void insert(Hashtable h2, JavaGen gen) {
        int n;
        h2.put(gen.classname, gen.bytecode);
        int n2 = n = gen.inners != null ? gen.inners.length : 0;
        for (int i = 0; i < n; ++i) {
            this.insert(h2, gen.inners[i]);
        }
    }

    @Override
    public LuaFunction load(Prototype p, String name, LuaValue globals) throws IOException {
        String luaname = LuaJC.toStandardLuaFileName(name);
        String classname = LuaJC.toStandardJavaClassName(luaname);
        JavaLoader loader = new JavaLoader();
        return loader.load(p, classname, luaname, globals);
    }

    private static String toStandardJavaClassName(String luachunkname) {
        String stub = LuaJC.toStub(luachunkname);
        StringBuffer classname = new StringBuffer();
        int n = stub.length();
        for (int i = 0; i < n; ++i) {
            char c = stub.charAt(i);
            classname.append(i == 0 && Character.isJavaIdentifierStart(c) || i > 0 && Character.isJavaIdentifierPart(c) ? (char)c : (char)'_');
        }
        return classname.toString();
    }

    private static String toStandardLuaFileName(String luachunkname) {
        String stub = LuaJC.toStub(luachunkname);
        String filename = stub.replace('.', '/') + ".lua";
        return filename.startsWith("@") ? filename.substring(1) : filename;
    }

    private static String toStub(String s2) {
        return s2.endsWith(".lua") ? s2.substring(0, s2.length() - 4) : s2;
    }
}

