/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlock;
import com.yuushya.block.AbstractYuushyaBlockType;
import com.yuushya.block.AttachmentBlock;
import com.yuushya.block.CableBlock;
import com.yuushya.block.ColumnBlock;
import com.yuushya.block.CompactBlock;
import com.yuushya.block.FaceBlock;
import com.yuushya.block.FoodBlock;
import com.yuushya.block.HalfSlabBlock;
import com.yuushya.block.LineBlock;
import com.yuushya.block.LineCornerBlock;
import com.yuushya.block.LineCrossBlock;
import com.yuushya.block.NormalBlock;
import com.yuushya.block.PoleBlock;
import com.yuushya.block.PoleLineBlock;
import com.yuushya.block.RepeatBlock;
import com.yuushya.block.SnowLayerLikeBlock;
import com.yuushya.block.TriPartBlock;
import com.yuushya.block.TubeBlock;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.entity.ChairEntityUtils;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YuushyaBlockFactory {
    private static final Map<String, class_265> yuushyaVoxelShapes = new HashMap<String, class_265>();
    private static final Map<String, class_265> yuushyaCollisionShapes = new HashMap<String, class_265>();
    private final AbstractYuushyaBlockType finalKitType;
    private final YuushyaRegistryData.Block yuushyaBlock;

    public static Map<String, class_265> getYuushyaVoxelShapes() {
        return yuushyaVoxelShapes;
    }

    public static Map<String, class_265> getYuushyaCollisionShapes() {
        return yuushyaCollisionShapes;
    }

    public YuushyaBlockFactory(AbstractYuushyaBlockType finalKitType, YuushyaRegistryData.Block yuushyaBlock) {
        this.finalKitType = finalKitType;
        this.yuushyaBlock = yuushyaBlock;
    }

    public static class_4970.class_2251 getBlockProperties(class_4970.class_2251 blockProperties, YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        blockProperties = blockProperties.method_9629(yuushyaBlockProperties.hardness, yuushyaBlockProperties.resistance);
        if (yuushyaBlockProperties.sound != null && !yuushyaBlockProperties.sound.isEmpty()) {
            blockProperties = blockProperties.method_9626(YuushyaUtils.toSound(yuushyaBlockProperties.sound));
        }
        if (yuushyaBlockProperties.lightLevel != 0) {
            blockProperties = blockProperties.method_9631(state -> yuushyaBlockProperties.lightLevel);
        }
        if (!yuushyaBlockProperties.hasCollision) {
            blockProperties = blockProperties.method_9634();
        }
        if (yuushyaBlockProperties.isDelicate) {
            blockProperties = blockProperties.method_9618();
        }
        if (!yuushyaBlockProperties.isSolid) {
            blockProperties = blockProperties.method_22488();
        } else {
            blockProperties.method_51369();
        }
        return blockProperties;
    }

    public static class_4970.class_2251 getBlockProperties(YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        if (yuushyaBlockProperties == null) {
            return class_4970.class_2251.method_9637().method_31710(class_3620.field_16005);
        }
        class_4970.class_2251 blockProperties = class_4970.class_2251.method_9637().method_9626(YuushyaUtils.toSound(yuushyaBlockProperties.material)).method_31710(YuushyaUtils.toBlockMaterial(yuushyaBlockProperties.material));
        return YuushyaBlockFactory.getBlockProperties(blockProperties, yuushyaBlockProperties);
    }

    private static List<? extends class_2769<?>> getBlockStateProperties(YuushyaRegistryData.Block.BlockState yuushyaBlockState) {
        if (yuushyaBlockState == null || yuushyaBlockState.states == null) {
            return List.of();
        }
        return yuushyaBlockState.states.stream().map(YuushyaBlockStates::toBlockStateProperty).toList();
    }

    public static class_2248 create(YuushyaRegistryData.Block yuushyaBlock) {
        return YuushyaBlockFactory.create(YuushyaBlockFactory.getBlockProperties(yuushyaBlock.properties), yuushyaBlock);
    }

    public static class_2248 create(class_4970.class_2251 properties, final YuushyaRegistryData.Block yuushyaBlock) {
        if (yuushyaBlock.autoGenerated == null) {
            yuushyaBlock.autoGenerated = new YuushyaRegistryData.Block.AutoGenerated();
            yuushyaBlock.autoGenerated.collision = "block";
        }
        AbstractYuushyaBlockType kitType = null;
        if (yuushyaBlock.blockstate.kit != null && !yuushyaBlock.blockstate.kit.isEmpty()) {
            switch (yuushyaBlock.blockstate.kit) {
                case "normal": {
                    kitType = new NormalBlock();
                    break;
                }
                case "attachment": {
                    kitType = new AttachmentBlock();
                    break;
                }
                case "line": {
                    kitType = new LineBlock();
                    break;
                }
                case "line_corner": {
                    kitType = new LineCornerBlock();
                    break;
                }
                case "face": {
                    kitType = new FaceBlock();
                    break;
                }
                case "pole": {
                    kitType = new PoleBlock();
                    break;
                }
                case "tri_part": {
                    kitType = new TriPartBlock();
                    break;
                }
                case "tube": {
                    kitType = new TubeBlock();
                    break;
                }
                case "compact": {
                    kitType = new CompactBlock();
                    break;
                }
                case "column": {
                    kitType = new ColumnBlock();
                    break;
                }
                case "pole_line": {
                    kitType = new PoleLineBlock();
                    break;
                }
                case "repeat": {
                    kitType = new RepeatBlock();
                    break;
                }
                case "line_cross": 
                case "line_cross_simple": {
                    kitType = new LineCrossBlock();
                    break;
                }
                case "block": {
                    break;
                }
                case "VanillaSlabBlock": {
                    return new class_2482(properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "HalfSlabBlock": {
                    return new HalfSlabBlock(properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaDoorBlock": {
                    return new class_2323(properties, YuushyaUtils.toBlockSetType(yuushyaBlock.properties)){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaStairBlock": {
                    class_2680 blockState = class_2246.field_10161.method_9564();
                    if (yuushyaBlock.properties.parent != null) {
                        blockState = yuushyaBlock.properties.parent.contains(":") ? ((class_2248)class_7923.field_41175.method_10223(new class_2960(yuushyaBlock.properties.parent))).method_9564() : ((class_2248)YuushyaRegistries.BLOCKS.get(yuushyaBlock.properties.parent).get()).method_9564();
                    }
                    return new class_2510(blockState, properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaSnowLayerBlock": {
                    return new SnowLayerLikeBlock(properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
            }
        }
        switch (yuushyaBlock.classType) {
            case "CableBlock": {
                return new CableBlock(properties, yuushyaBlock.properties.lines, "CableBlock");
            }
            case "": {
                return new class_2248(properties);
            }
        }
        if (yuushyaBlock.properties.isSolid) {
            return new YuushyaBlockFactory(kitType, yuushyaBlock).new BlockWithClassTypeNormal(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType);
        }
        return new YuushyaBlockFactory(kitType, yuushyaBlock).new BlockWithClassTypeWaterLogged(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType);
    }

    public static boolean isTheSameBlock(class_2680 state1, class_2680 state2) {
        return state2.method_26204() == state1.method_26204();
    }

    public static boolean isTheSameFacing(class_2680 blockState1, class_2680 blockState2) {
        return blockState1.method_11654((class_2769)class_2741.field_12481) == blockState2.method_11654((class_2769)class_2741.field_12481);
    }

    public static boolean isTheSameLine(class_2680 blockState1, class_2680 blockState2) {
        return blockState1.method_11654((class_2769)class_2741.field_12481) == blockState2.method_11654((class_2769)class_2741.field_12481) || blockState1.method_11654((class_2769)class_2741.field_12481) == ((class_2350)blockState2.method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    public static boolean isPerpendicular(class_2680 blockState1, class_2680 blockState2) {
        class_2350 direction2;
        class_2350 direction1 = (class_2350)blockState1.method_11654((class_2769)class_2741.field_12481);
        return direction1 == (direction2 = (class_2350)blockState2.method_11654((class_2769)class_2741.field_12481)).method_10170() || direction1 == direction2.method_10160();
    }

    public class BlockWithClassTypeNormal
    extends BlockWithClassType {
        public BlockWithClassTypeNormal(class_4970.class_2251 properties, Integer tipLines, String classType) {
            super(properties, tipLines, classType);
            this.method_9590(YuushyaBlockStates.getDefaultBlockState((class_2680)this.field_10647.method_11664()));
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.defaultBlockState = this.method_9564();
            }
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
            int forms;
            List<class_2769<?>> blockStateProperties = YuushyaBlockFactory.getBlockStateProperties(YuushyaBlockFactory.this.yuushyaBlock.blockstate);
            if (YuushyaBlockFactory.this.finalKitType != null) {
                stateBuilder.method_11667((class_2769[])YuushyaBlockFactory.this.finalKitType.getBlockStateProperty().toArray(class_2769[]::new));
            } else if (!blockStateProperties.isEmpty()) {
                stateBuilder.method_11667((class_2769[])blockStateProperties.toArray(class_2769[]::new));
            }
            if (!YuushyaBlockFactory.this.yuushyaBlock.properties.isSolid) {
                stateBuilder.method_11667(new class_2769[]{class_2741.field_12508});
            }
            if (YuushyaBlockFactory.this.yuushyaBlock.blockstate != null && YuushyaBlockFactory.this.yuushyaBlock.blockstate.forms != null && !blockStateProperties.contains(YuushyaBlockStates.FORM8) && (forms = YuushyaBlockFactory.this.yuushyaBlock.blockstate.forms.size()) > 1) {
                stateBuilder.method_11667(new class_2769[]{YuushyaBlockStates.forms(forms)});
            }
        }

        public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.setPlacedBy(level, pos, state, placer, stack);
            } else {
                super.method_9567(level, pos, state, placer, stack);
            }
        }

        public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.playerWillDestroy(level, pos, state, player);
            }
            super.method_9576(level, pos, state, player);
        }

        @Nullable
        public class_2680 method_9605(class_1750 blockPlaceContext) {
            class_2680 res = this.method_9564();
            class_1937 levelAccessor = blockPlaceContext.method_8045();
            class_2338 blockPos = blockPlaceContext.method_8037();
            if (YuushyaBlockFactory.this.finalKitType != null) {
                res = YuushyaBlockFactory.this.finalKitType.getStateForPlacement(blockPlaceContext);
            } else {
                if (res.method_28498((class_2769)class_2741.field_12555) && res.method_28498((class_2769)class_2741.field_12481)) {
                    class_2350 direction = blockPlaceContext.method_7715();
                    res = direction.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)res.method_11657((class_2769)class_2741.field_12555, (Comparable)(direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8042()) : (class_2680)((class_2680)res.method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12471)).method_11657((class_2769)class_2741.field_12481, (Comparable)direction.method_10153());
                } else if (res.method_28498((class_2769)class_2741.field_12481)) {
                    class_2680 class_26802 = res = blockPlaceContext.method_8038().method_10166() == class_2350.class_2351.field_11052 ? (class_2680)res.method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8042()) : (class_2680)res.method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8038().method_10153());
                }
                if (res.method_28498(YuushyaBlockStates.XPOS)) {
                    res = (class_2680)res.method_11657(YuushyaBlockStates.XPOS, (Comparable)((Object)FaceBlock.getPositionOfFaceX(this.method_9564(), (class_1936)levelAccessor, blockPos)));
                }
                if (res.method_28498(YuushyaBlockStates.ZPOS)) {
                    res = (class_2680)res.method_11657(YuushyaBlockStates.ZPOS, (Comparable)((Object)FaceBlock.getPositionOfFaceZ(this.method_9564(), (class_1936)levelAccessor, blockPos)));
                }
                if (res.method_28498(YuushyaBlockStates.YPOS)) {
                    res = (class_2680)res.method_11657(YuushyaBlockStates.YPOS, (Comparable)((Object)PoleBlock.getPositionOfPole(this.method_9564(), (class_1936)levelAccessor, blockPos)));
                }
            }
            if (res != null && res.method_28498((class_2769)class_2741.field_12508)) {
                res = (class_2680)res.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_39360((class_3611)class_3612.field_15910)));
            }
            return res;
        }

        public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                return YuushyaBlockFactory.this.finalKitType.canSurvive(blockState, levelReader, blockPos);
            }
            return super.method_9558(blockState, levelReader, blockPos);
        }

        public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
            class_2680 res = this.method_9564();
            res = YuushyaBlockFactory.this.finalKitType != null ? YuushyaBlockFactory.this.finalKitType.updateShape(state, direction, neighborState, level, currentPos, neighborPos) : super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
            if (res != null && res.method_28498((class_2769)class_2741.field_12508) && ((Boolean)res.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
            }
            return res;
        }

        public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            YuushyaRegistryData.Block.Usage usage = YuushyaBlockFactory.this.yuushyaBlock.usage;
            if (YuushyaBlockFactory.this.yuushyaBlock.properties != null && YuushyaBlockFactory.this.yuushyaBlock.properties.food != null) {
                YuushyaRegistryData.Item.Properties.Food food = YuushyaBlockFactory.this.yuushyaBlock.properties.food;
                class_2960 finishedItem = null;
                if (YuushyaBlockFactory.this.yuushyaBlock.properties.food.finishedItem != null) {
                    finishedItem = new class_2960(YuushyaBlockFactory.this.yuushyaBlock.properties.food.finishedItem);
                }
                return FoodBlock.use(finishedItem, food.nutrition, food.saturation, state, level, pos, player, hand, hit);
            }
            if (usage != null) {
                class_2758 property;
                if (!level.field_9236 && usage.sound != null && !usage.sound.isBlank() && player.method_5998(hand).method_7960()) {
                    class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(new class_2960(usage.sound));
                    level.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 0.2f);
                }
                if (usage.sitPos != null && usage.sitPos.size() == 3 && player.method_5998(hand).method_7960()) {
                    return ChairEntityUtils.use(new class_243((double)usage.sitPos.get(0).floatValue(), (double)usage.sitPos.get(1).floatValue(), (double)usage.sitPos.get(2).floatValue()), state, level, pos, player, hand, hit);
                }
                if (usage.cycleForms != null && !usage.cycleForms.isEmpty() && player.method_5998(hand).method_7960() && (property = YuushyaUtils.getFormFromState(state)) != null) {
                    while (!usage.cycleForms.contains((state = (class_2680)state.method_28493((class_2769)property)).method_11654((class_2769)property))) {
                    }
                    level.method_8652(pos, state, 2);
                    return class_1269.method_29236((boolean)level.field_9236);
                }
            }
            return super.method_9534(state, level, pos, player, hand, hit);
        }
    }

    public class BlockWithClassTypeWaterLogged
    extends BlockWithClassTypeNormal
    implements class_3737 {
        public BlockWithClassTypeWaterLogged(class_4970.class_2251 properties, Integer tipLines, String classType) {
            super(properties, tipLines, classType);
        }
    }

    public static class BlockWithClassType
    extends AbstractYuushyaBlock {
        public String classType;
        private final Map<String, class_265> voxelShapeCache = new HashMap<String, class_265>();
        private final Map<String, class_265> collisionShapeCache = new HashMap<String, class_265>();

        public BlockWithClassType(class_4970.class_2251 properties, Integer tipLines, String classType) {
            super(properties, tipLines);
            this.classType = classType;
        }

        public boolean isTheSameType(BlockWithClassType block) {
            return this.classType.equals(block.classType);
        }

        public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
            String id = blockState.toString();
            if (!this.voxelShapeCache.containsKey(id)) {
                if (!YuushyaBlockFactory.getYuushyaVoxelShapes().containsKey(id)) {
                    CollisionFileReader.readCollisionToVoxelShape(blockState, class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString());
                }
                class_265 shape = YuushyaBlockFactory.getYuushyaVoxelShapes().getOrDefault(id, class_259.method_1077());
                this.voxelShapeCache.put(id, shape);
                return shape;
            }
            return this.voxelShapeCache.get(id);
        }

        public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
            if (!this.field_23159) {
                return class_259.method_1073();
            }
            String id = blockState.toString();
            if (!this.collisionShapeCache.containsKey(id)) {
                if (!YuushyaBlockFactory.getYuushyaCollisionShapes().containsKey(id)) {
                    class_265 collisionShape = this.method_9530(blockState, blockGetter, blockPos, collisionContext);
                    if (!YuushyaBlockFactory.getYuushyaCollisionShapes().containsKey(id)) {
                        YuushyaBlockFactory.getYuushyaCollisionShapes().put(id, CollisionFileReader.restrictShape(collisionShape));
                    }
                }
                class_265 shape = YuushyaBlockFactory.getYuushyaCollisionShapes().getOrDefault(id, class_259.method_1073());
                this.collisionShapeCache.put(id, shape);
            }
            return this.collisionShapeCache.get(id);
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
            } else if (state.method_28498((class_2769)class_2741.field_12481)) {
                state = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
            }
            if (state.method_28498((class_2769)class_2741.field_12496)) {
                state = switch (rotation) {
                    case class_2470.field_11465, class_2470.field_11463 -> {
                        switch ((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496)) {
                            case field_11048: {
                                yield (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11051);
                            }
                            case field_11051: {
                                yield (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048);
                            }
                        }
                        yield state;
                    }
                    default -> state;
                };
            }
            return state;
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
            }
            if (state.method_28498((class_2769)class_2741.field_12481)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
            }
            return super.method_9569(state, mirror);
        }

        public class_3610 method_9545(class_2680 state) {
            if (state.method_28498((class_2769)class_2741.field_12508)) {
                return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
            }
            return super.method_9545(state);
        }
    }
}

