/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaModelUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CollisionFileReader {
    private static Map<String, Map<String, class_265>> collisionMap = new HashMap<String, Map<String, class_265>>();
    public static Path COLLISION_FILES = Platform.getConfigFolder().resolve("./com.yuushya/");
    private static final Map<class_265, class_265> RESTRICT_SHAPE_MAP = new HashMap<class_265, class_265>();

    @Deprecated
    public static void readAllFileSelf() {
        Set<String> set = YuushyaRegistries.BlockALL.keySet();
        for (String name : set) {
            try {
                InputStream inputStream = CollisionFileReader.class.getResourceAsStream("/data/yuushya/collision/" + name + ".json");
                try {
                    JsonElement jsonElement;
                    CollisionItem collision;
                    if (inputStream == null || (collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(inputStream))), CollisionItem.class)) == null || collision.blockstates == null) continue;
                    HashMap<String, class_265> map = new HashMap<String, class_265>();
                    for (CollisionItem.Model variant : collision.blockstates) {
                        map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                    }
                    CollisionFileReader.getCollisionMap().put(new class_2960("yuushya", name).toString(), map);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, map);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void readAllFileFromConfig() {
        if (Files.exists(COLLISION_FILES, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(COLLISION_FILES);){
                for (Path path : paths) {
                    String namespace = path.getFileName().toString();
                    Path newPath = path.resolve("./data/" + namespace + "/collision/");
                    DirectoryStream<Path> collisionFiles = Files.newDirectoryStream(newPath);
                    try {
                        for (Path collisionFile : collisionFiles) {
                            String id = collisionFile.getFileName().toString().replace(".json", "");
                            if (!Files.exists(collisionFile, new LinkOption[0])) continue;
                            try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new FileReader(collisionFile.toFile(), StandardCharsets.UTF_8)));){
                                CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(JsonParser.parseReader((JsonReader)reader), CollisionItem.class);
                                if (collision == null || collision.blockstates == null) continue;
                                HashMap<String, class_265> map = new HashMap<String, class_265>();
                                for (CollisionItem.Model variant : collision.blockstates) {
                                    map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                                }
                                CollisionFileReader.getCollisionMap().put(new class_2960(namespace, id).toString(), map);
                                if (collision.children == null) continue;
                                for (String namespaceId : collision.children) {
                                    CollisionFileReader.getCollisionMap().put(namespaceId, map);
                                }
                            }
                        }
                    }
                    finally {
                        if (collisionFiles == null) continue;
                        collisionFiles.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllCollision() {
        if (YuushyaBlockFactory.getYuushyaVoxelShapes().isEmpty()) {
            CollisionFileReader.getCollisionMap().forEach((key, value) -> CollisionFileReader.readCollisionToVoxelShape(key));
        }
    }

    public static void readCollisionToVoxelShape(class_2680 blockState, String namespaceid) {
        Map<String, class_265> collision;
        if (!(blockState.method_26204() instanceof class_2189) && (collision = CollisionFileReader.getCollisionMap().get(namespaceid)) != null) {
            for (String variant : collision.keySet()) {
                if (!YuushyaModelUtils.isBlockStateInVariantString(blockState, variant)) continue;
                class_265 shape = collision.get(variant);
                String id = blockState.toString();
                YuushyaBlockFactory.getYuushyaVoxelShapes().put(id, shape);
                YuushyaBlockFactory.getYuushyaCollisionShapes().put(id, CollisionFileReader.restrictShape(shape));
            }
        }
    }

    public static void readCollisionToVoxelShape(String namespaceid) {
        class_2248 block;
        Map<String, class_265> collision = CollisionFileReader.getCollisionMap().get(namespaceid);
        if (collision != null && !((block = (class_2248)class_7923.field_41175.method_10223(new class_2960(namespaceid))) instanceof class_2189)) {
            for (Map.Entry<String, class_265> entry : collision.entrySet()) {
                String variant = entry.getKey();
                class_265 shape = entry.getValue();
                List<class_2680> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant);
                for (class_2680 blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(blockstate.toString(), shape);
                    YuushyaBlockFactory.getYuushyaCollisionShapes().put(blockstate.toString(), CollisionFileReader.restrictShape(shape));
                }
            }
        }
    }

    public static class_265 getVoxelShape(CollisionItem.Model model) {
        class_265 shape = class_259.method_1073();
        if (model.collision == null) {
            return class_259.method_1077();
        }
        for (CollisionItem.Model.Element cube : model.collision) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)cube.from.get(0), (double)cube.from.get(1), (double)cube.from.get(2), (double)cube.to.get(0), (double)cube.to.get(1), (double)cube.to.get(2)));
        }
        if ((shape = shape.method_1097()).method_1110()) {
            return class_259.method_1077();
        }
        return shape;
    }

    public static class_265 restrictShape(class_265 shape) {
        if (RESTRICT_SHAPE_MAP.containsKey(shape)) {
            return RESTRICT_SHAPE_MAP.get(shape);
        }
        class_265 res = class_259.method_1073();
        for (class_238 aabb : shape.method_1090()) {
            class_265 one = class_259.method_31943((double)Math.max(0.0, aabb.field_1323), (double)Math.max(0.0, aabb.field_1322), (double)Math.max(0.0, aabb.field_1321), (double)Math.min(1.0, aabb.field_1320), (double)Math.min(1.5, aabb.field_1325), (double)Math.min(1.0, aabb.field_1324));
            res = class_259.method_1084((class_265)res, (class_265)one);
        }
        res = res.method_1097();
        RESTRICT_SHAPE_MAP.put(shape, res);
        return res;
    }

    public static Map<String, Map<String, class_265>> getCollisionMap() {
        return collisionMap;
    }

    public static void setCollisionMap(Map<String, Map<String, class_265>> collisionMap) {
        CollisionFileReader.collisionMap = collisionMap;
    }
}

