/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.yuushya.utils.GsonTools;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class YuushyaConfig {
    public static Config CONFIG = new Config();
    public static ClientConfig CLIENT_CONFIG = new ClientConfig();

    public static class Config
    implements CommonConfig<Config> {
        public boolean self = true;
        public static final Path CONFIG_FILE = Platform.getConfigFolder().resolve("com.yuushya/config.json");

        @Override
        public Path configPath() {
            return CONFIG_FILE;
        }

        @Override
        public Class<Config> getSerializedClass() {
            return Config.class;
        }

        @Override
        public void setConfig(Config instance) {
            CONFIG = instance;
        }

        @Override
        public Config getConfig() {
            return this;
        }
    }

    public static class ClientConfig
    implements CommonConfig<ClientConfig> {
        public boolean check = true;
        public static final Path CLIENT_CONFIG_FILE = Platform.getConfigFolder().resolve("com.yuushya/client_config.json");

        @Override
        public Path configPath() {
            return CLIENT_CONFIG_FILE;
        }

        @Override
        public Class<ClientConfig> getSerializedClass() {
            return ClientConfig.class;
        }

        @Override
        public void setConfig(ClientConfig instance) {
            CLIENT_CONFIG = instance;
        }

        @Override
        public ClientConfig getConfig() {
            return this;
        }
    }

    static interface CommonConfig<T extends CommonConfig<T>> {
        public Path configPath();

        public Class<T> getSerializedClass();

        public void setConfig(T var1);

        public T getConfig();

        default public void read() {
            if (Files.exists(this.configPath(), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(this.configPath());){
                    this.setConfig((CommonConfig)GsonTools.NormalGSON.fromJson((Reader)reader, this.getSerializedClass()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        default public void update() {
            if (!Files.exists(this.configPath(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.configPath().getParent(), new FileAttribute[0]);
                    Files.createFile(this.configPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Files.exists(this.configPath(), new LinkOption[0])) {
                try (BufferedWriter writer = Files.newBufferedWriter(this.configPath(), new OpenOption[0]);){
                    String json = GsonTools.NormalGSON.toJson(this.getConfig(), this.getSerializedClass());
                    writer.write(json);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

