/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonObject;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.entity.ChairEntity;
import com.yuushya.item.BlockUpdateItem;
import com.yuushya.item.FoodItem;
import com.yuushya.item.FormTransItem;
import com.yuushya.item.SetHatItem;
import com.yuushya.item.TemplateBlockItem;
import com.yuushya.item.TemplateChildBlockItem;
import com.yuushya.item.YuushyaItemFactory;
import com.yuushya.particle.YuushyaParticleBlock;
import com.yuushya.registries.YuushyaCreativeModeTab;
import com.yuushya.registries.YuushyaDeferredRegister;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaUtils;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class YuushyaRegistries {
    public static final YuushyaDeferredRegister<class_2248> BLOCKS = new YuushyaDeferredRegister(class_7924.field_41254);
    public static final YuushyaDeferredRegister<class_1792> ITEMS = new YuushyaDeferredRegister(class_7924.field_41197);
    public static final YuushyaDeferredRegister<class_2591<?>> BLOCK_ENTITIES = new YuushyaDeferredRegister(class_7924.field_41255);
    public static final YuushyaDeferredRegister<class_1299<?>> ENTITIES = new YuushyaDeferredRegister(class_7924.field_41266);
    public static final YuushyaDeferredRegister<class_2396<?>> PARTICLE_TYPES = new YuushyaDeferredRegister(class_7924.field_41210);
    public static final Map<String, YuushyaRegistryData.Block> BlockALL = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockTemplate = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockDefault = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockRemain = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> TextureTypeMap = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static RegistrySupplier<class_1299<?>> CHAIR_ENTITY = null;

    public static void registerRegistries() {
        for (YuushyaRegistryData.ItemGroup itemGroup : YuushyaRegistryConfig.YuushyaRawItemGroupMap.values()) {
            YuushyaCreativeModeTab.register(itemGroup.name, itemGroup.icon);
        }
        for (YuushyaRegistryData.Item item : YuushyaRegistryConfig.YuushyaRawItemMap.values()) {
            ITEMS.register(item.name, () -> YuushyaItemFactory.create(item));
        }
        block13: for (YuushyaRegistryData.Block block : YuushyaRegistryConfig.YuushyaRawBlockMap.values()) {
            switch (block.classType) {
                case "_comment": 
                case "class": {
                    continue block13;
                }
                case "remain": {
                    BlockRemain.put(block.name, block);
                    continue block13;
                }
                case "template": {
                    BlockTemplate.put(block.name, block);
                    continue block13;
                }
            }
            BlockDefault.put(block.name, block);
            if (block.classType.equals("block")) {
                if (block.renderType == null || block.renderType.isEmpty()) {
                    block.renderType = "cutout";
                }
                if (block.itemGroup == null) {
                    block.itemGroup = "extra_blocks";
                }
                if (block.texture == null) {
                    block.texture = new YuushyaRegistryData.Block.Texture();
                    block.texture.type = "all";
                }
            }
            if (block.texture == null || block.texture.type == null || block.texture.type.isEmpty()) continue;
            TextureTypeMap.put(block.name, block);
        }
        for (YuushyaRegistryData.Block blockRemain : BlockRemain.values()) {
            class_2960 blockResourceLocation = new class_2960(blockRemain.name);
            if (blockRemain.texture == null) {
                blockRemain.texture = new YuushyaRegistryData.Block.Texture();
                blockRemain.texture.type = "all";
            }
            if (blockRemain.texture.value == null || blockRemain.texture.value.isEmpty()) {
                blockRemain.texture.value = new class_2960(blockResourceLocation.method_12836(), "block/" + blockResourceLocation.method_12832()).toString();
            }
            if (blockRemain.texture.type == null || blockRemain.texture.type.isEmpty()) continue;
            TextureTypeMap.put(blockRemain.name, blockRemain);
        }
        for (YuushyaRegistryData.Block templateBlock : BlockTemplate.values()) {
            int lines = templateBlock.properties == null ? 1 : templateBlock.properties.lines;
            ITEMS.register(templateBlock.name, () -> new TemplateBlockItem(new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.toGroup(templateBlock.itemGroup)), lines, templateBlock.name));
        }
        for (YuushyaRegistryData.Block block : BlockDefault.values()) {
            BlockALL.put(block.name, block);
            BLOCKS.register(block.name, () -> YuushyaBlockFactory.create(block));
            if (block.properties != null && block.properties.food != null) {
                ITEMS.register(block.name, () -> new FoodItem((class_2248)BLOCKS.get(block.name).get(), block, new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.toGroup(block.itemGroup))));
                continue;
            }
            ITEMS.register(block.name, () -> new class_1747((class_2248)BLOCKS.get(block.name).get(), new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.toGroup(block.itemGroup))));
        }
        for (YuushyaRegistryData.Block templateBlock : BlockTemplate.values()) {
            JsonObject templateBlockJson = GsonTools.NormalGSON.toJsonTree((Object)templateBlock, YuushyaRegistryData.Block.class).getAsJsonObject();
            List<YuushyaRegistryData.Block> list = YuushyaRegistries.getTemplateUsageList(templateBlock);
            for (YuushyaRegistryData.Block block : list) {
                String name;
                class_4970.class_2251 properties;
                JsonObject blockJson = GsonTools.NormalGSON.toJsonTree((Object)block, YuushyaRegistryData.Block.class).getAsJsonObject();
                YuushyaRegistryData.Block blockNew = GsonTools.combineYuushyaDataBlockJson(blockJson, templateBlockJson);
                blockNew.properties.parent = block.name;
                if (block.classType.equals("remain")) {
                    class_2960 blockResourceLocation = new class_2960(block.name);
                    properties = YuushyaBlockFactory.getBlockProperties(class_4970.class_2251.method_9630((class_4970)((class_4970)class_7923.field_41175.method_10223(blockResourceLocation))), blockNew.properties);
                    if (blockNew.properties != null) {
                        properties.method_31710(class_3620.field_16030);
                    } else {
                        properties.method_31710(class_3620.field_16008);
                    }
                    name = blockResourceLocation.method_12832();
                } else {
                    properties = YuushyaBlockFactory.getBlockProperties(blockNew.properties);
                    name = block.name;
                }
                blockNew.name = templateBlock.name + "_" + name;
                blockNew.classType = "template:" + templateBlock.name;
                BLOCKS.register(blockNew.name, () -> YuushyaBlockFactory.create(properties, blockNew));
                ITEMS.register(blockNew.name, () -> new TemplateChildBlockItem((class_2248)BLOCKS.get(blockNew.name).get(), new class_1792.class_1793(), block.classType, templateBlock.name, block.name));
                BlockALL.put(blockNew.name, blockNew);
            }
        }
        for (YuushyaRegistryData.Particle particle : YuushyaRegistryConfig.YuushyaRawParticleMap.values()) {
            if (particle.spawner == null) {
                particle.spawner = new YuushyaRegistryData.Block();
            }
            if (particle.spawner.properties == null) {
                particle.spawner.properties = new YuushyaRegistryData.Block.Properties();
            }
            if (particle.spawner.name == null || particle.spawner.name.isEmpty()) {
                particle.spawner.name = particle.name + "_spawner";
            }
            BLOCKS.register(particle.spawner.name, () -> new YuushyaParticleBlock(YuushyaBlockFactory.getBlockProperties(particle.spawner.properties), particle.spawner.properties.lines, "ParticleBlock", particle.spawner.usage, () -> (class_2400)PARTICLE_TYPES.get(particle.name).get()));
            ITEMS.register(particle.spawner.name, () -> new class_1747((class_2248)BLOCKS.get(particle.spawner.name).get(), new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.toGroup(particle.spawner.itemGroup))));
            PARTICLE_TYPES.register(particle.name, YuushyaParticleBlock.YuushyaParticleType::create);
        }
    }

    public static List<YuushyaRegistryData.Block> getTemplateUsageList(YuushyaRegistryData.Block templateBlock) {
        ArrayList<YuushyaRegistryData.Block> list = new ArrayList<YuushyaRegistryData.Block>();
        if (templateBlock.texture == null || templateBlock.texture.forClass == null && templateBlock.texture.forSpecified == null) {
            list.addAll(TextureTypeMap.values());
        } else {
            if (templateBlock.texture.forClass != null) {
                list.addAll(TextureTypeMap.values().stream().filter(e -> templateBlock.texture.forClass.contains(e.texture.type)).toList());
            }
            if (templateBlock.texture.forSpecified != null) {
                templateBlock.texture.forSpecified.forEach(name -> {
                    class_2960 resourceLocation = class_2960.method_12829((String)name);
                    if (resourceLocation != null) {
                        if (TextureTypeMap.containsKey(resourceLocation.toString())) {
                            list.add(TextureTypeMap.get(resourceLocation.toString()));
                        }
                        if (TextureTypeMap.containsKey(resourceLocation.method_12832())) {
                            list.add(TextureTypeMap.get(resourceLocation.method_12832()));
                        }
                    }
                });
            }
        }
        return list;
    }

    public static void registerAll() {
        ITEMS.register("form_trans_item", () -> new FormTransItem(new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.YUUSHYA_ITEM).method_7889(1), 2));
        ITEMS.register("blockstate_update_item", () -> new BlockUpdateItem(new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.YUUSHYA_ITEM).method_7889(1), 2));
        ITEMS.register("pilatory", () -> new SetHatItem(new class_1792.class_1793().arch$tab(YuushyaCreativeModeTab.YUUSHYA_ITEM).method_7889(64), 2));
        CHAIR_ENTITY = ENTITIES.register("ride_entity", () -> class_1299.class_1300.method_5903(ChairEntity::new, (class_1311)class_1311.field_17715).method_17687(0.4f, 0.02f).method_5905("ride_entity"));
        YuushyaCreativeModeTab.REGISTER_TABS.register();
    }

    public static void registerClient() {
        BlockALL.values().forEach(block -> {
            RenderTypeRegistry.register((class_1921)YuushyaUtils.toRenderType(block.renderType), (class_2248[])new class_2248[]{(class_2248)BLOCKS.get(block.name).get()});
            if (block.colorTint != null && block.colorTint.colorType != null && !block.colorTint.colorType.isEmpty() && !block.colorTint.colorType.equals("null")) {
                ColorHandlerRegistry.registerBlockColors((class_322)YuushyaUtils.toBlockColor(block.colorTint.colorType, block.colorTint.colorString), (Supplier[])new Supplier[]{BLOCKS.get(block.name)});
            }
        });
    }
}

