/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3294;
import net.minecraft.class_3298;

public class AddonLoader {
    private static final Predicate<Path> ADDON_FILTER = path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".yuushya.jar");
    private static final Predicate<class_2960> JSON_FILTER = resourceLocation -> resourceLocation.method_12832().endsWith(".json");
    private static final class_3294 YUUSHYA_MANAGER = new class_3294(class_3264.field_14190, "yuushya");

    private static Path classJarPath(String modId, Class<?> ... clazz) {
        List paths;
        if (modId != null && Platform.getModIds().contains(modId) && (paths = Platform.getMod((String)modId).getFilePaths()) != null && !paths.isEmpty()) {
            for (Path res : paths) {
                if (res.toString().isEmpty() || !Files.isRegularFile(res, new LinkOption[0])) continue;
                return res;
            }
        }
        for (Class<?> cls : clazz) {
            CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
            if (codeSource == null) continue;
            URL jarPath = codeSource.getLocation();
            String decoded = URLDecoder.decode(jarPath.getPath(), StandardCharsets.UTF_8);
            String dir = new File(decoded).getPath().replaceAll("#.+!", "").replaceAll("\\.jar.+", ".jar");
            return Paths.get(dir, new String[0]);
        }
        return null;
    }

    public static void loadResource(String modId, Class<?> ... clazz) {
        Path path = AddonLoader.classJarPath(modId, clazz);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            try (class_3259 packResource = Files.isDirectory(path, new LinkOption[0]) ? new class_3259(path.getFileName().toString(), path, false) : new class_3258(path.getFileName().toString(), path.toFile(), false);){
                YUUSHYA_MANAGER.method_24233((class_3262)packResource);
            }
        }
    }

    public static void loadPackResource(Path folder) {
        try (Stream<Path> files = Files.list(folder).filter(ADDON_FILTER).sorted(Comparator.comparing(Path::toString));){
            List<Path> fileList = files.toList();
            for (Path path : fileList) {
                try (class_3258 packResource = new class_3258(path.getFileName().toString(), path.toFile(), false);){
                    YUUSHYA_MANAGER.method_24233((class_3262)packResource);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <V> List<Map.Entry<class_2960, V>> sortMapEntry(Set<Map.Entry<class_2960, V>> entrySet) {
        return entrySet.stream().sorted(Comparator.comparing(a -> ((class_2960)a.getKey()).method_12832()).thenComparing(a -> ((class_2960)a.getKey()).method_12836())).toList();
    }

    public static void getRegister() {
        for (Map.Entry entry : AddonLoader.sortMapEntry(YUUSHYA_MANAGER.method_14488("register", JSON_FILTER).entrySet())) {
            try {
                class_3298 resource = (class_3298)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.method_43039());){
                    JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                    YuushyaRegistryConfig.mergeYuushyaRegistryBlockClass(innerJson);
                    YuushyaRegistryData YuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
                    YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void getCollision() {
        for (Map.Entry entry : AddonLoader.sortMapEntry(YUUSHYA_MANAGER.method_14488("collision", JSON_FILTER).entrySet())) {
            try {
                class_2960 file = entry.getKey();
                class_2960 namespaceId1 = new class_2960("yuushya", file.method_12832().substring("collision/".length(), file.method_12832().length() - ".json".length()));
                class_3298 resource = (class_3298)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.method_43039());){
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    HashMap<String, class_265> map = new HashMap<String, class_265>();
                    for (CollisionItem.Model variant : collision.blockstates) {
                        map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                    }
                    CollisionFileReader.getCollisionMap().put(namespaceId1.toString(), map);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, map);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

