/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_155;
import net.minecraft.class_310;

public class CheckFileUtils {
    public static final Gson NormalGSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static Map<String, Info> information = new HashMap<String, Info>();
    public static final Map<String, Info> ctm = new HashMap<String, Info>();
    public static final Map<String, Info> resourcepacks = new HashMap<String, Info>();
    public static final Map<String, Info> recommend = new HashMap<String, Info>();
    private static String version;
    private static String api;
    private static final InputStream INFORMATION_FILE;
    private static final String MOD_ID_INDIUM = "indium";
    private static final String MOD_ID_SODIUM = "sodium";
    private static final String MOD_ID_YUUSHYA_MODELLING = "yuushya_modelling";
    private static final String MOD_ID_CONTINUITY = "continuity";

    public static Info info(String id) {
        return information.get(id);
    }

    public static void loadInformation() {
        version = class_155.method_16673().method_48019();
        String string = Platform.isFabric() ? "fabric" : (api = Platform.isForge() ? "forge" : "");
        if (INFORMATION_FILE != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(INFORMATION_FILE));){
                JsonElement jsonElement = JsonParser.parseReader((Reader)bufferedReader);
                information = (Map)NormalGSON.fromJson(jsonElement, new TypeToken<Map<String, Info>>(){}.getType());
                for (Map.Entry<String, Info> entry : information.entrySet()) {
                    Info info = entry.getValue();
                    if (!info.api.contains(api) || !info.minecraft.contains(version)) continue;
                    switch (info.type) {
                        case "ctm": {
                            ctm.put(entry.getKey(), info);
                            break;
                        }
                        case "resourcepack": {
                            resourcepacks.put(entry.getKey(), info);
                            break;
                        }
                        case "recommend": {
                            recommend.put(entry.getKey(), info);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void printInformation() {
        for (Info info : information.values()) {
            System.out.println(info);
        }
    }

    public static List<Info> checkCTM() {
        for (Info info : ctm.values()) {
            if (!CheckFileUtils.checkMod(info.id)) continue;
            return List.of();
        }
        return ctm.values().stream().toList();
    }

    public static List<Info> checkResourcePacks() {
        return resourcepacks.values().stream().filter(info -> !CheckFileUtils.checkResourceFile(info.id)).toList();
    }

    public static List<Info> checkRecommend() {
        ArrayList<Info> list = new ArrayList<Info>(recommend.values().stream().filter(info -> !MOD_ID_INDIUM.equals(info.id) && !CheckFileUtils.checkMod(info.id)).toList());
        if (Platform.isFabric() && CheckFileUtils.checkMod(MOD_ID_SODIUM) && (CheckFileUtils.checkMod(MOD_ID_YUUSHYA_MODELLING) || CheckFileUtils.checkMod(MOD_ID_CONTINUITY)) && !CheckFileUtils.checkMod(MOD_ID_INDIUM)) {
            list.add(recommend.get(MOD_ID_INDIUM));
        }
        return list;
    }

    public static boolean checkMod(String id) {
        return Platform.getModIds().contains(id);
    }

    public static boolean checkResourceFile(String id) {
        class_310 minecraft = class_310.method_1551();
        String id1 = id.replace("_", "").toLowerCase();
        for (String selectedId : minecraft.method_1520().method_29210()) {
            if (!selectedId.replaceAll("\\s", "").replaceAll("_", "").toLowerCase().contains(id1)) continue;
            return true;
        }
        return false;
    }

    public static int compareVersion(String version1, String version2) {
        String ver1 = version1.substring(2);
        String ver2 = version2.substring(2);
        return Double.compare(Double.parseDouble(ver1), Double.parseDouble(ver2));
    }

    public static boolean between(String version, String begin, String end) {
        if (begin == null) {
            if (end == null) {
                return true;
            }
            return CheckFileUtils.compareVersion(version, end) < 0;
        }
        if (end == null) {
            return CheckFileUtils.compareVersion(version, begin) >= 0;
        }
        return CheckFileUtils.compareVersion(version, begin) >= 0 && CheckFileUtils.compareVersion(version, end) < 0;
    }

    static {
        INFORMATION_FILE = CheckFileUtils.class.getResourceAsStream("/assets/yuushya/information/information.json");
    }

    public record Info(String id, String type, List<String> api, String version, List<String> minecraft, Map<String, String> link) {
    }
}

