/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting;

import com.lx862.mtrscripting.ScriptManager;
import com.lx862.mtrscripting.core.ScriptInstance;
import com.lx862.mtrscripting.data.UniqueKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ScriptInstanceManager {
    private final Map<UniqueKey, ScriptInstance> instances = new HashMap<UniqueKey, ScriptInstance>();

    public <T> ScriptInstance<T> getInstance(UniqueKey id, Supplier<ScriptInstance<T>> getInstance) {
        ScriptInstance<T> existingInstance = this.getInstance(id);
        if (existingInstance != null) {
            return existingInstance;
        }
        ScriptInstance<T> newInstance = getInstance.get();
        newInstance.getScript().invokeCreateFunction(newInstance, () -> {});
        this.instances.put(id, newInstance);
        return newInstance;
    }

    public <T> ScriptInstance<T> getInstance(UniqueKey id) {
        return this.instances.get(id);
    }

    public void clearDeadInstance() {
        int count = 0;
        for (Map.Entry<UniqueKey, ScriptInstance> entry : new HashMap<UniqueKey, ScriptInstance>(this.instances).entrySet()) {
            if (!entry.getValue().isDead()) continue;
            ScriptInstance instance = entry.getValue();
            ++count;
            instance.getScript().invokeDisposeFunction(instance, () -> this.instances.remove(entry.getKey()));
        }
        if (count > 0) {
            ScriptManager.LOGGER.debug("[Scripting] Removed {} dead instance", (Object)count);
        }
    }

    public void reset() {
        for (ScriptInstance instance : new HashMap<UniqueKey, ScriptInstance>(this.instances).values()) {
            instance.getScript().invokeDisposeFunction(instance, () -> {});
        }
        this.instances.clear();
    }
}

