/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.core;

import com.lx862.mtrscripting.api.ClassRule;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ClassShutter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;

public class MTRClassShutter
implements ClassShutter {
    private final ObjectList<ClassRule> allowedScriptClasses = new ObjectArrayList();
    private final ObjectList<ClassRule> deniedScriptClasses = new ObjectArrayList();

    public MTRClassShutter() {
        this.allowClass(ClassRule.parse("java.awt.*"), ClassRule.parse("java.lang.*"), ClassRule.parse("java.util.*"), ClassRule.parse("sun.java2d.*"), ClassRule.parse("java.io.Closeable"), ClassRule.parse("java.io.InputStream"), ClassRule.parse("java.io.OutputStream"));
        this.denyClass(ClassRule.parse("java.lang.reflect.*"));
    }

    public void allowClass(ClassRule ... classRules) {
        this.allowedScriptClasses.addAll(Arrays.asList(classRules));
    }

    public void denyClass(ClassRule ... classRules) {
        this.deniedScriptClasses.addAll(Arrays.asList(classRules));
    }

    @Override
    public boolean visibleToScripts(String fullClassName) {
        return fullClassName.startsWith("com.lx862.mtrscripting.util") || fullClassName.startsWith("com.lx862.mtrscripting.lib.org.mozilla") || this.isClassAllowed(fullClassName);
    }

    private boolean isClassAllowed(String str) {
        for (ClassRule cs : this.deniedScriptClasses) {
            if (!cs.match(str)) continue;
            return false;
        }
        for (ClassRule cs : this.allowedScriptClasses) {
            if (!cs.match(str)) continue;
            return true;
        }
        return false;
    }
}

