/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeObject;
import com.lx862.mtrscripting.util.NetworkResponse;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class NetworkingUtil {
    public static NetworkResponse<?> fetchString(String urlStr) throws IOException {
        return NetworkingUtil.fetchString(urlStr, null);
    }

    public static NetworkResponse<BufferedImage> fetchImage(String urlStr) throws IOException {
        return NetworkingUtil.fetchImage(urlStr, null);
    }

    public static NetworkResponse<?> fetchString(String urlStr, NativeObject requestObject) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        NetworkingUtil.processRequestObject(requestObject, urlConnection);
        try (InputStream is = urlConnection.getInputStream();){
            String str = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            NetworkResponse<String> networkResponse = new NetworkResponse<String>(str, urlConnection.getHeaderFields(), urlConnection.getResponseCode());
            return networkResponse;
        }
    }

    public static NetworkResponse<BufferedImage> fetchImage(String urlStr, NativeObject requestObject) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        NetworkingUtil.processRequestObject(requestObject, urlConnection);
        try (InputStream is = urlConnection.getInputStream();){
            NetworkResponse<BufferedImage> networkResponse = new NetworkResponse<BufferedImage>(ImageIO.read(is), urlConnection.getHeaderFields(), urlConnection.getResponseCode());
            return networkResponse;
        }
    }

    private static void processRequestObject(NativeObject requestObject, HttpURLConnection connection) throws IOException {
        String body = null;
        if (requestObject != null) {
            Object timeoutObj;
            if (requestObject.containsKey("method")) {
                connection.setRequestMethod((String)requestObject.get("method"));
            }
            if (requestObject.containsKey("connectTimeout")) {
                timeoutObj = requestObject.get("connectTimeout");
                if (timeoutObj instanceof Double) {
                    connection.setConnectTimeout((int)((Double)timeoutObj).doubleValue());
                }
                if (timeoutObj instanceof Integer) {
                    connection.setConnectTimeout((Integer)timeoutObj);
                }
            }
            if (requestObject.containsKey("readTimeout")) {
                timeoutObj = requestObject.get("readTimeout");
                if (timeoutObj instanceof Double) {
                    connection.setReadTimeout((int)((Double)timeoutObj).doubleValue());
                }
                if (timeoutObj instanceof Integer) {
                    connection.setReadTimeout((Integer)timeoutObj);
                }
            }
            if (requestObject.containsKey("headers")) {
                NativeObject headerObject = (NativeObject)requestObject.get("headers");
                for (Map.Entry<Object, Object> header : headerObject.entrySet()) {
                    connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                }
            }
            if (requestObject.containsKey("body")) {
                body = (String)requestObject.get("body");
            }
        }
        connection.setRequestProperty("User-Agent", "Joban Client Mod (https://joban.org/jcm)");
        if (body != null) {
            byte[] bodyByte = body.getBytes();
            long contentLength = bodyByte.length;
            connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            connection.setDoOutput(true);
            try (DataOutputStream dos = new DataOutputStream(connection.getOutputStream());){
                dos.write(bodyByte);
            }
        }
    }
}

