/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.mtrscripting.ScriptManager;
import com.lx862.mtrscripting.api.ScriptingAPI;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.util.GraphicsTexture;
import fabric.com.lx862.jcm.mod.util.JCMLogger;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.text.AttributedString;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class ScriptResourceUtil {
    public static Context activeContext;
    public static Scriptable activeScope;
    private static final Stack<Identifier> scriptLocationStack;
    private static final Identifier NOTO_SANS_CJK_LOCATION;
    private static final Identifier NOTO_SANS_LOCATION;
    private static final Identifier NOTO_SERIF_LOCATION;
    private static boolean hasNotoSansCjk;
    private static Font NOTO_SANS_MAYBE_CJK;
    private static Font NOTO_SERIF_CACHE;
    private static final FontRenderContext FONT_CONTEXT;

    public static void executeScript(Context rhinoCtx, Scriptable scope, Identifier scriptLocation, String script) {
        scriptLocationStack.push(scriptLocation);
        rhinoCtx.evaluateString(scope, script, scriptLocation.getNamespace() + ":" + scriptLocation.getPath(), 1, null);
        scriptLocationStack.pop();
    }

    public static void includeScript(Object pathOrIdentifier) {
        if (activeContext == null) {
            throw new RuntimeException("Cannot use include in functions, as by that time scripts are no longer processed.");
        }
        Identifier identifier = pathOrIdentifier instanceof Identifier ? (Identifier)pathOrIdentifier : ScriptResourceUtil.idRelative(pathOrIdentifier.toString());
        ScriptResourceUtil.executeScript(activeContext, activeScope, identifier, ResourceManagerHelper.readResource((Identifier)identifier));
    }

    public static void print(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        if (objs == null) {
            sb.append("null");
        } else {
            for (Object obj : objs) {
                sb.append(obj);
            }
        }
        ScriptManager.LOGGER.info("[Scripting] {}", (Object)sb.toString());
    }

    public static Identifier identifier(String textForm) {
        return new Identifier(textForm);
    }

    public static Identifier id(String textForm) {
        return new Identifier(textForm);
    }

    public static Identifier idRelative(String textForm) {
        if (scriptLocationStack.empty()) {
            throw new RuntimeException("Cannot use idRelative in functions.");
        }
        return ScriptResourceUtil.resolveRelativePath(scriptLocationStack.peek(), textForm);
    }

    public static Identifier idr(String textForm) {
        if (scriptLocationStack.empty()) {
            throw new RuntimeException("Cannot use idr in functions.");
        }
        Identifier id = scriptLocationStack.peek();
        return ScriptResourceUtil.resolveRelativePath(id, textForm);
    }

    public static void readStream(Identifier identifier, Consumer<InputStream> inputStreamConsumer) {
        ResourceManagerHelper.readResource((Identifier)identifier, inputStreamConsumer);
    }

    public static String readString(Identifier identifier) {
        String[] string = new String[]{null};
        ResourceManagerHelper.readResource((Identifier)identifier, inputStream -> {
            try {
                string[0] = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                JCMLogger.error("", e);
            }
        });
        return string[0];
    }

    public static Font getSystemFont(String fontName) {
        if (fontName.equals("Noto Sans")) {
            if (NOTO_SANS_MAYBE_CJK == null) {
                if (hasNotoSansCjk) {
                    try {
                        NOTO_SANS_MAYBE_CJK = ScriptResourceUtil.readFont(NOTO_SANS_CJK_LOCATION);
                    }
                    catch (Exception ex) {
                        ScriptManager.LOGGER.warn("[Scripting] Failed to load font", (Throwable)ex);
                    }
                } else {
                    try {
                        NOTO_SANS_MAYBE_CJK = ScriptResourceUtil.readFont(NOTO_SANS_LOCATION);
                    }
                    catch (Exception ex) {
                        ScriptManager.LOGGER.warn("[Scripting] Failed to load font", (Throwable)ex);
                    }
                }
            }
            return NOTO_SANS_MAYBE_CJK;
        }
        if (fontName.equals("Noto Serif")) {
            if (NOTO_SERIF_CACHE == null) {
                try {
                    NOTO_SERIF_CACHE = ScriptResourceUtil.readFont(NOTO_SERIF_LOCATION);
                }
                catch (Exception ex) {
                    ScriptManager.LOGGER.warn("[Scripting] Failed loading font", (Throwable)ex);
                    return null;
                }
            }
            return NOTO_SERIF_CACHE;
        }
        return new Font(fontName, 0, 1);
    }

    public static FontRenderContext getFontRenderContext() {
        return FONT_CONTEXT;
    }

    public static AttributedString ensureStrFonts(String text, Font font) {
        AttributedString result = new AttributedString(text);
        if (text.isEmpty()) {
            return result;
        }
        result.addAttribute(TextAttribute.FONT, font, 0, text.length());
        for (int characterIndex = 0; characterIndex < text.length(); ++characterIndex) {
            char character = text.charAt(characterIndex);
            if (font.canDisplay(character)) continue;
            Font defaultFont = null;
            for (Font testFont : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!testFont.canDisplay(character)) continue;
                defaultFont = testFont;
                break;
            }
            Font newFont = (defaultFont == null ? new Font(null) : defaultFont).deriveFont(font.getStyle(), font.getSize2D());
            result.addAttribute(TextAttribute.FONT, newFont, characterIndex, characterIndex + 1);
        }
        return result;
    }

    public static BufferedImage readBufferedImage(Identifier identifier) {
        BufferedImage[] result = new BufferedImage[]{null};
        ResourceManagerHelper.readResource((Identifier)identifier, is -> {
            try {
                result[0] = ImageIO.read(is);
            }
            catch (IOException e) {
                ScriptManager.LOGGER.error("[Scripting] Failed to read image:", (Throwable)e);
            }
        });
        return GraphicsTexture.createArgbBufferedImage(result[0]);
    }

    public static Font readFont(Identifier identifier) {
        Font[] result = new Font[]{null};
        ResourceManagerHelper.readResource((Identifier)identifier, is -> {
            try {
                result[0] = Font.createFont(0, is);
            }
            catch (FontFormatException | IOException e) {
                ScriptManager.LOGGER.error("[Scripting] Failed to read font:", (Throwable)e);
            }
        });
        return result[0];
    }

    public static String getAddonVersion(String modid) {
        return ScriptingAPI.getAddonVersion(modid);
    }

    @Deprecated
    public static String getMTRVersion() {
        return ScriptResourceUtil.getAddonVersion("mtr");
    }

    @Deprecated
    public static String getNTEVersion() {
        return "0.5.2+1.19.2";
    }

    @Deprecated
    public static int getNTEVersionInt() {
        return 502;
    }

    @Deprecated
    public static int getNTEProtoVersion() {
        return 2;
    }

    private static Identifier resolveRelativePath(Identifier baseFile, String relative) {
        Object result = relative.toLowerCase(Locale.ROOT).replace('\\', '/');
        if (((String)result).contains(":")) {
            result = ((String)result).replaceAll("[^a-z0-9/.:_-]", "_");
            return new Identifier((String)result);
        }
        if (((String)(result = ((String)result).replaceAll("[^a-z0-9/._-]", "_"))).endsWith(".jpg") || ((String)result).endsWith(".bmp") || ((String)result).endsWith(".tga")) {
            String var10000 = ((String)result).substring(0, ((String)result).length() - 4);
            result = var10000 + ".png";
        }
        return new Identifier(baseFile.getNamespace(), FileSystems.getDefault().getPath(baseFile.getPath(), new String[0]).getParent().resolve((String)result).normalize().toString().replace('\\', '/'));
    }

    static {
        scriptLocationStack = new Stack();
        NOTO_SANS_CJK_LOCATION = new Identifier("mtr", "font/noto-sans-cjk-tc-medium.otf");
        NOTO_SANS_LOCATION = new Identifier("mtr", "font/noto-sans-semibold.ttf");
        NOTO_SERIF_LOCATION = new Identifier("mtr", "font/noto-serif-cjk-tc-semibold.ttf");
        hasNotoSansCjk = false;
        FONT_CONTEXT = new FontRenderContext(new AffineTransform(), true, false);
    }
}

